/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SKMDate {
    private Calendar mCalendar = Calendar.getInstance();

    public SKMDate() {
    }

    public SKMDate(long millisec) {
        this.mCalendar.setTimeInMillis(millisec);
    }

    public SKMDate(String dateStr) {
        try {
            this.mCalendar.setTime(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").parse(dateStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public int getYear() {
        return this.mCalendar.get(1);
    }

    public int getMonth() {
        return this.mCalendar.get(2);
    }

    public int getDate() {
        return this.mCalendar.get(5);
    }

    public int getWeekOfYear() {
        return this.mCalendar.get(3) - 1;
    }

    public int getDayOfWeek() {
        return this.mCalendar.get(7) % 7;
    }

    public int getHour() {
        return this.mCalendar.get(11);
    }

    public int getMinute() {
        return this.mCalendar.get(12);
    }

    public int getSecond() {
        return this.mCalendar.get(13);
    }

    public long getTime() {
        return this.mCalendar.getTimeInMillis();
    }

    public Date getImpl() {
        return this.mCalendar.getTime();
    }

    public String getDateString() {
        return DateFormat.getDateInstance(2).format(this.mCalendar.getTime());
    }

    public String getTimeString() {
        return DateFormat.getTimeInstance(3).format(this.mCalendar.getTime());
    }

    public String getDateTimeString() {
        return DateFormat.getDateTimeInstance(2, 3).format(this.mCalendar.getTime());
    }

    public String getDateTimeLongString() {
        return DateFormat.getDateTimeInstance(1, 2).format(this.mCalendar.getTime());
    }

    public String getDefaultTimeString() {
        return String.format("%02d:%02d:%02d", this.getHour(), this.getMinute(), this.getSecond());
    }

    public String getDefaultDateTimeString() {
        return String.format("%04d/%02d/%02d %02d:%02d:%02d", this.getYear(), this.getMonth() + 1, this.getDate(), this.getHour(), this.getMinute(), this.getSecond());
    }
}

