/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGradient;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMMath;
import jp.ne.sk_mine.util.andr_applet.SKMPoint;
import jp.ne.sk_mine.util.andr_applet.SKMPolygon;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMGraphics {
    public static final int GRAY = 0;
    public static final int WHITE = 1;
    public static final int YELLOW = 2;
    private static int frameCount;
    private ImageObserver mObserver;
    private Graphics2D g;
    private FontMetrics mFontMetrics;
    private Font mFont;
    private ArrayList<Stroke> mPrevStrokes;
    private ArrayList<AffineTransform> mPrevTransforms;

    public SKMGraphics(ImageObserver observer) {
        this.mObserver = observer;
        this.mPrevStrokes = new ArrayList();
        this.mPrevTransforms = new ArrayList();
    }

    public SKMGraphics(ImageObserver observer, Graphics2D g) {
        this(observer);
        this.setGraphics(g);
        this.mFontMetrics = g.getFontMetrics();
    }

    public void setGraphics(Graphics2D g) {
        this.g = g;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public SKMGraphics getCopy() {
        return new SKMGraphics(null, this.g);
    }

    public void drawFrame(int x, int y, int w, int h, int frameWeight, int colorId) {
        this.drawFrame(x, y, w, h, frameWeight, colorId, false);
    }

    public void drawFrame(int x, int y, int w, int h, int frameWeight, int colorId, boolean isBlink) {
        boolean isSelected = false;
        boolean isCursorMarked = false;
        if (colorId == 0) {
            isSelected = false;
            isCursorMarked = false;
        } else if (colorId == 1) {
            isSelected = true;
            isCursorMarked = false;
        } else if (colorId == 2) {
            isSelected = false;
            isCursorMarked = true;
        }
        this.drawFrame(x, y, w, h, frameWeight, isSelected, isCursorMarked, isBlink);
    }

    public void drawFrame(int x, int y, int w, int h, int frameWeight, boolean isSelected, boolean isCursorMarked, boolean isBlink) {
        int arcY;
        int arcX;
        int arcWidth;
        int offset;
        int c;
        int i;
        int colorD = (int)(30.0 * (isBlink ? Math.sin((double)(2 * frameCount++) * (Math.PI / 180)) : 1.0));
        int frameWidth = w - 2 * frameWeight;
        int frameHeight = h - 2 * frameWeight;
        int xOffset = frameWeight >> 1;
        int yOffset = frameWeight >> 1;
        for (i = frameWeight >> 1; 0 <= i; --i) {
            c = 255 - i * 30;
            if (!isSelected && !isCursorMarked) {
                c >>= 1;
            }
            if (!isSelected && isCursorMarked) {
                if (255 < (c += colorD)) {
                    c = 255;
                }
                if (c < 0) {
                    c = 0;
                }
                this.g.setColor(new Color(c, c, 0));
            } else {
                this.g.setColor(new Color(c, c, c));
            }
            int lineX = x + frameWeight;
            int lineY = y + yOffset + i;
            this.g.drawLine(lineX, lineY, lineX + frameWidth, lineY);
            lineY = y + yOffset - i;
            this.g.drawLine(lineX, lineY, lineX + frameWidth, lineY);
            lineY = y + h - yOffset + i;
            this.g.drawLine(lineX, lineY, lineX + frameWidth, lineY);
            lineY = y + h - yOffset - i;
            this.g.drawLine(lineX, lineY, lineX + frameWidth, lineY);
            lineX = x + xOffset + i;
            lineY = y + frameWeight;
            this.g.drawLine(lineX, lineY, lineX, lineY + frameHeight);
            lineX = x + xOffset - i;
            this.g.drawLine(lineX, lineY, lineX, lineY + frameHeight);
            lineX = x + w - yOffset + i;
            this.g.drawLine(lineX, lineY, lineX, lineY + frameHeight);
            lineX = x + w - yOffset - i;
            this.g.drawLine(lineX, lineY, lineX, lineY + frameHeight);
        }
        for (i = frameWeight >> 1; 0 <= i; --i) {
            c = 255 - i * 30;
            if (!isSelected && !isCursorMarked) {
                c >>= 1;
            }
            if (!isSelected && isCursorMarked) {
                if (255 < (c += colorD)) {
                    c = 255;
                }
                if (c < 0) {
                    c = 0;
                }
                this.g.setColor(new Color(c, c, 0));
            } else {
                this.g.setColor(new Color(c, c, c));
            }
            offset = (frameWeight >> 1) - i;
            arcWidth = 2 * (frameWeight - offset);
            arcX = x + offset;
            arcY = y + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 90, 90);
            arcX = x + offset;
            arcY = y + h - 2 * frameWeight + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 180, 90);
            arcX = x + w - 2 * frameWeight + offset;
            arcY = y + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 0, 90);
            arcX = x + w - 2 * frameWeight + offset;
            arcY = y + h - 2 * frameWeight + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 270, 90);
        }
        for (i = frameWeight >> 1; 0 <= i; --i) {
            c = 255 - ((frameWeight >> 1) - i) * 30;
            if (!isSelected && !isCursorMarked) {
                c >>= 1;
            }
            if (!isSelected && isCursorMarked) {
                if (255 < (c += colorD)) {
                    c = 255;
                }
                if (c < 0) {
                    c = 0;
                }
                this.g.setColor(new Color(c, c, 0));
            } else {
                this.g.setColor(new Color(c, c, c));
            }
            offset = frameWeight - i;
            arcWidth = 2 * (frameWeight - offset);
            arcX = x + offset;
            arcY = y + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 90, 90);
            arcX = x + offset;
            arcY = y + h - 2 * frameWeight + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 180, 90);
            arcX = x + w - 2 * frameWeight + offset;
            arcY = y + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 0, 90);
            arcX = x + w - 2 * frameWeight + offset;
            arcY = y + h - 2 * frameWeight + offset;
            this.g.fillArc(arcX, arcY, arcWidth, arcWidth, 270, 90);
        }
    }

    public void setColor(SKMColor color) {
        this.g.setColor(color.getColor());
    }

    public void setFont(SKMFont font) {
        this.mFont = font.getFont();
        this.mFontMetrics = this.getGraphics().getFontMetrics(this.mFont);
        this.g.setFont(this.mFont);
    }

    public void drawImage(SKMImage image, int x, int y) {
        this.drawImage(image, x, y, false, false);
    }

    public void drawImage(SKMImage image, int x, int y, boolean isReverseH, boolean isReverseV) {
        int w = image.getWidth();
        int h = image.getHeight();
        int bw = image.getBaseWidth();
        int bh = image.getBaseHeight();
        int sx0 = isReverseH ? bw : 0;
        int sx1 = isReverseH ? 0 : bw;
        int sy0 = isReverseV ? bh : 0;
        int sy1 = isReverseV ? 0 : bh;
        int alpha = image.getAlpha();
        if (alpha == 0) {
            return;
        }
        Composite basic = this.g.getComposite();
        this.g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
        this.g.drawImage(image.getImage(), x, y, x + w, y + h, sx0, sy0, sx1, sy1, this.mObserver);
        this.g.setComposite(basic);
    }

    public void drawCenteringImage(SKMImage image, int x, int y) {
        this.drawImage(image, x - (image.getWidth() >> 1), y - (image.getHeight() >> 1));
    }

    public void drawCenteringImage(SKMImage image, int x, int y, boolean isReverseH, boolean isReverseV) {
        this.drawImage(image, x - (image.getWidth() >> 1), y - (image.getHeight() >> 1), isReverseH, isReverseV);
    }

    public int stringWidth(String string) {
        return this.mFontMetrics.stringWidth(string);
    }

    public int stringHeight() {
        return this.mFontMetrics.getHeight();
    }

    public int getAscent() {
        return this.mFontMetrics.getAscent();
    }

    public int getDescent() {
        return this.mFontMetrics.getDescent();
    }

    public void drawString(String string, int x, int y) {
        this.g.drawString(string, x, y);
    }

    public SKMPoint getCenteringStringPosition(String string, int centerX, int centerY) {
        Point p = SKMGraphics.getStringPosition(this.getGraphics(), string, centerX, centerY);
        return new SKMPoint(p.x, p.y);
    }

    public void drawCenteringString(String string, int centerX, int centerY) {
        Point xy = SKMGraphics.getStringPosition(this.g, string, centerX, centerY);
        this.g.drawString(string, xy.x, xy.y);
    }

    public void drawShadowString(String string, int x, int y, SKMColor color, SKMColor roundColor, int shadeOffset) {
        this.g.setColor(roundColor.getColor());
        this.g.drawString(string, x + shadeOffset, y + shadeOffset);
        this.g.setColor(color.getColor());
        this.g.drawString(string, x, y);
    }

    public void drawCenteringShadowString(String string, int centerX, int centerY, SKMColor color, SKMColor roundColor) {
        this.drawCenteringShadowString(string, centerX, centerY, color, roundColor, this.g.getFont().getSize() / 14 + 2);
    }

    public void drawCenteringShadowString(String string, int centerX, int centerY, SKMColor color, SKMColor roundColor, int shadeOffset) {
        Point xy = SKMGraphics.getStringPosition(this.g, string, centerX, centerY);
        this.drawShadowString(string, xy.x, xy.y, color, roundColor, shadeOffset);
    }

    public void drawRoundedString(String string, int x, int y, SKMColor color, SKMColor roundColor) {
        this.drawRoundedString(string, x, y, color, roundColor, 1);
    }

    public void drawRoundedString(String string, int x, int y, SKMColor color, SKMColor roundColor, int roundOffset) {
        this.g.setColor(roundColor.getColor());
        this.g.drawString(string, x + roundOffset, y + roundOffset);
        this.g.drawString(string, x + roundOffset, y - roundOffset);
        this.g.drawString(string, x - roundOffset, y + roundOffset);
        this.g.drawString(string, x - roundOffset, y - roundOffset);
        this.g.drawString(string, x, y + roundOffset);
        this.g.drawString(string, x, y - roundOffset);
        this.g.drawString(string, x + roundOffset, y);
        this.g.drawString(string, x - roundOffset, y);
        this.g.setColor(color.getColor());
        this.g.drawString(string, x, y);
    }

    public void drawRoundedString(String string, int x, int y, SKMColor color, SKMColor roundColor, int roundOffset, boolean isZurashi) {
        this.drawRoundedString(string, x, y, color, roundColor, roundOffset);
    }

    public void drawCenteringRoundedString(String string, int centerX, int centerY, SKMColor color, SKMColor roundColor) {
        this.drawCenteringRoundedString(string, centerX, centerY, color, roundColor, 1);
    }

    public void drawCenteringRoundedString(String string, int centerX, int centerY, SKMColor color, SKMColor roundColor, int roundOffset) {
        Point xy = SKMGraphics.getStringPosition(this.g, string, centerX, centerY);
        this.drawRoundedString(string, xy.x, xy.y, color, roundColor, roundOffset);
    }

    public void drawCenteringRoundedString(String string, int centerX, int centerY, SKMColor color, SKMColor roundColor, int roundOffset, boolean isZurashi) {
        this.drawCenteringRoundedString(string, centerX, centerY, color, roundColor, roundOffset);
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        this.g.drawLine(x0, y0, x1, y1);
    }

    public void drawWideLine(int x0, int y0, int x1, int y1, double width) {
        double rad = SKMMath.getRad(x0, y0, x1, y1);
        double dx = x0 - x1;
        double dy = y0 - y1;
        int len = SKMUtil.toInt(SKMMath.sqrt(dx * dx + dy * dy));
        this.saveStroke();
        this.setStroke(1.0f);
        this.saveTransform();
        this.rotate(rad, x0, y0);
        this.g.fillRect(x0, y0 - (int)width / 2, len, (int)width);
        this.restoreTransform();
        this.restoreStroke();
    }

    public void drawRect(int x, int y, int w, int h) {
        this.g.drawRect(x, y, w, h);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.g.fillRect(x, y, w, h);
    }

    public void drawRoundRect(int x, int y, int w, int h, int rw, int rh) {
        this.g.drawRoundRect(x, y, w, h, rw, rh);
    }

    public void fillRoundRect(int x, int y, int w, int h, int rw, int rh) {
        this.g.fillRoundRect(x, y, w, h, rw, rh);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.g.drawOval(x, y, w, h);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.g.fillOval(x, y, w, h);
    }

    public void drawArc(int x, int y, int w, int h, int startDeg, int sweepDeg) {
        this.g.drawArc(x, y, w, h, startDeg, sweepDeg);
    }

    public void fillArc(int x, int y, int w, int h, int startDeg, int sweepDeg) {
        this.g.fillArc(x, y, w, h, startDeg, sweepDeg);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints) {
        this.g.drawPolygon(xPoints, yPoints, xPoints.length);
    }

    public void drawPolygon(int[][] pointXys) {
        this.g.drawPolygon(pointXys[0], pointXys[1], pointXys[0].length);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints) {
        this.g.fillPolygon(xPoints, yPoints, xPoints.length);
    }

    public void fillPolygon(int[][] pointXys) {
        this.g.fillPolygon(pointXys[0], pointXys[1], pointXys[0].length);
    }

    public void clipRect(int x, int y, int w, int h) {
        this.g.clipRect(x, y, w, h);
    }

    public void clip(SKMPolygon polygon) {
        this.g.setClip(polygon.getPolygon());
    }

    public void clearClip() {
        this.g.setClip(null);
    }

    public void saveStroke() {
        this.mPrevStrokes.add(this.g.getStroke());
    }

    public void restoreStroke() {
        if (this.mPrevStrokes.size() != 0) {
            this.g.setStroke(this.mPrevStrokes.remove(this.mPrevStrokes.size() - 1));
        }
    }

    public void setStroke(float size) {
        this.g.setStroke(new BasicStroke(size));
    }

    public void saveTransform() {
        this.mPrevTransforms.add(this.g.getTransform());
    }

    public void restoreTransform() {
        if (this.mPrevTransforms.size() != 0) {
            this.g.setTransform(this.mPrevTransforms.remove(this.mPrevTransforms.size() - 1));
        }
    }

    public void translate(double tx, double ty) {
        this.g.translate(tx, ty);
    }

    public void scale(double s) {
        this.g.scale(s, s);
    }

    public void scale(double sx, double sy) {
        this.g.scale(sx, sy);
    }

    public void rotate(double rad, double x, double y) {
        this.g.rotate(rad, x, y);
    }

    public void setTransform(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.g.setTransform(new AffineTransform((float)m11, (float)m21, (float)m12, (float)m22, (float)m13, 23.0f));
    }

    public void transform(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.g.transform(new AffineTransform((float)m11, (float)m21, (float)m12, (float)m22, (float)m13, 23.0f));
    }

    public void setGradient(SKMGradient skmlg) {
        this.g.setPaint(skmlg == null ? null : skmlg.getGradient());
    }

    public int getMaxStringWidth(String ... strings) {
        int n = 0;
        for (int i = strings.length - 1; 0 <= i; --i) {
            int len = this.mFontMetrics.stringWidth(strings[i]);
            if (n >= len) continue;
            n = len;
        }
        return n;
    }

    public static String getColorHex(int color) {
        String red = Integer.toHexString((color & 0xFF0000) >>> 16);
        String green = Integer.toHexString((color & 0xFF00) >>> 8);
        String blue = Integer.toHexString(color & 0xFF);
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return red + green + blue;
    }

    public static final Point getStringPosition(Graphics g, String string, int centerX, int centerY) {
        FontMetrics fm = g.getFontMetrics();
        int x = centerX - (fm.stringWidth(string) >> 1);
        int y = centerY + (fm.getAscent() - fm.getDescent() >> 1);
        return new Point(x, y);
    }
}

