/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGradient;

public class SKMRadialGradient
implements SKMGradient {
    public static int CYCLE_NONE = 0;
    public static int CYCLE_REFLECT = 1;
    public static int CYCLE_REPEAT = 2;
    private RadialGradientPaint mGp;

    public SKMRadialGradient(float centerX, float centerY, float radius, SKMColor inColor, SKMColor outColor) {
        this(centerX, centerY, radius, inColor, outColor, CYCLE_NONE);
    }

    public SKMRadialGradient(float centerX, float centerY, float radius, SKMColor inColor, SKMColor outColor, int cycleType) {
        this.mGp = new RadialGradientPaint(centerX, centerY, radius, new float[]{0.0f, 1.0f}, new Color[]{inColor.getColor(), outColor.getColor()}, this.getCycleMethod(cycleType));
    }

    public SKMRadialGradient(float centerX, float centerY, float radius, float[] positions, SKMColor[] colors) {
        this(centerX, centerY, radius, positions, colors, CYCLE_NONE);
    }

    public SKMRadialGradient(float centerX, float centerY, float radius, float[] positions, SKMColor[] colors, int cycleType) {
        Color[] cols = new Color[colors.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = colors[i].getColor();
        }
        this.mGp = new RadialGradientPaint(centerX, centerY, radius, positions, cols, this.getCycleMethod(cycleType));
    }

    private MultipleGradientPaint.CycleMethod getCycleMethod(int cycle) {
        if (cycle == CYCLE_REFLECT) {
            return MultipleGradientPaint.CycleMethod.REFLECT;
        }
        if (cycle == CYCLE_REPEAT) {
            return MultipleGradientPaint.CycleMethod.REPEAT;
        }
        return MultipleGradientPaint.CycleMethod.NO_CYCLE;
    }

    @Override
    public MultipleGradientPaint getGradient() {
        return this.mGp;
    }
}

