/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.ne.sk_mine.util.andr_applet.ButtonCallback;
import jp.ne.sk_mine.util.andr_applet.KeyCallback;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.StateCallback;
import jp.ne.sk_mine.util.ui.ExJTextField;

public class SKMTextField
extends SKMUI {
    private static SKMFont sDefaultFont;
    private ExJTextField mTextField = new ExJTextField(16);
    private ButtonCallback mButtonCallback;
    private StateCallback mStateCallback;
    private KeyCallback mKeyCallback;

    public static void setDefaultFont(SKMFont font) {
        sDefaultFont = font;
    }

    public SKMTextField() {
        this.mTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SKMTextField.this.mButtonCallback != null) {
                    SKMTextField.this.mButtonCallback.pressed();
                }
            }
        });
        this.mTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SKMTextField.this.mKeyCallback != null) {
                    SKMTextField.this.mKeyCallback.keyPressed(e.getKeyCode());
                }
            }
        });
        this.mTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (SKMTextField.this.mStateCallback != null) {
                    SKMTextField.this.mStateCallback.changed();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (SKMTextField.this.mStateCallback != null) {
                    SKMTextField.this.mStateCallback.changed();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                if (SKMTextField.this.mStateCallback != null) {
                    SKMTextField.this.mStateCallback.changed();
                }
            }
        });
        if (sDefaultFont != null) {
            this.mTextField.setFont(sDefaultFont.getFont());
        }
        this.setImpl(this.mTextField);
    }

    public void setMaxLength(int max) {
        this.mTextField.setMaxLength(max);
    }

    public void setText(String text) {
        this.mTextField.setText(text);
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public void setHint(String hint) {
        this.mTextField.setHint(hint);
    }

    public void setFont(SKMFont font) {
        this.mTextField.setFont(font.getFont());
    }

    public void setButtonCallback(ButtonCallback callback) {
        this.mButtonCallback = callback;
    }

    public void setStateCallback(StateCallback callback) {
        this.mStateCallback = callback;
    }

    public void setKeyCallback(KeyCallback callback) {
        this.mKeyCallback = callback;
    }
}

