/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKMMath;

public class SKMVector2d {
    private double mX;
    private double mY;

    public SKMVector2d(double x, double y) {
        this.mX = x;
        this.mY = y;
    }

    public void setX(double x) {
        this.mX = x;
    }

    public void setY(double y) {
        this.mY = y;
    }

    public void setXY(double x, double y) {
        this.mX = x;
        this.mY = y;
    }

    public double getX() {
        return this.mX;
    }

    public double getY() {
        return this.mY;
    }

    public void plus(SKMVector2d v) {
        this.mX += v.mX;
        this.mY += v.mY;
    }

    public SKMVector2d getPlus(SKMVector2d v) {
        return new SKMVector2d(this.mX + v.mX, this.mY + v.mY);
    }

    public void minus(SKMVector2d v) {
        this.mX -= v.mX;
        this.mY -= v.mY;
    }

    public SKMVector2d getMinus(SKMVector2d v) {
        return new SKMVector2d(this.mX - v.mX, this.mY - v.mY);
    }

    public void multi(double d) {
        this.mX *= d;
        this.mY *= d;
    }

    public SKMVector2d getMulti(double d) {
        return new SKMVector2d(this.mX * d, this.mY * d);
    }

    public double dot(SKMVector2d v) {
        return this.mX * v.mX + this.mY * v.mY;
    }

    public double cross(SKMVector2d v) {
        return this.mX * v.mY - this.mY * v.mX;
    }

    public double length() {
        return SKMMath.sqrt(this.mX * this.mX + this.mY * this.mY);
    }

    public double length2() {
        return this.mX * this.mX + this.mY * this.mY;
    }

    public void normalize() {
        double len = this.length();
        this.mX /= len;
        this.mY /= len;
    }

    public SKMVector2d getNormalize() {
        double len = this.length();
        return new SKMVector2d(this.mX / len, this.mY / len);
    }
}

