/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class AnimNumber {
    private boolean mIsBigToUp;
    private boolean mIsUp;
    private boolean mIsRoundString;
    private int mNumber;
    private int mCountMax;
    private int mCount;
    private int mBaseX;
    private int mBaseY;
    private SKMFont mBaseFont;
    private SKMColor mBaseColor;
    private SKMColor mPlusColor;
    private SKMColor mMinusColor;
    private SKMColor mRoundColor;

    public AnimNumber(int baseX, int baseY, SKMFont baseFont) {
        this.mBaseX = baseX;
        this.mBaseY = baseY;
        this.mBaseFont = baseFont;
        this.mCountMax = 50;
        this.mCount = 50;
        this.mBaseColor = SKMColor.WHITE;
        this.mPlusColor = SKMColor.ORANGE;
        this.mMinusColor = SKMColor.RED;
        this.mRoundColor = SKMColor.BLACK;
    }

    public void setBigToUp(boolean f) {
        this.mIsBigToUp = f;
    }

    public void setRoundString(boolean f) {
        this.mIsRoundString = f;
    }

    public void setNumber(int number) {
        if (this.mNumber != number) {
            this.mCount = 0;
        }
        this.mIsUp = this.mNumber < number;
        this.mNumber = number;
    }

    public int getNumber() {
        return this.mNumber;
    }

    public void setBaseX(int x) {
        this.mBaseX = x;
    }

    public int getBaseX() {
        return this.mBaseX;
    }

    public void setBaseY(int y) {
        this.mBaseY = y;
    }

    public int getBaseY() {
        return this.mBaseY;
    }

    public void setBaseXY(int x, int y) {
        this.mBaseX = x;
        this.mBaseY = y;
    }

    public void setBaseColor(SKMColor color) {
        this.mBaseColor = color;
    }

    public void setPlusColor(SKMColor color) {
        this.mPlusColor = color;
    }

    public void setMinusColor(SKMColor color) {
        this.mMinusColor = color;
    }

    public void setRoundColor(SKMColor color) {
        this.mRoundColor = color;
    }

    public void setCountMax(int max) {
        this.mCountMax = max;
    }

    public void finishAnimation() {
        this.mCount = this.mCountMax;
    }

    public int getStringWidth(SKMGraphics g) {
        if (this.mCount == this.mCountMax) {
            g.setFont(this.mBaseFont);
        } else {
            g.setFont(new SKMFont(this.mBaseFont.getFontName(), SKMFont.BOLD, this.getCurrentFontSize()));
        }
        return g.stringWidth("" + this.mNumber);
    }

    public int getStringHeight(SKMGraphics g) {
        if (this.mCount == this.mCountMax) {
            g.setFont(this.mBaseFont);
        } else {
            g.setFont(new SKMFont(this.mBaseFont.getFontName(), SKMFont.BOLD, this.getCurrentFontSize()));
        }
        return g.stringHeight();
    }

    public void reset() {
        this.mNumber = 0;
        this.mCount = this.mCountMax;
    }

    public void move() {
        if (this.mCount < this.mCountMax) {
            ++this.mCount;
        }
    }

    public void paint(SKMGraphics g) {
        SKMColor mainColor;
        String text = "" + this.mNumber;
        int baseFontSize = this.mBaseFont.getSize();
        int fontSize = this.getCurrentFontSize();
        int textWidth = g.stringWidth(text);
        int rightX = this.mBaseX + g.stringWidth(text);
        if (this.mCount == this.mCountMax) {
            mainColor = this.mBaseColor;
            g.setFont(this.mBaseFont);
        } else {
            mainColor = this.mIsUp ? this.mPlusColor : this.mMinusColor;
            g.setFont(new SKMFont(this.mBaseFont.getFontName(), SKMFont.BOLD, fontSize));
            textWidth = g.stringWidth(text);
        }
        if (this.mIsRoundString) {
            if (this.mIsBigToUp) {
                g.drawRoundedString(text, rightX - textWidth, this.mBaseY - baseFontSize + fontSize, mainColor, this.mRoundColor);
            } else {
                g.drawRoundedString(text, rightX - textWidth, this.mBaseY, mainColor, this.mRoundColor);
            }
        } else {
            g.setColor(mainColor);
            if (this.mIsBigToUp) {
                g.drawString(text, rightX - textWidth, this.mBaseY - baseFontSize + fontSize);
            } else {
                g.drawString(text, rightX - textWidth, this.mBaseY);
            }
        }
    }

    private int getCurrentFontSize() {
        int baseFontSize = this.mBaseFont.getSize();
        if (this.mCount == this.mCountMax) {
            return baseFontSize;
        }
        return baseFontSize + 2 * (this.mCountMax - this.mCount);
    }
}

