/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMLinearGradient;
import jp.ne.sk_mine.util.andr_applet.game.CButton;

public class DarkGlazeButton
extends CButton {
    public DarkGlazeButton(String text, SKMFont font) {
        super(text);
        this.setFont(font);
        this.init();
    }

    public DarkGlazeButton(SKMImage image) {
        super(image);
        this.mIsDrawBackground = true;
        this.init();
    }

    private void init() {
        this.setVisible(false);
        this.mTextColor = new SKMColor(240, 240, 240);
        this.setBackgroundColors(new SKMColor(120, 120, 120), new SKMColor(70, 70, 70));
    }

    @Override
    public void setBackgroundColors(SKMColor topColor, SKMColor bottomColor) {
        super.setBackgroundColors(topColor, bottomColor);
        this.setFrameColor(bottomColor);
    }

    @Override
    protected void paintBackground(SKMGraphics g) {
        SKMColor topColor = this.mTopColor;
        SKMColor bottomColor = this.mBottomColor;
        if (this.mIsPressed || !this.mIsEnabled) {
            topColor = topColor.darker();
            bottomColor = bottomColor.darker();
        }
        SKMLinearGradient lg = new SKMLinearGradient((float)this.mX, (float)(this.mY - this.mPadH), topColor, (float)this.mX, this.mY + this.mHeight + 2 * this.mPadH, bottomColor);
        g.setGradient(lg);
        g.fillRoundRect(this.mX - this.mPadW, this.mY - this.mPadH, this.mWidth + 2 * this.mPadW, this.mHeight + 2 * this.mPadH, 12, 12);
        g.setGradient(null);
        SKMColor brightTopColor = topColor.brighter();
        SKMColor brightBottomColor = bottomColor.brighter();
        SKMLinearGradient lgb = new SKMLinearGradient((float)this.mX, (float)(this.mY - this.mPadH), brightTopColor, (float)this.mX, this.mY + this.mHeight + this.mPadH, brightBottomColor);
        g.setGradient(lgb);
        g.fillRoundRect(this.mX - this.mPadW, this.mY - this.mPadH, this.mWidth + 2 * this.mPadW, this.mHeight / 2 + this.mPadH - 4, 12, 12);
        g.setGradient(null);
    }

    @Override
    protected void paintRoundFrame(SKMGraphics g) {
        g.saveStroke();
        g.setStroke(2.0f);
        g.setColor(this.mIsMouseOver ? this.mFrameColorOnMouseOver : this.mFrameColor);
        g.drawRoundRect(this.mX - this.mPadW, this.mY - this.mPadH, this.mWidth + 2 * this.mPadW, this.mHeight + 2 * this.mPadH, 12, 12);
        g.restoreStroke();
    }
}

