/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;

final class MidiSequencer
implements ControllerEventListener,
MetaEventListener {
    private Sequencer sequencer_;
    private boolean isLoop_;
    private long loopStartPoint_;

    MidiSequencer(Sequence bgm) {
        this.initSequencer(bgm);
    }

    void initSequencer(Sequence bgm) {
        try {
            this.sequencer_ = MidiSystem.getSequencer();
            this.sequencer_.open();
            this.sequencer_.addControllerEventListener(this, new int[]{111});
            this.sequencer_.addMetaEventListener(this);
            this.sequencer_.setSequence(bgm);
            this.loopStartPoint_ = 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void closeSequencer() {
        if (this.sequencer_ != null) {
            this.sequencer_.stop();
            this.sequencer_.removeMetaEventListener(this);
            this.sequencer_.close();
            this.sequencer_ = null;
        }
    }

    void preload() {
        this.play();
        this.pause();
    }

    void play() {
        this.sequencer_.start();
    }

    boolean isPlaying() {
        return this.sequencer_.isRunning();
    }

    void pause() {
        try {
            this.sequencer_.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void stop() {
        try {
            this.sequencer_.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.sequencer_.setTickPosition(0L);
    }

    boolean isLoop() {
        return this.isLoop_;
    }

    void setLoop(boolean isLoop) {
        this.isLoop_ = isLoop;
    }

    @Override
    public void controlChange(ShortMessage event) {
        long nowPosition = this.sequencer_.getMicrosecondPosition();
        if (event.getData1() == 111 && this.loopStartPoint_ == 0L) {
            this.loopStartPoint_ = nowPosition;
        }
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47 && this.isLoop_) {
            this.sequencer_.setMicrosecondPosition(this.loopStartPoint_);
            this.sequencer_.start();
        }
    }
}

