/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.io.InputStream;
import javazoom.jl.player.advanced.PlaybackListener;
import jp.ne.sk_mine.util.sound.MyMp3Player;

class Mp3PlayThread {
    private boolean mIsLoop;
    private boolean mIsPlaying;
    private boolean mIsPausing;
    private boolean mIsLoopPlay;
    private int mLoopStartPos;
    private MyMp3Player mPlayer;
    private String mResourceName;
    private Mp3Thread mThread;

    Mp3PlayThread(String resourceName) {
        this.mResourceName = resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        if (this.mIsPausing) {
            this.mIsPausing = false;
            if (this.mThread != null) {
                Mp3Thread mp3Thread = this.mThread;
                synchronized (mp3Thread) {
                    this.mThread.notify();
                }
            }
            return;
        }
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.mResourceName);
            this.mPlayer = new MyMp3Player(in);
            if (this.mIsLoopPlay) {
                for (int i = 0; i < this.mLoopStartPos; ++i) {
                    this.mPlayer.skipFrame();
                }
            }
            this.mPlayer.setPlayBackListener(new PlaybackListener(){});
        }
        catch (Exception e) {
            return;
        }
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
        this.mThread = new Mp3Thread();
        this.mThread.start();
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public boolean isPausing() {
        return this.mIsPausing;
    }

    public void setLoop(boolean isLoop) {
        this.mIsLoop = isLoop;
    }

    public void setLoop(boolean isLoop, int loopStartPos) {
        this.mIsLoop = isLoop;
        this.mLoopStartPos = loopStartPos;
    }

    public boolean isLoop() {
        return this.mIsLoop;
    }

    public void pause() {
        this.mIsPausing = true;
    }

    public void stop() {
        this.mIsPlaying = false;
        this.mIsLoopPlay = false;
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer = null;
        }
    }

    public void finalize() {
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Mp3Thread
    extends Thread {
        private boolean mIsRunning;

        Mp3Thread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mIsRunning = true;
            Mp3PlayThread.this.mIsPlaying = true;
            boolean ret = true;
            while (ret && this.mIsRunning) {
                Mp3Thread mp3Thread = this;
                synchronized (mp3Thread) {
                    while (Mp3PlayThread.this.mIsPausing) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (Mp3PlayThread.this.mPlayer == null) continue;
                ret = Mp3PlayThread.this.mPlayer.decode();
            }
            if (Mp3PlayThread.this.mIsPlaying && Mp3PlayThread.this.mIsLoop) {
                Mp3PlayThread.this.mIsLoopPlay = true;
                Mp3PlayThread.this.play();
            } else {
                Mp3PlayThread.this.mIsPlaying = false;
            }
            this.mIsRunning = false;
        }

        public void stopThread() {
            Mp3PlayThread.this.mIsPlaying = false;
            this.mIsRunning = false;
        }
    }
}

