/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination;

import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.IPageChangedListener;
import org.eclipse.nebula.widgets.pagination.IPageContentProvider;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractPageControllerComposite
extends Composite
implements IPageChangedListener {
    private PageableController controller;
    private Locale locale = Locale.getDefault();
    private IPageContentProvider pageContentProvider;

    public AbstractPageControllerComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public AbstractPageControllerComposite(Composite parent, int style, PageableController controller) {
        this(parent, style, controller, 10, null, true);
    }

    public AbstractPageControllerComposite(Composite parent, int style, int pageSize, IPageContentProvider pageContentProvider) {
        this(parent, style, null, pageSize, pageContentProvider, true);
    }

    protected AbstractPageControllerComposite(Composite parent, int style, PageableController controller, int pageSize, IPageContentProvider pageContentProvider, boolean createUI) {
        super(parent, style);
        this.pageContentProvider = pageContentProvider;
        this.controller = controller != null ? controller : this.createController(pageSize);
        PaginationHelper.setController((Widget)this, controller);
        if (createUI) {
            this.createUI(this);
        }
        this.controller.addPageChangedListener(this);
    }

    protected PageableController createController(int pageSize) {
        if (this.pageContentProvider != null) {
            return this.pageContentProvider.createController(pageSize);
        }
        return new PageableController(pageSize);
    }

    public PageableController getController() {
        return this.controller;
    }

    public void setCurrentPage(int currentPage) {
        this.getController().setCurrentPage(currentPage);
    }

    public void dispose() {
        this.getController().removePageChangedListener(this);
        super.dispose();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void localeChanged(Locale oldLocale, Locale newLocale, PageableController paginationController) {
        this.setLocale(newLocale);
    }

    public IPageContentProvider getPageContentProvider() {
        return this.pageContentProvider;
    }

    protected abstract void createUI(Composite var1);
}

