/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination;

import java.util.List;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.pagination.IPageChangedListener;
import org.eclipse.nebula.widgets.pagination.IPageContentProvider;
import org.eclipse.nebula.widgets.pagination.IPageLoader;
import org.eclipse.nebula.widgets.pagination.IPageLoaderHandler;
import org.eclipse.nebula.widgets.pagination.PageChangedAdapter;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.collections.PageResultContentProvider;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLoaderStrategyHelper {
    public static void loadPageAndReplaceItems(PageableController controller, Viewer viewer, IPageLoader<?> pageLoader, IPageContentProvider pageContentProvider, IPageLoaderHandler<PageableController> handler) {
        List<?> content;
        Object page = PageLoaderStrategyHelper.loadPageAndUpdateTotalElements(controller, pageLoader, pageContentProvider, handler);
        if (page != null && (content = pageContentProvider.getPaginatedList(page)) != null) {
            viewer.setInput(content);
        }
    }

    public static IPageChangedListener createLoadPageAndReplaceItemsListener(final PageableController controller, final StructuredViewer viewer, final IPageLoader<?> pageLoader, final IPageContentProvider pageContentProvider, final IPageLoaderHandler<PageableController> handler) {
        return new PageChangedAdapter(){

            public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller2) {
                PageLoaderStrategyHelper.loadPageAndReplaceItems(controller2, (Viewer)viewer, pageLoader, pageContentProvider, handler);
            }

            public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
                controller.reset();
            }

            public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController controller2) {
                controller2.reset();
            }
        };
    }

    public static void loadPageAndAddItems(PageableController controller, TableViewer viewer, IPageLoader<?> pageLoader, IPageContentProvider pageContentProvider, IPageLoaderHandler<PageableController> handler) {
        List<?> content;
        Object page = PageLoaderStrategyHelper.loadPageAndUpdateTotalElements(controller, pageLoader, pageContentProvider, handler);
        if (page != null && (content = pageContentProvider.getPaginatedList(page)) != null && !content.isEmpty()) {
            viewer.add(content.toArray());
            int count = viewer.getTable().getItemCount();
            if (count > 0) {
                TableItem item = viewer.getTable().getItem(count - 1);
                item.setData("___LAST_ITEM_LOADED", (Object)true);
            }
        }
    }

    public static IPageChangedListener createLoadPageAndAddItemsListener(PageableController controller, TableViewer viewer, IPageLoader<?> pageLoader, IPageLoaderHandler<PageableController> handler) {
        return PageLoaderStrategyHelper.createLoadPageAndAddItemsListener(controller, viewer, pageLoader, PageResultContentProvider.getInstance(), handler);
    }

    public static IPageChangedListener createLoadPageAndAddItemsListener(final PageableController controller, final TableViewer viewer, final IPageLoader<?> pageLoader, final IPageContentProvider pageContentProvider, final IPageLoaderHandler<PageableController> handler) {
        return new PageChangedAdapter(){

            public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller2) {
                PageLoaderStrategyHelper.loadPageAndAddItems(controller2, viewer, pageLoader, pageContentProvider, (IPageLoaderHandler<PageableController>)handler);
            }

            public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
                controller.reset();
            }

            public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController controller2) {
                controller2.reset();
            }
        };
    }

    public static void loadPageAndAddItems(PageableController controller, Object parentElementOrTreePath, TreeViewer viewer, IPageLoader<?> pageLoader, IPageContentProvider pageContentProvider, IPageLoaderHandler<PageableController> handler) {
        List<?> content;
        Object page = PageLoaderStrategyHelper.loadPageAndUpdateTotalElements(controller, pageLoader, pageContentProvider, handler);
        if (page != null && (content = pageContentProvider.getPaginatedList(page)) != null && !content.isEmpty()) {
            viewer.add(parentElementOrTreePath, content.toArray());
            int count = viewer.getTree().getItemCount();
            if (count > 0) {
                TreeItem item = viewer.getTree().getItem(count - 1);
                item.setData("___LAST_ITEM_LOADED", (Object)true);
            }
        }
    }

    public static IPageChangedListener createLoadPageAndAddItemsListener(final PageableController controller, final Object parentElementOrTreePath, final TreeViewer viewer, final IPageLoader<?> pageLoader, final IPageContentProvider pageContentProvider, final IPageLoaderHandler<PageableController> handler) {
        return new PageChangedAdapter(){

            public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller2) {
                PageLoaderStrategyHelper.loadPageAndAddItems(controller2, parentElementOrTreePath, viewer, pageLoader, pageContentProvider, handler);
            }

            public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
                controller.reset();
            }

            public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController controller2) {
                controller2.reset();
            }
        };
    }

    public static void loadPageAndAddItems(PageableController controller, AbstractListViewer viewer, IPageLoader<?> pageLoader, IPageContentProvider pageContentProvider, IPageLoaderHandler<PageableController> handler) {
        Object page = PageLoaderStrategyHelper.loadPageAndUpdateTotalElements(controller, pageLoader, pageContentProvider, handler);
        List<?> content = pageContentProvider.getPaginatedList(page);
        if (content != null && !content.isEmpty()) {
            viewer.add(content.toArray());
        }
    }

    public static IPageChangedListener createLoadPageAndAddItemsListener(final PageableController controller, final AbstractListViewer viewer, final IPageLoader<?> pageLoader, final IPageContentProvider pageContentProvider, final IPageLoaderHandler<PageableController> handler) {
        return new PageChangedAdapter(){

            public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller2) {
                PageLoaderStrategyHelper.loadPageAndAddItems(controller2, viewer, pageLoader, pageContentProvider, (IPageLoaderHandler<PageableController>)handler);
            }

            public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
                controller.reset();
            }

            public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController controller2) {
                controller2.reset();
            }
        };
    }

    public static Object loadPageAndUpdateTotalElements(PageableController controller, IPageLoader<?> pageLoader, IPageContentProvider pageContentProvider, IPageLoaderHandler<PageableController> handler) {
        Object page = null;
        if (handler == null) {
            page = PageLoaderStrategyHelper.loadPage(pageLoader, controller);
        } else {
            handler.onBeforePageLoad(controller);
            try {
                page = PageLoaderStrategyHelper.loadPage(pageLoader, controller);
                handler.onAfterPageLoad(controller, null);
            }
            catch (Throwable e) {
                boolean stop = handler.onAfterPageLoad(controller, e);
                if (stop) {
                    return null;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        controller.setTotalElements(pageContentProvider.getTotalElements(page));
        return page;
    }

    public static Object loadPage(IPageLoader<?> pageLoader, PageableController controller) {
        if (pageLoader == null) {
            throw new NullPointerException("PageLoader cannot be null!");
        }
        return pageLoader.loadPage(controller);
    }
}

