/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination;

import java.io.Serializable;
import java.util.Locale;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.nebula.widgets.pagination.IPageChangedListener;

public class PageableController
implements Serializable {
    private static final long serialVersionUID = 8456710060857724013L;
    public static final int DEFAULT_PAGE_INDEX = -1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private int currentPage = -1;
    private int pageSize;
    private long totalElements;
    private String sortPropertyName;
    private int sortDirection;
    private Locale locale = Locale.getDefault();
    private ListenerList pageChangedListeners = new ListenerList();

    public PageableController() {
        this(10);
    }

    public PageableController(int pageSize) {
        this.pageSize = pageSize;
        this.totalElements = 0L;
        this.sortPropertyName = null;
        this.sortDirection = 0;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null page changed listener");
        }
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        if (listener != null) {
            this.pageChangedListeners.remove((Object)listener);
        }
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPage() > 0;
    }

    public boolean isFirstPage() {
        return !this.hasPreviousPage();
    }

    public boolean hasNextPage() {
        return (long)((this.getCurrentPage() + 1) * this.getPageSize()) < this.totalElements;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (this.currentPage != currentPage) {
            int oldPageNumber = this.currentPage;
            this.currentPage = currentPage;
            this.notifyListenersForPageIndexChanged(oldPageNumber, currentPage);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            int oldPageSize = this.pageSize;
            this.pageSize = pageSize;
            this.notifyListenersForPageSizeChanged(oldPageSize, pageSize);
        }
    }

    public int getTotalPages() {
        return this.getPageSize() == 0 ? 0 : (int)Math.ceil((double)this.totalElements / (double)this.getPageSize());
    }

    public boolean isLastPage() {
        return !this.hasNextPage();
    }

    public void setTotalElements(long totalElements) {
        if (this.totalElements != totalElements) {
            long oldTotalElements = this.totalElements;
            this.totalElements = totalElements;
            this.notifyListenersForTotalElementsChanged(oldTotalElements, totalElements);
        }
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getPageOffset() {
        return this.getCurrentPage() * this.getPageSize();
    }

    public void setSort(String propertyName, int sortDirection) {
        if (this.sortPropertyName != propertyName || this.sortDirection != sortDirection) {
            String oldPopertyName = this.sortPropertyName;
            this.sortPropertyName = propertyName;
            int oldSortDirection = this.sortDirection;
            this.sortDirection = sortDirection;
            this.notifyListenersForSortChanged(oldPopertyName, propertyName, oldSortDirection, sortDirection);
        }
    }

    public String getSortPropertyName() {
        return this.sortPropertyName;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void reset() {
        int oldCurrentPage = this.currentPage;
        this.currentPage = 0;
        this.notifyListenersForPageIndexChanged(oldCurrentPage, this.currentPage);
    }

    public void setLocale(Locale locale) {
        Locale oldLocale = this.locale;
        this.locale = locale;
        if (!oldLocale.equals(locale)) {
            this.notifyListenersForLocaleChanged(oldLocale, locale);
        }
    }

    private void notifyListenersForPageIndexChanged(int oldPageNumber, int newPageNumber) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPageChangedListener listener = (IPageChangedListener)listeners[i];
            listener.pageIndexChanged(oldPageNumber, newPageNumber, this);
            ++i;
        }
    }

    private void notifyListenersForTotalElementsChanged(long oldTotalElements, long newTotalElements) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPageChangedListener listener = (IPageChangedListener)listeners[i];
            listener.totalElementsChanged(oldTotalElements, newTotalElements, this);
            ++i;
        }
    }

    private void notifyListenersForSortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPageChangedListener listener = (IPageChangedListener)listeners[i];
            listener.sortChanged(oldPopertyName, propertyName, oldSortDirection, sortDirection, this);
            ++i;
        }
    }

    private void notifyListenersForPageSizeChanged(int oldPageSize, int newPageSize) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPageChangedListener listener = (IPageChangedListener)listeners[i];
            listener.pageSizeChanged(oldPageSize, newPageSize, this);
            ++i;
        }
    }

    private void notifyListenersForLocaleChanged(Locale oldLocale, Locale newLocale) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPageChangedListener listener = (IPageChangedListener)listeners[i];
            listener.localeChanged(oldLocale, newLocale, this);
            ++i;
        }
    }
}

