/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.pagesize;

import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PageSizeComboRenderer
extends AbstractPageControllerComposite
implements SelectionListener {
    private ComboViewer comboViewer;
    private Label itemsPerPageLabel;

    public PageSizeComboRenderer(Composite parent, int style, PageableController controller, Integer[] pageSizeList) {
        super(parent, style, controller);
        this.comboViewer.setInput((Object)pageSizeList);
    }

    public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller) {
        Integer selected = this.getSelectedPageSize();
        if (selected == null) {
            this.selectPageSize(controller.getPageSize());
        }
    }

    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
    }

    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
        this.selectPageSize(newPageSize);
    }

    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.itemsPerPageLabel = new Label(parent, 0);
        this.itemsPerPageLabel.setText(Resources.getText("PaginationRenderer.itemsPerPage", this.getLocale()));
        this.itemsPerPageLabel.setLayoutData((Object)new GridData());
        this.comboViewer = new ComboViewer(parent, 8);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)InternalLabelProvider.getInstance());
        this.comboViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.comboViewer.getCombo().addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        this.comboViewer.getCombo().removeSelectionListener((SelectionListener)this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int pageSize = Integer.parseInt(this.comboViewer.getCombo().getItem(this.comboViewer.getCombo().getSelectionIndex()));
        this.getController().setPageSize(pageSize);
    }

    private void selectPageSize(int pageSize) {
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)pageSize));
    }

    private Integer getSelectedPageSize() {
        if (this.comboViewer.getSelection().isEmpty()) {
            return null;
        }
        return (Integer)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.itemsPerPageLabel.setText(Resources.getText("PaginationRenderer.itemsPerPage", this.getLocale()));
    }

    private static class InternalLabelProvider
    extends LabelProvider {
        private static final ILabelProvider INSTANCE = new InternalLabelProvider();

        private InternalLabelProvider() {
        }

        public static ILabelProvider getInstance() {
            return INSTANCE;
        }
    }
}

