/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.util.FixedBitSet;

public abstract class MergePolicy {
    protected static final double DEFAULT_NO_CFS_RATIO = 1.0;
    protected static final long DEFAULT_MAX_CFS_SEGMENT_SIZE = Long.MAX_VALUE;
    protected double noCFSRatio = 1.0;
    protected long maxCFSSegmentSize = Long.MAX_VALUE;

    public MergePolicy() {
        this(1.0, Long.MAX_VALUE);
    }

    protected MergePolicy(double defaultNoCFSRatio, long defaultMaxCFSSegmentSize) {
        this.noCFSRatio = defaultNoCFSRatio;
        this.maxCFSSegmentSize = defaultMaxCFSSegmentSize;
    }

    public abstract MergeSpecification findMerges(MergeTrigger var1, SegmentInfos var2, IndexWriter var3) throws IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentCommitInfo, Boolean> var3, IndexWriter var4) throws IOException;

    public abstract MergeSpecification findForcedDeletesMerges(SegmentInfos var1, IndexWriter var2) throws IOException;

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, IndexWriter writer) throws IOException {
        if (this.getNoCFSRatio() == 0.0) {
            return false;
        }
        long mergedInfoSize = this.size(mergedInfo, writer);
        if (mergedInfoSize > this.maxCFSSegmentSize) {
            return false;
        }
        if (this.getNoCFSRatio() >= 1.0) {
            return true;
        }
        long totalSize = 0L;
        for (SegmentCommitInfo info : infos) {
            totalSize += this.size(info, writer);
        }
        return (double)mergedInfoSize <= this.getNoCFSRatio() * (double)totalSize;
    }

    protected long size(SegmentCommitInfo info, IndexWriter writer) throws IOException {
        double delRatio;
        long byteSize = info.sizeInBytes();
        int delCount = writer.numDeletedDocs(info);
        double d = delRatio = info.info.getDocCount() <= 0 ? 0.0 : (double)((float)delCount / (float)info.info.getDocCount());
        assert (delRatio <= 1.0);
        return info.info.getDocCount() <= 0 ? byteSize : (long)((double)byteSize * (1.0 - delRatio));
    }

    protected final boolean isMerged(SegmentInfos infos, SegmentCommitInfo info, IndexWriter writer) throws IOException {
        assert (writer != null);
        boolean hasDeletions = writer.numDeletedDocs(info) > 0;
        return !hasDeletions && info.info.dir == writer.getDirectory() && this.useCompoundFile(infos, info, writer) == info.info.getUseCompoundFile();
    }

    public final double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public final void setNoCFSRatio(double noCFSRatio) {
        if (noCFSRatio < 0.0 || noCFSRatio > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + noCFSRatio);
        }
        this.noCFSRatio = noCFSRatio;
    }

    public final double getMaxCFSSegmentSizeMB() {
        return (double)(this.maxCFSSegmentSize / 1024L) / 1024.0;
    }

    public final void setMaxCFSSegmentSizeMB(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("maxCFSSegmentSizeMB must be >=0 (got " + v + ")");
        }
        this.maxCFSSegmentSize = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
    }

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge merge) {
            this.merges.add(merge);
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString());
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentCommitInfo info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public volatile long estimatedMergeBytes;
        volatile long totalMergeBytes;
        List<SegmentReader> readers;
        public final List<SegmentCommitInfo> segments;
        public final MergeRateLimiter rateLimiter;
        volatile long mergeStartNS = -1L;
        public final int totalDocCount;
        Throwable error;

        public OneMerge(List<SegmentCommitInfo> segments) {
            if (0 == segments.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentCommitInfo>(segments);
            int count = 0;
            for (SegmentCommitInfo info : segments) {
                count += info.info.getDocCount();
            }
            this.totalDocCount = count;
            this.rateLimiter = new MergeRateLimiter(this);
        }

        public void mergeFinished() throws IOException {
        }

        public List<CodecReader> getMergeReaders() throws IOException {
            if (this.readers == null) {
                throw new IllegalStateException("IndexWriter has not initialized readers from the segment infos yet");
            }
            ArrayList<SegmentReader> readers = new ArrayList<SegmentReader>(this.readers.size());
            for (SegmentReader reader : this.readers) {
                if (reader.numDocs() <= 0) continue;
                readers.add(reader);
            }
            return Collections.unmodifiableList(readers);
        }

        public void setInfo(SegmentCommitInfo info) {
            this.info = info;
        }

        public DocMap getDocMap(MergeState mergeState) {
            return new DocMap(){

                @Override
                public int map(int docID) {
                    return docID;
                }
            };
        }

        synchronized void setException(Throwable error) {
            this.error = error;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        public String segString() {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.get(i).toString());
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.info.name);
            }
            if (this.maxNumSegments != -1) {
                b.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.rateLimiter.getAbort()) {
                b.append(" [ABORTED]");
            }
            return b.toString();
        }

        public long totalBytesSize() throws IOException {
            return this.totalMergeBytes;
        }

        public int totalNumDocs() throws IOException {
            int total = 0;
            for (SegmentCommitInfo info : this.segments) {
                total += info.info.getDocCount();
            }
            return total;
        }

        public MergeInfo getMergeInfo() {
            return new MergeInfo(this.totalDocCount, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }
    }

    public static abstract class DocMap {
        protected DocMap() {
        }

        public abstract int map(int var1);

        boolean isConsistent(int maxDoc) {
            FixedBitSet targets = new FixedBitSet(maxDoc);
            for (int i = 0; i < maxDoc; ++i) {
                int target = this.map(i);
                if (target < 0 || target >= maxDoc) {
                    assert (false) : "out of range: " + target + " not in [0-" + maxDoc + "[";
                    return false;
                }
                if (!targets.get(target)) continue;
                assert (false) : target + " is already taken (" + i + ")";
                return false;
            }
            return true;
        }
    }
}

