/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;

public class MultiTermQueryWrapperFilter<Q extends MultiTermQuery>
extends Filter {
    protected final Q query;

    protected MultiTermQueryWrapperFilter(Q query) {
        this.query = query;
    }

    public String toString() {
        return ((Query)this.query).toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            return ((MultiTermQuery)this.query).equals(((MultiTermQueryWrapperFilter)o).query);
        }
        return false;
    }

    public final int hashCode() {
        return ((MultiTermQuery)this.query).hashCode();
    }

    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms(((MultiTermQuery)this.query).field);
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = ((MultiTermQuery)this.query).getTermsEnum(terms);
        assert (termsEnum != null);
        BitDocIdSet.Builder builder = new BitDocIdSet.Builder(context.reader().maxDoc());
        DocsEnum docs = null;
        while (termsEnum.next() != null) {
            docs = termsEnum.docs(acceptDocs, docs, 0);
            builder.or(docs);
        }
        return builder.build();
    }
}

