/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterCachingPolicy;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.util.FrequencyTrackingRingBuffer;

public final class UsageTrackingFilterCachingPolicy
implements FilterCachingPolicy {
    private static final int SENTINEL = Integer.MIN_VALUE;
    private final FilterCachingPolicy.CacheOnLargeSegments segmentPolicy;
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;
    private final int minFrequencyCostlyFilters;
    private final int minFrequencyCheapFilters;
    private final int minFrequencyOtherFilters;

    static boolean isCostly(Filter filter) {
        return filter instanceof MultiTermQueryWrapperFilter;
    }

    static boolean isCheapToCache(DocIdSet set) {
        return set == null || set.isCacheable();
    }

    public UsageTrackingFilterCachingPolicy(float minSizeRatio, int historySize, int minFrequencyCostlyFilters, int minFrequencyCheapFilters, int minFrequencyOtherFilters) {
        this(new FilterCachingPolicy.CacheOnLargeSegments(minSizeRatio), historySize, minFrequencyCostlyFilters, minFrequencyCheapFilters, minFrequencyOtherFilters);
    }

    public UsageTrackingFilterCachingPolicy() {
        this(FilterCachingPolicy.CacheOnLargeSegments.DEFAULT, 256, 2, 2, 5);
    }

    private UsageTrackingFilterCachingPolicy(FilterCachingPolicy.CacheOnLargeSegments segmentPolicy, int historySize, int minFrequencyCostlyFilters, int minFrequencyCheapFilters, int minFrequencyOtherFilters) {
        this.segmentPolicy = segmentPolicy;
        if (minFrequencyOtherFilters < minFrequencyCheapFilters || minFrequencyOtherFilters < minFrequencyCheapFilters) {
            throw new IllegalArgumentException("it does not make sense to cache regular filters more aggressively than filters that are costly to produce or cheap to cache");
        }
        if (minFrequencyCheapFilters > historySize || minFrequencyCostlyFilters > historySize || minFrequencyOtherFilters > historySize) {
            throw new IllegalArgumentException("The minimum frequencies should be less than the size of the history of filters that are being tracked");
        }
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
        this.minFrequencyCostlyFilters = minFrequencyCostlyFilters;
        this.minFrequencyCheapFilters = minFrequencyCheapFilters;
        this.minFrequencyOtherFilters = minFrequencyOtherFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUse(Filter filter) {
        UsageTrackingFilterCachingPolicy usageTrackingFilterCachingPolicy = this;
        synchronized (usageTrackingFilterCachingPolicy) {
            this.recentlyUsedFilters.add(filter.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldCache(Filter filter, LeafReaderContext context, DocIdSet set) throws IOException {
        int frequency;
        if (!this.segmentPolicy.shouldCache(filter, context, set)) {
            return false;
        }
        UsageTrackingFilterCachingPolicy usageTrackingFilterCachingPolicy = this;
        synchronized (usageTrackingFilterCachingPolicy) {
            frequency = this.recentlyUsedFilters.frequency(filter.hashCode());
        }
        if (frequency >= this.minFrequencyOtherFilters) {
            return true;
        }
        if (UsageTrackingFilterCachingPolicy.isCostly(filter) && frequency >= this.minFrequencyCostlyFilters) {
            return true;
        }
        return UsageTrackingFilterCachingPolicy.isCheapToCache(set) && frequency >= this.minFrequencyCheapFilters;
    }
}

