/*
 * Decompiled with CFR 0.152.
 */
package ui;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import ui.MainUI;
import ui.MyTable;

public class MyCompositeTable {
    private MyTable innerTable;
    private Composite innerComposite;
    final int ICONCOLUMNWIDTH = 99;

    public void selectAll() {
        this.innerTable.selectAll();
    }

    public void deSelectAll() {
        this.innerTable.deselectAll();
    }

    public MyCompositeTable(Composite comp, int style) {
        this.innerComposite = new Composite(comp, 0);
        this.innerTable = new MyTable(this.innerComposite, style);
    }

    public Composite getInnerComposite() {
        return this.innerComposite;
    }

    public MyTable getInnerTable() {
        return this.innerTable;
    }

    public void setMenu(Menu menu) {
        this.innerTable.setMenu(menu);
    }

    public void setInterface(MainUI mainobj) {
        this.innerTable.setInterface(mainobj);
    }

    public boolean isDisposed() {
        return this.innerTable.isDisposed();
    }

    public void setLayoutData(Object layoutData) {
        this.innerComposite.setLayoutData(layoutData);
    }

    public void AddEvents() {
        this.innerTable.AddEvents();
        this.innerComposite.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle area = MyCompositeTable.this.innerComposite.getClientArea();
                Point preferredSize = MyCompositeTable.this.innerTable.computeSize(-1, -1);
                int width = area.width - 2 * MyCompositeTable.this.innerTable.getBorderWidth();
                if (preferredSize.y > area.height + MyCompositeTable.this.innerTable.getHeaderHeight()) {
                    Point vBarSize = MyCompositeTable.this.innerTable.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = MyCompositeTable.this.innerTable.getSize();
                if (oldSize.x > area.width) {
                    MyCompositeTable.this.innerTable.getColumn(0).setWidth(99);
                    MyCompositeTable.this.innerTable.getColumn(1).setWidth(width * 2 / 3);
                    MyCompositeTable.this.innerTable.getColumn(2).setWidth(width - 99 - MyCompositeTable.this.innerTable.getColumn(1).getWidth());
                    MyCompositeTable.this.innerTable.setSize(area.width, area.height);
                } else {
                    MyCompositeTable.this.innerTable.setSize(area.width, area.height);
                    MyCompositeTable.this.innerTable.getColumn(0).setWidth(99);
                    MyCompositeTable.this.innerTable.getColumn(1).setWidth(width * 2 / 3);
                    MyCompositeTable.this.innerTable.getColumn(2).setWidth(width - 99 - MyCompositeTable.this.innerTable.getColumn(1).getWidth());
                }
            }
        });
    }

    public void removeAll() {
        this.innerTable.removeAll();
    }

    public TableItem[] getSelection() {
        return this.innerTable.getSelection();
    }

    public TableItem[] getItems() {
        return this.innerTable.getItems();
    }

    public TableItem CreateTableItem(int i) {
        return new TableItem(this.innerTable, 0, i);
    }
}

