/*
 * Decompiled with CFR 0.152.
 */
package ui;

import API.Win32API;
import biz.configclass;
import java.util.Date;
import ui.IndexingManager;
import ui.InterfaceUI;
import ui.UtilityClass;

public final class MyFileAlterationMonitor {
    private static boolean running;
    private static long default_interval;
    private static boolean bInit;
    static InterfaceUI baseUI;

    public MyFileAlterationMonitor(InterfaceUI _mainUI, long interval) {
        running = false;
        default_interval = interval;
        baseUI = _mainUI;
        UtilityClass.TimeMode _mode = UtilityClass.TimeMode.values()[configclass.getInstance("config.xml").getResidentMode()];
        UtilityClass._runSignal = _mode == UtilityClass.TimeMode.SPECIFIED_INTERVAL;
        bInit = true;
    }

    public void setRunImediate(boolean bRun) {
        UtilityClass._runSignal = bRun;
    }

    public void start() throws Exception {
        if (running) {
            throw new IllegalStateException("Monitor is already running");
        }
        running = true;
        this.run();
    }

    public void stop() throws Exception {
        if (UtilityClass.DebugMode) {
            System.out.println("--------stop()--------");
        }
        this.stop(default_interval);
    }

    public void stop(long stopInterval) throws Exception {
        if (!running) {
            throw new IllegalStateException("Monitor is not running");
        }
        running = false;
    }

    private int resetIdleCounter() {
        return Win32API.getIdleTimeMillisWin32();
    }

    public void run() {
        int idleCount = 0;
        while (running) {
            UtilityClass.TimeMode _mode = UtilityClass.TimeMode.values()[configclass.getInstance("config.xml").getResidentMode()];
            if (UtilityClass.DebugMode) {
                System.out.println("resident mode" + configclass.getInstance("config.xml").getResidentMode());
            }
            if (bInit && _mode != UtilityClass.TimeMode.SPECIFIED_INTERVAL && !UtilityClass.IsThreadRunning(UtilityClass._threadCreateIndexThreadOrSearch)) {
                if (UtilityClass.DebugMode) {
                    System.out.println("---check and notify start :send signal ---");
                }
                baseUI.SetStopSignal(false);
                IndexingManager.getFileIndexingQue().QueHandlerRealTime(baseUI.getSearchFolder());
                baseUI.SetStopSignal(true);
                UtilityClass._runSignal = false;
                if (bInit && UtilityClass.DebugMode) {
                    System.out.println("firsttime check and notify");
                }
                bInit = false;
            }
            if (UtilityClass._runSignal && !UtilityClass.IsThreadRunning(UtilityClass._threadCreateIndexThreadOrSearch)) {
                if (IndexingManager.getFileIndexingQue().getMap().size() > 0) {
                    if (UtilityClass.DebugMode) {
                        System.out.println("---check and notify start, update---");
                    }
                    baseUI.SetStopSignal(false);
                    IndexingManager.getFileIndexingQue().QueHandlerRealTime(baseUI.getSearchFolder());
                    idleCount = this.resetIdleCounter();
                    baseUI.OnCompleteUpdateIndex(_mode, baseUI.stop(), true);
                    baseUI.SetStopSignal(true);
                } else {
                    baseUI.OnCompleteUpdateIndex(_mode, baseUI.stop(), false);
                    if (UtilityClass.DebugMode) {
                        System.out.println("---no files changed,no need to update---");
                    }
                }
                UtilityClass._runSignal = false;
            }
            if (!running) {
                return;
            }
            try {
                if (_mode == UtilityClass.TimeMode.SPECIFIED_INTERVAL) {
                    long idleInterval = configclass.getInstance("config.xml").getIndexCreateInterval();
                    if (UtilityClass.DebugMode) {
                        System.out.println("inteval mode: idle time " + idleInterval);
                    }
                    Thread.sleep(default_interval);
                    int curElapse = Win32API.getIdleTimeMillisWin32();
                    if ((long)curElapse < default_interval) {
                        idleCount = 0;
                    }
                    int idletimeelapsed = curElapse - idleCount;
                    if (UtilityClass.DebugMode) {
                        System.out.println("inteval mode: idle time elapsed " + idletimeelapsed + ", idleInterval=" + idleInterval);
                    }
                    if ((long)idletimeelapsed < idleInterval) continue;
                    UtilityClass._runSignal = true;
                    continue;
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("sleep for default_interval" + default_interval);
                }
                Thread.sleep(default_interval);
                if (_mode == UtilityClass.TimeMode.MANUAL) {
                    if (!UtilityClass.DebugMode) continue;
                    System.out.println("manual mode");
                    continue;
                }
                if (_mode != UtilityClass.TimeMode.SPECIFIED_TIME) continue;
                Date date = new Date();
                long lcur = date.getTime();
                long _scheduleTime = configclass.getInstance("config.xml").getScheduledTime();
                if (UtilityClass.DebugMode) {
                    System.out.println("time mode: " + _scheduleTime);
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("     lcur: " + lcur);
                }
                if (lcur < _scheduleTime) continue;
                UtilityClass._runSignal = true;
                configclass.getInstance("config.xml").setScheduledTime(_scheduleTime += 86400000L);
                configclass.getInstance("config.xml").Save();
                if (!UtilityClass.DebugMode) continue;
                System.out.println("It is the time for updating the index");
            }
            catch (InterruptedException ignored) {
                if (UtilityClass.DebugMode) {
                    System.out.println(ignored.getMessage());
                }
                UtilityClass.OutputLogFile(ignored.getMessage());
            }
        }
    }

    static {
        default_interval = 5000L;
        bInit = true;
        baseUI = null;
    }
}

