/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.SearchBiz;
import biz.configclass;
import biz.searchFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ui.UtilityClass;

public class RealTimeFileIndexingQueue {
    private Map<String, String> IndexingTargetFile = new HashMap<String, String>();

    public void AddFileCreateQue(String filename) {
        try {
            File file = new File(filename);
            this.IndexingTargetFile.put(file.getCanonicalPath(), "1");
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void AddFileDeleteQue(String filename) {
        try {
            File file = new File(filename);
            this.IndexingTargetFile.put(file.getCanonicalPath(), "0");
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public Map<String, String> getMap() {
        return this.IndexingTargetFile;
    }

    public void removeIndexedFiles(ArrayList<String> sortedKeys) {
        for (String filename : sortedKeys) {
            this.IndexingTargetFile.remove(filename);
        }
    }

    private List<ArrayList<String>> grouping(List<String> filelist, searchFolder sf) {
        String[][] dirIncludeIndex = new String[sf.getIndexNumber()][];
        String[][] dirExcludeIndex = new String[sf.getIndexNumber()][];
        ArrayList<ArrayList<String>> subList = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < sf.getIndexNumber(); ++i) {
            String strInclude = sf.getIncludeFolder(i);
            String strExclude = sf.getExcludeFolder(i);
            if (strInclude == null || strInclude.isEmpty() || !sf.isEnable(i)) continue;
            dirIncludeIndex[i] = strInclude.split(";");
            if (strExclude != null && strExclude.isEmpty()) {
                dirExcludeIndex[i] = strExclude.split(";");
            }
            subList.add(new ArrayList());
        }
        for (String file : filelist) {
            for (int i = 0; i < sf.getIndexNumber(); ++i) {
                if (!sf.isEnable(i) || !UtilityClass.IsFileInIncludeList(file, dirIncludeIndex[i], dirExcludeIndex[i])) continue;
                ((ArrayList)subList.get(i)).add(file);
            }
        }
        return subList;
    }

    public synchronized void QueHandlerRealTime(searchFolder sf) {
        try {
            if (this.IndexingTargetFile.size() <= 0) {
                return;
            }
            ArrayList<String> sortedKeys = new ArrayList<String>(this.IndexingTargetFile.keySet());
            Collections.sort(sortedKeys);
            List<ArrayList<String>> subList = this.grouping(sortedKeys, sf);
            SearchBiz searchBiz = new SearchBiz();
            int iTotal = 0;
            int iCur = 0;
            ArrayList<String> processedFiles = new ArrayList<String>();
            for (int i = 0; i < sf.getIndexNumber(); ++i) {
                if (!sf.isEnable(i)) continue;
                ++iTotal;
                int searchOption = UtilityClass.SearchOptionRealTimeIndexUpdate;
                String strIndex = sf.getIndexName(i);
                if (!searchBiz.Init(searchOption, sf, strIndex)) {
                    return;
                }
                if (subList.get(i).size() == 0) continue;
                for (String strFile : subList.get(i)) {
                    ++iCur;
                    String strOP = this.IndexingTargetFile.get(strFile);
                    File file = new File(strFile);
                    if ("0".equals(strOP)) {
                        searchBiz.deleteIndex4File(file, iTotal, iCur, true);
                    } else {
                        int bRet = 0;
                        if ("pst".equalsIgnoreCase(UtilityClass.getFileExtension(file.getCanonicalPath()))) {
                            bRet = searchBiz.updateIndex4PST(file, iTotal, iCur);
                        } else {
                            searchBiz.deleteIndex4File(file, iTotal, iCur, false);
                            bRet = searchBiz.createIndex4File(file, null, iTotal, iCur);
                        }
                        if (bRet == -1) {
                            if (configclass.getInstance("config.xml").getResidentMode() == UtilityClass.TimeMode.SERVICE.ordinal()) {
                                UtilityClass.OutputErrLogFile("failed in create index for " + this.unhandledFilelist(processedFiles), true);
                            }
                            searchBiz._handleFatalErr(bRet, i);
                        }
                    }
                    processedFiles.add(strFile);
                }
            }
            searchBiz.finializeCreateIndex();
            this.removeIndexedFiles(sortedKeys);
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public String toString() {
        String str = "";
        for (String strKey : this.IndexingTargetFile.keySet()) {
            str = str + "\r\n" + strKey + ":" + this.IndexingTargetFile.get(strKey);
        }
        return str;
    }

    public String unhandledFilelist(ArrayList<String> handledfileList) {
        String str = "";
        for (String strKey : this.IndexingTargetFile.keySet()) {
            if (handledfileList.contains(strKey)) continue;
            str = str + strKey + "\r\n";
        }
        return str;
    }
}

