/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebDownloadDelegate;
import org.eclipse.swt.browser.WebFrameLoadDelegate;
import org.eclipse.swt.browser.WebPolicyDelegate;
import org.eclipse.swt.browser.WebResourceLoadDelegate;
import org.eclipse.swt.browser.WebUIDelegate;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.webkit.IWebCookieManager;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebDocumentRepresentation;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebIBActions;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.IWebViewPrivate;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    IWebView webView;
    int webViewWindowHandle;
    int webViewData;
    int refCount = 0;
    int lastKeyCode;
    int lastCharCode;
    WebDownloadDelegate webDownloadDelegate;
    WebFrameLoadDelegate webFrameLoadDelegate;
    WebPolicyDelegate webPolicyDelegate;
    WebResourceLoadDelegate webResourceLoadDelegate;
    WebUIDelegate webUIDelegate;
    boolean ignoreDispose;
    boolean loadingText = false;
    boolean traverseNext = true;
    boolean traverseOut = false;
    boolean untrustedText;
    String lastNavigateURL;
    BrowserFunction eventFunction;
    static int prefsIdentifier;
    static int ExternalClass;
    static boolean LibraryLoaded;
    static String LibraryLoadError;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static final int MAX_PROGRESS = 100;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String EMPTY_STRING = "";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String PROPERTY_LENGTH = "length";
    static final String PROTOCOL_HTTPS = "https://";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String USER_AGENT = "user-agent";
    static final String URI_FILEROOT = "file:///";
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static /* synthetic */ Class class$0;

    static {
        LibraryLoaded = false;
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {}
        if (!LibraryLoaded) {
            String string = WebKit.readInstallDir("SOFTWARE\\Apple Computer, Inc.\\Safari");
            if (string != null && !new File(string = String.valueOf(string) + "\\Apple Application Support").exists()) {
                string = null;
            }
            if (string == null) {
                string = WebKit.readInstallDir("SOFTWARE\\Apple Inc.\\Apple Application Support");
            }
            if (string != null) {
                TCHAR tCHAR = new TCHAR(0, string, true);
                boolean bl = OS.SetDllDirectory(tCHAR);
                if (bl) {
                    try {
                        Library.loadLibrary("swt-webkit");
                        LibraryLoaded = true;
                    }
                    catch (Throwable throwable) {
                        LibraryLoadError = "Failed to load the swt-webkit library";
                        if (Device.DEBUG) {
                            System.out.println("Failed to load swt-webkit library. Apple Application Support directory path: " + string);
                        }
                    }
                } else {
                    LibraryLoadError = "Failed to add the Apple Application Support package to the library lookup path.  ";
                    LibraryLoadError = String.valueOf(LibraryLoadError) + "To use a SWT.WEBKIT-style Browser prepend " + string + " to your Windows 'Path' environment variable and restart.";
                }
            } else {
                LibraryLoadError = "Safari must be installed to use a SWT.WEBKIT-style Browser";
            }
        }
        if (LibraryLoaded) {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectHasPropertyProc = new Callback(clazz3, "JSObjectHasPropertyProc", 3)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectGetPropertyProc = new Callback(clazz2, "JSObjectGetPropertyProc", 4)).getAddress() == 0) {
                SWT.error(3);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.browser.WebKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((JSObjectCallAsFunctionProc = new Callback(clazz, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0) {
                SWT.error(3);
            }
            NativeClearSessions = new Runnable(){

                public void run() {
                    int[] nArray = new int[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0, WebKit_win32.IID_IWebCookieManager, nArray);
                    if (n != 0 || nArray[0] == 0) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(nArray[0]);
                    int[] nArray2 = new int[1];
                    n = iWebCookieManager.cookieStorage(nArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || nArray2[0] == 0) {
                        return;
                    }
                    int n2 = WebKit_win32.CFHTTPCookieStorageCopyCookies(nArray2[0]);
                    if (n2 != 0) {
                        int n3 = WebKit_win32.CFArrayGetCount(n2);
                        int n4 = 0;
                        while (n4 < n3) {
                            int n5 = WebKit_win32.CFArrayGetValueAtIndex(n2, n4);
                            int n6 = WebKit_win32.CFHTTPCookieGetFlags(n5);
                            if ((n6 & 2) != 0) {
                                WebKit_win32.CFHTTPCookieStorageDeleteCookie(nArray2[0], n5);
                            }
                            ++n4;
                        }
                        WebKit_win32.CFRelease(n2);
                    }
                }
            };
            NativeGetCookie = new Runnable(){

                public void run() {
                    int[] nArray = new int[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0, WebKit_win32.IID_IWebCookieManager, nArray);
                    if (n != 0 || nArray[0] == 0) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(nArray[0]);
                    int[] nArray2 = new int[1];
                    n = iWebCookieManager.cookieStorage(nArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || nArray2[0] == 0) {
                        return;
                    }
                    char[] cArray = CookieUrl.toCharArray();
                    int n2 = WebKit_win32.CFStringCreateWithCharacters(0, cArray, cArray.length);
                    if (n2 != 0) {
                        int n3 = WebKit_win32.CFURLCreateWithString(0, n2, 0);
                        if (n3 != 0) {
                            boolean bl = CookieUrl.startsWith(WebKit.PROTOCOL_HTTPS);
                            int n4 = WebKit_win32.CFHTTPCookieStorageCopyCookiesForURL(nArray2[0], n3, bl);
                            if (n4 != 0) {
                                int n5 = WebKit_win32.CFArrayGetCount(n4);
                                int n6 = 0;
                                while (n6 < n5) {
                                    String string;
                                    int n7;
                                    int n8 = WebKit_win32.CFArrayGetValueAtIndex(n4, n6);
                                    if (n8 != 0 && (n7 = WebKit_win32.CFHTTPCookieGetName(n8)) != 0 && CookieName.equals(string = WebKit.stringFromCFString(n7))) {
                                        int n9 = WebKit_win32.CFHTTPCookieGetValue(n8);
                                        if (n9 == 0) break;
                                        CookieValue = WebKit.stringFromCFString(n9);
                                        break;
                                    }
                                    ++n6;
                                }
                                WebKit_win32.CFRelease(n4);
                            }
                            WebKit_win32.CFRelease(n3);
                        }
                        WebKit_win32.CFRelease(n2);
                    }
                }
            };
            NativeSetCookie = new Runnable(){

                public void run() {
                    int[] nArray = new int[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0, WebKit_win32.IID_IWebCookieManager, nArray);
                    if (n != 0 || nArray[0] == 0) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(nArray[0]);
                    int[] nArray2 = new int[1];
                    n = iWebCookieManager.cookieStorage(nArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || nArray2[0] == 0) {
                        return;
                    }
                    char[] cArray = CookieUrl.toCharArray();
                    int n2 = WebKit_win32.CFStringCreateWithCharacters(0, cArray, cArray.length);
                    if (n2 != 0) {
                        int n3 = WebKit_win32.CFURLCreateWithString(0, n2, 0);
                        if (n3 != 0) {
                            cArray = CookieValue.toCharArray();
                            int n4 = WebKit_win32.CFStringCreateWithCharacters(0, cArray, cArray.length);
                            if (n4 != 0) {
                                cArray = WebKit.HEADER_SETCOOKIE.toCharArray();
                                int n5 = WebKit_win32.CFStringCreateWithCharacters(0, cArray, cArray.length);
                                if (n5 != 0) {
                                    int n6 = WebKit_win32.CFDictionaryCreate(0, new int[]{n5}, new int[]{n4}, 1, WebKit_win32.kCFCopyStringDictionaryKeyCallBacks(), WebKit_win32.kCFTypeDictionaryValueCallBacks());
                                    if (n6 != 0) {
                                        int n7 = WebKit_win32.CFHTTPCookieCreateWithResponseHeaderFields(0, n6, n3);
                                        if (n7 != 0) {
                                            int n8 = WebKit_win32.CFArrayGetValueAtIndex(n7, 0);
                                            if (n8 != 0) {
                                                WebKit_win32.CFHTTPCookieStorageSetCookie(nArray2[0], n8);
                                                CookieResult = true;
                                            }
                                            WebKit_win32.CFRelease(n7);
                                        }
                                        WebKit_win32.CFRelease(n6);
                                    }
                                    WebKit_win32.CFRelease(n5);
                                }
                                WebKit_win32.CFRelease(n4);
                            }
                            WebKit_win32.CFRelease(n3);
                        }
                        WebKit_win32.CFRelease(n2);
                    }
                }
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
            }
            NativePendingCookies = null;
        }
    }

    WebKit() {
    }

    static int createBSTR(String string) {
        char[] cArray = (String.valueOf(string) + '\u0000').toCharArray();
        return COM.SysAllocString(cArray);
    }

    static String error(int n) {
        throw new SWTError("WebKit error " + n);
    }

    static String extractBSTR(int n) {
        int n2 = COM.SysStringByteLen(n);
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        char[] cArray = new char[(n2 + 1) / 2];
        COM.MoveMemory(cArray, n, n2);
        return new String(cArray);
    }

    static Browser findBrowser(int n) {
        Widget widget;
        if (n == 0) {
            return null;
        }
        IWebView iWebView = new IWebView(n);
        int[] nArray = new int[1];
        int n2 = iWebView.hostWindow(nArray);
        if (n2 == 0 && nArray[0] != 0 && (widget = Display.getCurrent().findWidget(nArray[0])) != null && widget instanceof Browser) {
            return (Browser)widget;
        }
        return null;
    }

    static int JSObjectCallAsFunctionProc(int n, int n2, int n3, int n4, int n5, int n6) {
        WebKit_win32.JSGlobalContextRetain(n);
        if (WebKit_win32.JSValueIsObjectOfClass(n, n3, ExternalClass) == 0) {
            return WebKit_win32.JSValueMakeUndefined(n);
        }
        int n7 = WebKit_win32.JSObjectGetPrivate(n3);
        int[] nArray = new int[1];
        C.memmove(nArray, n7, C.PTR_SIZEOF);
        Browser browser = WebKit.findBrowser(nArray[0]);
        if (browser == null) {
            return WebKit_win32.JSValueMakeUndefined(n);
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(n, n2, n3, n4, n5, n6);
    }

    static int JSObjectGetPropertyProc(int n, int n2, int n3, int n4) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "callJava\u0000".getBytes();
        }
        int n5 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        int n6 = WebKit_win32.JSObjectCallAsFunctionProc_CALLBACK(JSObjectCallAsFunctionProc.getAddress());
        int n7 = WebKit_win32.JSObjectMakeFunctionWithCallback(n, n5, n6);
        WebKit_win32.JSStringRelease(n5);
        return n7;
    }

    static int JSObjectHasPropertyProc(int n, int n2, int n3) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "callJava\u0000".getBytes();
        }
        return WebKit_win32.JSStringIsEqualToUTF8CString(n3, byArray);
    }

    static String readInstallDir(String string) {
        TCHAR tCHAR = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        if (OS.RegOpenKeyEx(-2147483646, tCHAR, 0, 131097, nArray) == 0) {
            TCHAR tCHAR2;
            TCHAR tCHAR3 = new TCHAR(0, "InstallDir", true);
            int[] nArray2 = new int[1];
            int n = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, null, nArray2);
            if (n == 0 && (n = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, tCHAR2 = new TCHAR(0, nArray2[0] / TCHAR.sizeof), nArray2)) == 0) {
                OS.RegCloseKey(nArray[0]);
                return tCHAR2.toString(0, tCHAR2.strlen());
            }
            OS.RegCloseKey(nArray[0]);
        }
        return null;
    }

    static String stringFromCFString(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = WebKit_win32.CFStringGetLength(n);
        int n3 = WebKit_win32.CFStringGetCharactersPtr(n);
        char[] cArray = new char[n2];
        if (n3 != 0) {
            OS.MoveMemory(cArray, n3, n2);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                cArray[n4] = WebKit_win32.CFStringGetCharacterAtIndex(n, n4);
                ++n4;
            }
        }
        return new String(cArray);
    }

    static String stringFromJSString(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = WebKit_win32.JSStringGetLength(n);
        byte[] byArray = new byte[n2 + 1];
        WebKit_win32.JSStringGetUTF8CString(n, byArray, n2 + 1);
        return new String(byArray);
    }

    public boolean back() {
        int[] nArray = new int[1];
        this.webView.goBack(nArray);
        return nArray[0] != 0;
    }

    int callJava(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = null;
        if (n4 == 3) {
            int[] nArray = new int[1];
            C.memmove(nArray, n5, C.PTR_SIZEOF);
            int n7 = WebKit_win32.JSValueGetType(n, nArray[0]);
            if (n7 == 3) {
                int n8 = ((Double)this.convertToJava(n, nArray[0])).intValue();
                nArray[0] = 0;
                if (n8 > 0) {
                    Integer n9 = new Integer(n8);
                    C.memmove(nArray, n5 + C.PTR_SIZEOF, C.PTR_SIZEOF);
                    n7 = WebKit_win32.JSValueGetType(n, nArray[0]);
                    if (n7 == 4) {
                        String string = (String)this.convertToJava(n, nArray[0]);
                        BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n9);
                        if (browserFunction != null && string.equals(browserFunction.token)) {
                            try {
                                C.memmove(nArray, n5 + 2 * C.PTR_SIZEOF, C.PTR_SIZEOF);
                                Object object2 = this.convertToJava(n, nArray[0]);
                                if (object2 instanceof Object[]) {
                                    Object[] objectArray = (Object[])object2;
                                    try {
                                        object = browserFunction.function(objectArray);
                                    }
                                    catch (Exception exception) {
                                        object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                    }
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (browserFunction.isEvaluate) {
                                    browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                                }
                                object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                            }
                        }
                    }
                }
            }
        }
        return this.convertToJS(n, object);
    }

    public boolean close() {
        return this.shouldClose();
    }

    Object convertToJava(int n, int n2) {
        int n3 = WebKit_win32.JSValueGetType(n, n2);
        switch (n3) {
            case 2: {
                int n4 = (int)WebKit_win32.JSValueToNumber(n, n2, null);
                return new Boolean(n4 != 0);
            }
            case 3: {
                double d = WebKit_win32.JSValueToNumber(n, n2, null);
                return new Double(d);
            }
            case 4: {
                int n5 = WebKit_win32.JSValueToStringCopy(n, n2, null);
                if (n5 == 0) {
                    return EMPTY_STRING;
                }
                int n6 = WebKit_win32.JSStringGetMaximumUTF8CStringSize(n5);
                byte[] byArray = new byte[n6];
                n6 = WebKit_win32.JSStringGetUTF8CString(n5, byArray, n6);
                WebKit_win32.JSStringRelease(n5);
                try {
                    return new String(byArray, 0, n6 - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(byArray);
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = null;
                try {
                    byArray = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = "length\u0000".getBytes();
                }
                int n7 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
                int n8 = WebKit_win32.JSObjectGetProperty(n, n2, n7, null);
                WebKit_win32.JSStringRelease(n7);
                n3 = WebKit_win32.JSValueGetType(n, n8);
                if (n3 != 3) break;
                int n9 = (int)WebKit_win32.JSValueToNumber(n, n8, null);
                Object[] objectArray = new Object[n9];
                int n10 = 0;
                while (n10 < n9) {
                    int n11 = WebKit_win32.JSObjectGetPropertyAtIndex(n, n2, n10, null);
                    if (n11 != 0) {
                        objectArray[n10] = this.convertToJava(n, n11);
                    }
                    ++n10;
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }

    int convertToJS(int n, Object object) {
        if (object == null) {
            return WebKit_win32.JSValueMakeNull(n);
        }
        if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes();
            }
            int n2 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
            int n3 = WebKit_win32.JSValueMakeString(n, n2);
            WebKit_win32.JSStringRelease(n2);
            return n3;
        }
        if (object instanceof Boolean) {
            return WebKit_win32.JSValueMakeBoolean(n, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKit_win32.JSValueMakeNumber(n, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length;
            int[] nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                Object object2 = objectArray[n5];
                nArray[n5] = n6 = this.convertToJS(n, object2);
                ++n5;
            }
            return WebKit_win32.JSObjectMakeArray(n, n4, nArray, null);
        }
        SWT.error(51);
        return 0;
    }

    public void create(Composite composite, int n) {
        int n2;
        Object object;
        if (!LibraryLoaded) {
            this.browser.dispose();
            SWT.error(2, null, LibraryLoadError == null ? null : " [" + LibraryLoadError + ']');
        }
        if (ExternalClass == 0) {
            int n3;
            object = new JSClassDefinition();
            byte[] byArray = "External\u0000".getBytes();
            object.className = C.malloc(byArray.length);
            OS.memmove(object.className, byArray, byArray.length);
            object.hasProperty = n3 = WebKit_win32.JSObjectHasPropertyProc_CALLBACK(JSObjectHasPropertyProc.getAddress());
            object.getProperty = n3 = WebKit_win32.JSObjectGetPropertyProc_CALLBACK(JSObjectGetPropertyProc.getAddress());
            int n4 = C.malloc(JSClassDefinition.sizeof);
            WebKit_win32.memmove(n4, (JSClassDefinition)object, JSClassDefinition.sizeof);
            ExternalClass = WebKit_win32.JSClassCreate(n4);
            WebKit_win32.JSClassRetain(ExternalClass);
        }
        if ((n2 = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebView, 0, WebKit_win32.IID_IWebView, object = new int[1])) != 0 || object[0] == 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webView = new IWebView(object[0]);
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new int[]{this.webView.getAddress()}, C.PTR_SIZEOF);
        n2 = this.webView.setHostWindow(this.browser.handle);
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        if ((n2 = this.webView.initWithFrame(new RECT(), 0, 0)) != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        object[0] = 0;
        n2 = this.webView.QueryInterface(WebKit_win32.IID_IWebViewPrivate, (int[])object);
        if (n2 != 0 || object[0] == 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        IWebViewPrivate iWebViewPrivate = new IWebViewPrivate(object[0]);
        object[0] = 0;
        n2 = iWebViewPrivate.viewWindow((int[])object);
        if (n2 != 0 || object[0] == 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        iWebViewPrivate.Release();
        this.webViewWindowHandle = object[0];
        this.webFrameLoadDelegate = new WebFrameLoadDelegate(this.browser);
        n2 = this.webView.setFrameLoadDelegate(this.webFrameLoadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webUIDelegate = new WebUIDelegate(this.browser);
        n2 = this.webView.setUIDelegate(this.webUIDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webResourceLoadDelegate = new WebResourceLoadDelegate(this.browser);
        n2 = this.webView.setResourceLoadDelegate(this.webResourceLoadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webDownloadDelegate = new WebDownloadDelegate(this.browser);
        n2 = this.webView.setDownloadDelegate(this.webDownloadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webPolicyDelegate = new WebPolicyDelegate(this.browser);
        n2 = this.webView.setPolicyDelegate(this.webPolicyDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.initializeWebViewPreferences();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose();
                        break;
                    }
                    case 15: {
                        OS.SetFocus(WebKit.this.webViewWindowHandle);
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = WebKit.this.browser.getClientArea();
                        OS.SetWindowPos(WebKit.this.webViewWindowHandle, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 32);
                        break;
                    }
                    case 31: {
                        if (WebKit.this.traverseOut) {
                            event.doit = true;
                            WebKit.this.traverseOut = false;
                            break;
                        }
                        event.doit = false;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(11, listener);
        this.browser.addListener(31, listener);
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            public Object function(Object[] objectArray) {
                return WebKit.this.handleEvent(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public boolean execute(String string) {
        int[] nArray = new int[1];
        int n = this.webView.mainFrame(nArray);
        if (n != 0 || nArray[0] == 0) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(nArray[0]);
        int n2 = iWebFrame.globalContext();
        iWebFrame.Release();
        if (n2 == 0) {
            return false;
        }
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(string) + '\u0000').getBytes();
        }
        int n3 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        if (n3 == 0) {
            return false;
        }
        try {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes();
        }
        int n4 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        if (n4 == 0) {
            WebKit_win32.JSStringRelease(n3);
            return false;
        }
        int n5 = WebKit_win32.JSEvaluateScript(n2, n3, 0, n4, 0, null);
        WebKit_win32.JSStringRelease(n4);
        WebKit_win32.JSStringRelease(n3);
        return n5 != 0;
    }

    public boolean forward() {
        int[] nArray = new int[1];
        this.webView.goForward(nArray);
        return nArray[0] != 0;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int[] nArray = new int[1];
        int n = this.webView.mainFrame(nArray);
        if (n != 0 || nArray[0] == 0) {
            return EMPTY_STRING;
        }
        IWebFrame iWebFrame = new IWebFrame(nArray[0]);
        nArray[0] = 0;
        n = iWebFrame.dataSource(nArray);
        iWebFrame.Release();
        if (n != 0 || nArray[0] == 0) {
            return EMPTY_STRING;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(nArray[0]);
        nArray[0] = 0;
        n = iWebDataSource.representation(nArray);
        iWebDataSource.Release();
        if (n != 0 || nArray[0] == 0) {
            return EMPTY_STRING;
        }
        IWebDocumentRepresentation iWebDocumentRepresentation = new IWebDocumentRepresentation(nArray[0]);
        nArray[0] = 0;
        n = iWebDocumentRepresentation.documentSource(nArray);
        iWebDocumentRepresentation.Release();
        if (n != 0 || nArray[0] == 0) {
            return EMPTY_STRING;
        }
        String string = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        return string;
    }

    public String getUrl() {
        return this.webFrameLoadDelegate.getUrl();
    }

    boolean handleEvent(Object[] objectArray) {
        int n;
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN)) {
            int n2;
            this.lastKeyCode = n2 = this.translateKey(((Double)objectArray[1]).intValue());
            switch (n2) {
                case 9: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n2;
                    switch (n2) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
                    event.stateMask &= ~n2;
                    if (this.sendKeyEvent(event) && !this.browser.isDisposed()) break;
                    return false;
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = ((Double)objectArray[2]).intValue();
            if (((Boolean)objectArray[4]).booleanValue() && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if (string.equals(DOMEVENT_KEYUP)) {
            int n3 = this.translateKey(((Double)objectArray[1]).intValue());
            if (n3 == 0) {
                return true;
            }
            if (n3 != this.lastKeyCode) {
                this.lastKeyCode = n3;
                this.lastCharCode = 0;
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 2;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    event.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(event.type, event);
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return event.doit && !this.browser.isDisposed();
        }
        if ((string.equals(DOMEVENT_MOUSEOVER) || string.equals(DOMEVENT_MOUSEOUT)) && ((Boolean)objectArray[9]).booleanValue()) {
            return true;
        }
        Point point = new Point(((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue());
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n = ((Boolean)objectArray[5] != false ? 65536 : 0) | ((Boolean)objectArray[6] != false ? 262144 : 0) | ((Boolean)objectArray[7] != false ? 131072 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (((Double)objectArray[3]).intValue() == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n;
                event.count = ((Double)objectArray[3]).intValue();
                event.button = ((Double)objectArray[4]).intValue();
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = ((Double)objectArray[3]).intValue();
        } else if (string.equals(DOMEVENT_MOUSEOVER)) {
            event.type = 6;
        } else if (string.equals(DOMEVENT_MOUSEOUT)) {
            event.type = 7;
            if (event.x < 0) {
                event.x = -1;
            }
            if (event.y < 0) {
                event.y = -1;
            }
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = ((Double)objectArray[4]).intValue() + 1;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    public boolean isBackEnabled() {
        int[] nArray = new int[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, nArray);
        if (n != 0 || nArray[0] == 0) {
            return false;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(nArray[0]);
        int[] nArray2 = new int[1];
        iWebIBActions.canGoBack(this.webView.getAddress(), nArray2);
        iWebIBActions.Release();
        return nArray2[0] != 0;
    }

    public boolean isFocusControl() {
        int n = OS.GetFocus();
        return n != 0 && n == this.webViewWindowHandle;
    }

    public boolean isForwardEnabled() {
        int[] nArray = new int[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, nArray);
        if (n != 0 || nArray[0] == 0) {
            return false;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(nArray[0]);
        int[] nArray2 = new int[1];
        iWebIBActions.canGoForward(this.webView.getAddress(), nArray2);
        iWebIBActions.Release();
        return nArray2[0] != 0;
    }

    void onDispose() {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.webUIDelegate.prompt = false;
            this.shouldClose();
            this.webUIDelegate.prompt = true;
        }
        Enumeration enumeration = this.functions.elements();
        while (enumeration.hasMoreElements()) {
            ((BrowserFunction)enumeration.nextElement()).dispose(false);
        }
        this.functions = null;
        this.eventFunction.dispose();
        this.eventFunction = null;
        C.free(this.webViewData);
        this.webView.setPreferences(0);
        this.webView.setHostWindow(0);
        this.webView.setFrameLoadDelegate(0);
        this.webView.setResourceLoadDelegate(0);
        this.webView.setUIDelegate(0);
        this.webView.setPolicyDelegate(0);
        this.webView.setDownloadDelegate(0);
        this.webView.Release();
        this.webView = null;
        this.webDownloadDelegate = null;
        this.webFrameLoadDelegate = null;
        this.webPolicyDelegate = null;
        this.webResourceLoadDelegate = null;
        this.webUIDelegate = null;
        this.lastNavigateURL = null;
    }

    public void refresh() {
        this.webFrameLoadDelegate.html = null;
        int[] nArray = new int[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, nArray);
        if (n != 0 || nArray[0] == 0) {
            return;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(nArray[0]);
        iWebIBActions.reload(this.webView.getAddress());
        iWebIBActions.Release();
    }

    boolean sendKeyEvent(Event event) {
        boolean bl = true;
        switch (event.keyCode) {
            case 9: 
            case 13: 
            case 27: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: {
                break;
            }
            default: {
                if (!this.translateMnemonics() || event.character == '\u0000' || (event.stateMask & 0x50000) != 65536) break;
                int n = 128;
                boolean bl2 = event.doit;
                event.doit = true;
                bl = !this.browser.traverse(n, event);
                event.doit = bl2;
            }
        }
        if (bl) {
            this.browser.notifyListeners(event.type, event);
            bl = event.doit;
        }
        return bl;
    }

    public boolean setText(String string, boolean bl) {
        boolean bl2 = this.webFrameLoadDelegate.html != null;
        this.webFrameLoadDelegate.html = string;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        int[] nArray = new int[1];
        int n = this.webView.mainFrame(nArray);
        if (n != 0 || nArray[0] == 0) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(nArray[0]);
        nArray[0] = 0;
        n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0, WebKit_win32.IID_IWebMutableURLRequest, nArray);
        if (n != 0 || nArray[0] == 0) {
            iWebFrame.Release();
            return false;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(nArray[0]);
        int n2 = WebKit.createBSTR(ABOUT_BLANK);
        n = iWebMutableURLRequest.setURL(n2);
        COM.SysFreeString(n2);
        if (n == 0) {
            n = iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
        }
        iWebFrame.Release();
        iWebMutableURLRequest.Release();
        return n == 0;
    }

    public boolean setUrl(String object, String string, String[] stringArray) {
        int n;
        Object object2;
        if (((String)object).length() == 0) {
            return false;
        }
        try {
            new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            object2 = null;
            object2 = new File((String)object).isAbsolute() ? (Object)(PROTOCOL_FILE + (String)object) : (Object)(PROTOCOL_HTTP + (String)object);
            try {
                new URL((String)object2);
                object = object2;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        this.webFrameLoadDelegate.html = null;
        this.lastNavigateURL = object;
        object2 = new int[1];
        int n2 = this.webView.mainFrame((int[])object2);
        if (n2 != 0 || object2[0] == 0) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(object2[0]);
        object2[0] = 0;
        n2 = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0, WebKit_win32.IID_IWebMutableURLRequest, (int[])object2);
        if (n2 != 0 || object2[0] == 0) {
            iWebFrame.Release();
            return false;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(object2[0]);
        n2 = 0;
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                int n3;
                String string2 = stringArray[n];
                if (string2 != null && (n3 = string2.indexOf(58)) != -1) {
                    String string3 = string2.substring(0, n3).trim();
                    String string4 = string2.substring(n3 + 1).trim();
                    if (string3.length() > 0 && string4.length() > 0) {
                        int n4 = WebKit.createBSTR(string4);
                        if (string3.equalsIgnoreCase(USER_AGENT)) {
                            n2 = this.webView.setCustomUserAgent(n4);
                        } else {
                            int n5 = WebKit.createBSTR(string3);
                            n2 = iWebMutableURLRequest.setValue(n4, n5);
                            COM.SysFreeString(n5);
                        }
                        COM.SysFreeString(n4);
                    }
                }
                ++n;
            }
        }
        if (n2 == 0) {
            n = WebKit.createBSTR((String)object);
            n2 = iWebMutableURLRequest.setURL(n);
            COM.SysFreeString(n);
            if (n2 == 0) {
                n2 = iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
            }
            this.webView.setCustomUserAgent(0);
        }
        iWebFrame.Release();
        iWebMutableURLRequest.Release();
        return n2 == 0;
    }

    boolean shouldClose() {
        if (!this.jsEnabled) {
            return true;
        }
        int[] nArray = new int[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebViewPrivate, nArray);
        if (n != 0 || nArray[0] == 0) {
            return false;
        }
        IWebViewPrivate iWebViewPrivate = new IWebViewPrivate(nArray[0]);
        int[] nArray2 = new int[1];
        iWebViewPrivate.shouldClose(nArray2);
        iWebViewPrivate.Release();
        return nArray2[0] != 0;
    }

    public void stop() {
        this.webFrameLoadDelegate.html = null;
        int[] nArray = new int[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, nArray);
        if (n != 0 || nArray[0] == 0) {
            return;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(nArray[0]);
        iWebIBActions.stopLoading(this.webView.getAddress());
        iWebIBActions.Release();
    }

    void initializeWebViewPreferences() {
        IWebPreferences iWebPreferences;
        int[] nArray = new int[1];
        int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebPreferences, 0, WebKit_win32.IID_IWebPreferences, nArray);
        if (n == 0 && nArray[0] != 0) {
            iWebPreferences = new IWebPreferences(nArray[0]);
            nArray[0] = 0;
            n = iWebPreferences.initWithIdentifier(WebKit.createBSTR(String.valueOf(prefsIdentifier++)), nArray);
            iWebPreferences.Release();
            if (n == 0 && nArray[0] != 0) {
                iWebPreferences = new IWebPreferences(nArray[0]);
                this.webView.setPreferences(iWebPreferences.getAddress());
                iWebPreferences.Release();
            }
        }
        nArray[0] = 0;
        n = this.webView.preferences(nArray);
        if (n == 0 && nArray[0] != 0) {
            iWebPreferences = new IWebPreferences(nArray[0]);
            iWebPreferences.setJavaScriptEnabled(1);
            iWebPreferences.setJavaScriptCanOpenWindowsAutomatically(1);
            iWebPreferences.setJavaEnabled(0);
            iWebPreferences.setTabsToLinks(1);
            iWebPreferences.setFontSmoothing(4);
            iWebPreferences.Release();
        }
    }
}

