/*
 * Decompiled with CFR 0.152.
 */
package DeleteTool;

import Interface.Mytranslator;
import biz.Certificate;
import biz.configclass;
import biz.loggerWrapper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import ui.BuildOption;
import ui.LangSelectDlg;
import ui.UtilityClass;

public class DeleteTool {
    private static Shell shlUninstallmain;
    private static int nInitWidth;
    private static int nInitHeight;
    private static Button btnOK;
    private static Label lblCaption;
    private static Label lblNewLabel;
    private static String BatchfileName;
    private static String[] FileList;
    private static String[] DirList;
    private static Button btnCancel;
    private static Label label;
    private static boolean bCancel;

    public static void main(String[] args) {
        Display display = new Display();
        shlUninstallmain = new Shell(display, 16416);
        RowLayout rl_shlUninstallmain = new RowLayout(256);
        shlUninstallmain.setLayout(rl_shlUninstallmain);
        DeleteTool.InitConfig();
        DeleteTool.InitLanguage();
        DeleteTool.CreateContents();
        DeleteTool.Centerize();
        shlUninstallmain.open();
        shlUninstallmain.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                DeleteTool.OnExit();
            }
        });
        while (!shlUninstallmain.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void Centerize() {
        Monitor primary = Display.getDefault().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shlUninstallmain.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shlUninstallmain.setLocation(x, y);
    }

    private static void InitConfig() {
        UtilityClass.DebugMode = configclass.getInstance("config.xml").getDebugMode();
    }

    private static void CreateContents() {
        shlUninstallmain.setSize(UtilityClass.scaleForDpi(540), UtilityClass.scaleForDpi(146));
        Rectangle pDisplayBnd = shlUninstallmain.getDisplay().getBounds();
        Point centLoc = new Point((pDisplayBnd.width - nInitWidth) / 2, (pDisplayBnd.height - nInitHeight) / 2);
        shlUninstallmain.setLocation(centLoc);
        shlUninstallmain.setText(Mytranslator.getInstance().getTranslate("UninstallTitle"));
        lblNewLabel = new Label(shlUninstallmain, 0);
        lblNewLabel.setLayoutData(new RowData(UtilityClass.scaleForDpi(2), UtilityClass.scaleForDpi(10)));
        lblNewLabel.setText("  ");
        lblCaption = new Label(shlUninstallmain, 64);
        lblCaption.setLayoutData(new RowData(UtilityClass.scaleForDpi(519), UtilityClass.scaleForDpi(57)));
        lblCaption.setText(Mytranslator.getInstance().getTranslate("InitUninstallText"));
        Label lblNewLabel_1 = new Label(shlUninstallmain, 0);
        lblNewLabel_1.setLayoutData(new RowData(UtilityClass.scaleForDpi(525), UtilityClass.scaleForDpi(11)));
        label = new Label(shlUninstallmain, 0);
        label.setLayoutData(new RowData(UtilityClass.scaleForDpi(239), -1));
        btnOK = new Button(shlUninstallmain, 0);
        btnOK.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String strText = btnOK.getText();
                if (strText.equals(Mytranslator.getInstance().getTranslate("StartDelete"))) {
                    btnOK.setEnabled(false);
                    DeleteTool.UninstallProcess();
                } else {
                    DeleteTool.OnExit();
                    shlUninstallmain.dispose();
                }
            }
        });
        btnOK.setText(Mytranslator.getInstance().getTranslate("StartDelete"));
        btnOK.setLayoutData(new RowData(UtilityClass.scaleForDpi(134), -1));
        btnCancel = new Button(shlUninstallmain, 0);
        btnCancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                bCancel = true;
                shlUninstallmain.close();
            }
        });
        btnCancel.setText(Mytranslator.getInstance().getTranslate("Cancel"));
        btnCancel.setLayoutData(new RowData(UtilityClass.scaleForDpi(145), -1));
    }

    private static void OnExit() {
        try {
            File file;
            loggerWrapper.DeleteInstance();
            if (!bCancel && !BatchfileName.isEmpty() && (file = new File(BatchfileName)).exists()) {
                DeleteTool.DeleteSearchPlusPlusFiles(BatchfileName);
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    private static void DeleteSearchPlusPlusFiles(String strBatchFile) {
        final String strFile = strBatchFile;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(strFile);
                }
                catch (Exception e) {
                    UtilityClass.OutputLogFile(e.getMessage());
                }
            }
        });
    }

    private static void UninstallProcess() {
        try {
            Process p;
            String strCmd;
            String strTerminal = "terminate";
            boolean bfound = true;
            if (UtilityClass.CheckWindowsService(UtilityClass._ServiceName) > 0) {
                strCmd = UtilityClass._unregisterService;
                p = Runtime.getRuntime().exec("cmd /c start " + strCmd);
                p.waitFor();
            }
            if (UtilityClass.IsRunning()) {
                bfound = false;
                strCmd = UtilityClass._TerminateProcess;
                p = Runtime.getRuntime().exec(strCmd);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException strCmd2) {
                // empty catch block
            }
            String strOrigincode = configclass.getInstance("config.xml").getl();
            Certificate.init(configclass.getInstance("config.xml").getVer());
            Certificate.RemoveRegisterCert(strOrigincode);
            if (!"0".equals(configclass.getInstance("config.xml").getIndexAgent()) && !"1".equals(configclass.getInstance("config.xml").getIndexAgent())) {
                String indexDir = configclass.getInstance("config.xml").getIndexDir();
                lblCaption.setText(Mytranslator.getInstance().getTranslate("Deleting") + Mytranslator.getInstance().getTranslate("Indexdata"));
                UtilityClass.deleteIndexFolder(indexDir);
            }
            lblCaption.setText(Mytranslator.getInstance().getTranslate("Deleting") + " link");
            String SF_STARTUP = "Startup";
            String strStartupPath = UtilityClass.getUserStartupPath(SF_STARTUP);
            DeleteTool.deleteFile(strStartupPath);
            String strShortLinkWin8Path = UtilityClass.getWin8ShortcutPath();
            if (!strShortLinkWin8Path.isEmpty()) {
                DeleteTool.deleteFile(strShortLinkWin8Path);
            }
            File batchfile = File.createTempFile("delfile", ".bat");
            BatchfileName = batchfile.getCanonicalPath();
            String curFold = new File("..").getCanonicalPath();
            String strDeleteFile = "";
            strDeleteFile = strDeleteFile + "cd \"" + curFold + "\"" + System.getProperty("line.separator");
            for (int i = 0; i < FileList.length; ++i) {
                String strFilename = UtilityClass.getFullname(curFold, FileList[i]);
                strDeleteFile = strDeleteFile + "if exist \"" + strFilename + "\" del /Q \"" + strFilename + "\"" + System.getProperty("line.separator");
            }
            String strDeleteFolder = "";
            for (int i = 0; i < DirList.length; ++i) {
                String strFolder = UtilityClass.getFullname(curFold, DirList[i]);
                strDeleteFolder = strDeleteFolder + "if exist \"" + strFolder + "\" rd /Q /S \"" + strFolder + "\"" + System.getProperty("line.separator");
            }
            String batchStr = "@echo off" + System.getProperty("line.separator") + strDeleteFile + strDeleteFolder;
            FileUtils.write((File)batchfile, (CharSequence)batchStr, (String)"SJIS");
            lblCaption.setText(Mytranslator.getInstance().getTranslate("DeletingOnExit"));
            btnOK.setText(Mytranslator.getInstance().getTranslate("DelButton"));
            btnOK.setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void InitLanguage() {
        if ("none".equals(configclass.getInstance("config.xml").getIndexDir())) {
            String strInitLang = configclass.getInstance("config.xml").getLang();
            LangSelectDlg langDlg = new LangSelectDlg(shlUninstallmain, strInitLang);
            String strLang = langDlg.open();
            if (strLang.equalsIgnoreCase("Japanese")) {
                configclass.getInstance("config.xml").setLang(1);
            } else if (strLang.equalsIgnoreCase("English")) {
                configclass.getInstance("config.xml").setLang(2);
            } else if (strLang.equalsIgnoreCase("Chinese Simplified")) {
                configclass.getInstance("config.xml").setLang(0);
            } else if (strLang.equalsIgnoreCase("Chinese Traditional")) {
                configclass.getInstance("config.xml").setLang(3);
            } else {
                configclass.getInstance("config.xml").setLang(2);
            }
            if ("Taiwan".equals(BuildOption.CountryVersion) && strLang.equalsIgnoreCase("Japanese")) {
                configclass.getInstance("config.xml").setLang(3);
            }
        }
    }

    private static void deleteFile(String strStartupPath) {
        String destFileLink = UtilityClass.getFullname(strStartupPath, Mytranslator.getInstance().getTranslate("StartUpLink"));
        File destFile = new File(destFileLink);
        if (destFile.exists()) {
            FileUtils.deleteQuietly((File)destFile);
        }
    }

    static {
        nInitWidth = 1024;
        nInitHeight = 768;
        BatchfileName = "";
        FileList = new String[]{"searchplusplus.exe", "readme.txt", "ReadmeDataTool.txt", "deletetool.exe", "datatool.exe", "MemAdm.exe", "manual.pdf", "IFilterStatus.exe", "*.lnk", "searchplusplus.log.*", "\u793e\u5185\u30b7\u30b9\u30c6\u30e0\u69cb\u7bc9\u56f3.pdf"};
        DirList = new String[]{"tool"};
        bCancel = false;
    }
}

