/*
 * Decompiled with CFR 0.152.
 */
package ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ui.UtilityClass;

public class ColorManager {
    private static Color bkColor = null;
    private static Color textColor = null;
    private static Color highlightColor = null;
    private static int MAX_TEXTHIGHLIHGHTCOLOR = 8;
    private static Color[] texthighlightColor = new Color[MAX_TEXTHIGHLIHGHTCOLOR];

    public static int GetTextHighlightColorNumber() {
        return MAX_TEXTHIGHLIHGHTCOLOR;
    }

    public static String GetColorString(Color color) {
        String colorStr = color.getRed() + ";" + color.getGreen() + ";" + color.getBlue();
        return colorStr;
    }

    public static RGB String2RGB(String rgbString) {
        String[] rgbArray = rgbString.split(";");
        return new RGB(Integer.valueOf(rgbArray[0]), Integer.valueOf(rgbArray[1]), Integer.valueOf(rgbArray[2]));
    }

    public static String RGB2String(RGB rgb) {
        return rgb.red + ";" + rgb.green + ";" + rgb.blue;
    }

    public static void setColorTheme(int iColorTheme) {
        RGB rgbTextColor = ColorManager.String2RGB(UtilityClass.TextColor[iColorTheme]);
        Color textColor = new Color(null, rgbTextColor);
        ColorManager.SettextColor(textColor);
        RGB rgbBKTextColor = ColorManager.String2RGB(UtilityClass.BkColor[iColorTheme]);
        Color textBKColor = new Color(null, rgbBKTextColor);
        ColorManager.SetbkColor(textBKColor);
        RGB rgbHighlightColor = ColorManager.String2RGB(UtilityClass.highlightTableItemClr[iColorTheme]);
        Color texHighlighttColor = new Color(null, rgbHighlightColor);
        ColorManager.SethighlightColor(texHighlighttColor);
        int length = UtilityClass.highlightTextClr[iColorTheme].length;
        RGB[] rgb = new RGB[length];
        for (int i = 0; i < length; ++i) {
            RGB rgbTemp;
            rgb[i] = rgbTemp = UtilityClass.highlightTextClr[iColorTheme][i];
        }
        ColorManager.setTextHighlightColor(rgb);
    }

    public static void Dispose() {
        if (bkColor != null) {
            bkColor.dispose();
            bkColor = null;
        }
        if (textColor != null) {
            textColor.dispose();
            textColor = null;
        }
        if (highlightColor != null) {
            highlightColor.dispose();
            highlightColor = null;
        }
        for (int i = 0; i < texthighlightColor.length; ++i) {
            if (texthighlightColor[i] == null || texthighlightColor[i].isDisposed()) continue;
            texthighlightColor[i].dispose();
            ColorManager.texthighlightColor[i] = null;
        }
    }

    public static void SetbkColor(Color clr) {
        if (bkColor != null && !bkColor.isDisposed()) {
            bkColor.dispose();
            bkColor = null;
        }
        bkColor = clr;
    }

    public static Color GetbkColor() {
        return bkColor;
    }

    public static void SettextColor(Color clr) {
        if (textColor != null && !textColor.isDisposed()) {
            textColor.dispose();
            textColor = null;
        }
        textColor = clr;
    }

    public static Color GettextColor() {
        return textColor;
    }

    public static void SethighlightColor(Color clr) {
        if (highlightColor != null && !highlightColor.isDisposed()) {
            highlightColor.dispose();
            highlightColor = null;
        }
        highlightColor = clr;
    }

    public static Color GethighlightColor() {
        return highlightColor;
    }

    public static Color getTextHighlightColor(int i) {
        return texthighlightColor[i];
    }

    public static void setTextHighlightColor(Color clr, int index) {
        if (index < MAX_TEXTHIGHLIHGHTCOLOR && index >= 0) {
            ColorManager.texthighlightColor[index] = clr;
        }
    }

    public static void setTextHighlightColor(RGB[] rgb) {
        if (rgb != null && rgb.length > 0) {
            for (int i = 0; i < MAX_TEXTHIGHLIHGHTCOLOR; ++i) {
                ColorManager.texthighlightColor[i] = rgb.length > i ? new Color(null, rgb[i].red, rgb[i].green, rgb[i].blue) : new Color(null, rgb[0].red, rgb[0].green, rgb[0].blue);
            }
        } else {
            System.out.println("TextHighlightColor is not set correctly");
        }
    }

    public static Color ShowColorDialog() {
        Shell sh = new Shell(Display.getDefault());
        ColorDialog dlg = new ColorDialog(sh);
        RGB rgb = dlg.getRGB();
        Color clr = new Color(Display.getDefault(), rgb);
        return clr;
    }
}

