/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ui.FileFilterWindow;
import ui.MainUI;
import ui.SearchText;

public class CompositeSearchText {
    Boolean bOriginalImage = true;
    Image buttonImage1 = null;
    Image buttonImage2 = null;
    Image buttonImage3 = null;
    Label lblFileFilter;
    SearchText text;
    Label lblClear;
    Label lblSearch;
    MainUI mainUI;
    Composite baseComposite;
    Color lblFileFilterclr;
    Color lblFileFilterBKclr;

    public SearchText GetTextControl() {
        return this.text;
    }

    public Label GetlblSearch() {
        return this.lblSearch;
    }

    public Label GetlblFileFilter() {
        return this.lblFileFilter;
    }

    public Label GetLabelSearchClear() {
        return this.lblClear;
    }

    public Composite getBaseComposite() {
        return this.baseComposite;
    }

    public void UpdateFileFitlerLabel(int cnt) {
        try {
            if (cnt == 0) {
                this.lblFileFilter.setForeground(this.lblFileFilterclr);
                this.lblFileFilter.setBackground(this.lblFileFilterBKclr);
                this.lblFileFilter.setImage(this.buttonImage3);
                this.lblFileFilter.setToolTipText(Mytranslator.getInstance().getTranslate("FilterTipNoFile"));
                this.lblFileFilter.setEnabled(false);
            } else {
                this.lblFileFilter.setEnabled(true);
                this.lblFileFilter.setImage(null);
                this.lblFileFilter.setText("");
                Display display = this.baseComposite.getShell().getDisplay();
                this.lblFileFilter.setBackground(display.getSystemColor(6));
                this.lblFileFilter.setForeground(display.getSystemColor(1));
                this.lblFileFilter.setAlignment(0x1000000);
                this.lblFileFilter.setText(Integer.toString(cnt));
                this.lblFileFilter.setToolTipText(String.format(Mytranslator.getInstance().getTranslate("FilterTip"), cnt));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompositeSearchText(MainUI mainU, Composite parent, GridData gd, Display display) {
        this.mainUI = mainU;
        this.baseComposite = new Composite(parent, 2048);
        this.baseComposite.setLayoutData(gd);
        GridLayout baseCompositeGridLayout = new GridLayout(4, false);
        baseCompositeGridLayout.marginHeight = 0;
        baseCompositeGridLayout.marginWidth = 0;
        this.baseComposite.setLayout(baseCompositeGridLayout);
        this.baseComposite.setBackground(new Color(parent.getDisplay(), new RGB(255, 255, 255)));
        this.baseComposite.setBackgroundMode(2);
        final Cursor cursor = new Cursor(Display.getCurrent(), 21);
        try {
            InputStream in = this.getClass().getResource("searchmag.gif").openStream();
            this.buttonImage1 = new Image((Device)parent.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("SearchDelete.gif").openStream();
            this.buttonImage2 = new Image((Device)parent.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("SearchFilter.gif").openStream();
            this.buttonImage3 = new Image((Device)parent.getDisplay(), in);
            in.close();
        }
        catch (MalformedURLException e) {
            this.buttonImage1 = null;
            this.buttonImage2 = null;
            this.buttonImage3 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblFileFilter = new Label(this.baseComposite, 0);
        this.lblFileFilter.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage3 != null) {
            this.lblFileFilter.setImage(this.buttonImage3);
        }
        this.text = new SearchText(this, this.baseComposite, 4);
        this.text.init(display, this.baseComposite.getShell());
        this.text.setLayoutData(new GridData(4, 4, true, true));
        this.lblClear = new Label(this.baseComposite, 0);
        this.lblClear.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage2 != null) {
            this.lblClear.setImage(this.buttonImage2);
        }
        this.lblSearch = new Label(this.baseComposite, 0);
        this.lblSearch.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage1 != null) {
            this.lblSearch.setImage(this.buttonImage1);
        }
        this.lblSearch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                CompositeSearchText.this.text.Search();
            }
        });
        this.lblClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                CompositeSearchText.this.mainUI.clearSearchResult();
            }
        });
        this.lblFileFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                FileFilterWindow w = new FileFilterWindow();
                w.open(CompositeSearchText.this.mainUI);
            }
        });
        this.lblFileFilterBKclr = this.lblFileFilter.getBackground();
        this.lblFileFilterclr = this.lblFileFilter.getForeground();
        this.lblSearch.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblSearch.setCursor(cursor);
            }
        });
        this.lblClear.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblClear.setCursor(cursor);
            }
        });
        this.lblFileFilter.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblFileFilter.setCursor(cursor);
            }
        });
    }
}

