/*
 * Decompiled with CFR 0.152.
 */
package biz;

import java.io.File;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import ui.UtilityClass;

public class HttpServer {
    protected static Server server = null;
    protected static String Urlfolder = "";
    protected static String serverfoler = "";
    static boolean isViewable = true;

    public static void setViewable(boolean b) {
        isViewable = b;
    }

    public static boolean getViewable() {
        return isViewable;
    }

    public static String getHttpServerlink() {
        if (server == null) {
            return "";
        }
        NetworkConnector network = (NetworkConnector)server.getConnectors()[0];
        int port = network.getLocalPort();
        String str = UtilityClass.getPCName();
        if (!str.isEmpty()) {
            return "http://" + str + ":" + port + Urlfolder;
        }
        return "";
    }

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            port = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return port;
    }

    public static int getHttpServerPort() {
        if (server == null || !"STARTED".equals(server.getState())) {
            return 0;
        }
        NetworkConnector network = (NetworkConnector)server.getConnectors()[0];
        return network.getLocalPort();
    }

    public static String getPublicFolder() {
        if (serverfoler.isEmpty()) {
            return "";
        }
        File file = new File(serverfoler);
        return file.getAbsolutePath();
    }

    public static boolean HttpServerInit(String realfolder, String urlfolder, int port) {
        if (port == 0) {
            port = HttpServer.findFreePort();
        }
        boolean bRet = true;
        try {
            server = new Server(port);
            ResourceHandler resourceHandler = new ResourceHandler();
            File file = new File(realfolder);
            if (!file.exists() || !file.isDirectory()) {
                file.mkdir();
                System.out.println("creating..." + file.getAbsolutePath());
            } else {
                System.out.println("..." + file.getAbsolutePath());
            }
            resourceHandler.setResourceBase(realfolder);
            resourceHandler.setDirectoriesListed(isViewable);
            ContextHandler contextHandler = new ContextHandler(urlfolder);
            contextHandler.setHandler((Handler)resourceHandler);
            server.setHandler((Handler)contextHandler);
            serverfoler = realfolder;
            Urlfolder = urlfolder;
        }
        catch (Exception e) {
            bRet = false;
        }
        return bRet;
    }

    public static void HttpServerStart() {
        try {
            if (server != null) {
                server.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getHttpServerStatus() {
        if (server != null) {
            return server.getState();
        }
        return "";
    }

    public static void HttpServerStop() {
        try {
            if (server != null) {
                server.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

