/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.iFilePreview;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import ui.UtilityClass;

public class PPTPreview
implements iFilePreview {
    private int iCur = 1;
    private int sheetCnt = 0;
    private List<XSLFSlide> slide;
    Dimension pgsize;
    double zoom = 1.0;
    AffineTransform at;
    String prefix;

    @Override
    public boolean hasNext() {
        return this.iCur < this.sheetCnt;
    }

    @Override
    public boolean hasPrevious() {
        return this.iCur > 1;
    }

    public int getSheetNumber() {
        return this.sheetCnt;
    }

    public int getCurSheetNo() {
        return this.iCur;
    }

    @Override
    public String previewFile(String filename) throws Exception {
        this.prefix = UtilityClass.GetUniqTempFile(filename);
        String strPng = this.PPTtoImage(filename, 1);
        return strPng;
    }

    private String PPTtoImage(String strFile, int iPage) throws Exception {
        FileInputStream is = new FileInputStream(strFile);
        XMLSlideShow ppt = new XMLSlideShow((InputStream)is);
        is.close();
        this.at = new AffineTransform();
        this.at.setToScale(this.zoom, this.zoom);
        this.pgsize = ppt.getPageSize();
        this.slide = ppt.getSlides();
        this.sheetCnt = this.slide.size();
        this.iCur = 1;
        BufferedImage img = new BufferedImage((int)Math.ceil((double)this.pgsize.width * this.zoom), (int)Math.ceil((double)this.pgsize.height * this.zoom), 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setTransform(this.at);
        graphics.setPaint(Color.white);
        graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, this.pgsize.width, this.pgsize.height));
        this.slide.get(0).draw(graphics);
        String pngFile = this.prefix + this.iCur + ".png";
        FileOutputStream out = new FileOutputStream(pngFile);
        ImageIO.write((RenderedImage)img, "png", out);
        out.close();
        ppt.close();
        return pngFile;
    }

    @Override
    public String Next(String filename) throws Exception {
        ++this.iCur;
        if (this.iCur <= this.sheetCnt) {
            BufferedImage img = new BufferedImage((int)Math.ceil((double)this.pgsize.width * this.zoom), (int)Math.ceil((double)this.pgsize.height * this.zoom), 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setTransform(this.at);
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, this.pgsize.width, this.pgsize.height));
            this.slide.get(this.iCur - 1).draw(graphics);
            String pngFile = this.prefix + this.iCur + ".png";
            FileOutputStream out = new FileOutputStream(pngFile);
            ImageIO.write((RenderedImage)img, "png", out);
            out.close();
            return pngFile;
        }
        return "";
    }

    @Override
    public String Previous(String filename) throws Exception {
        --this.iCur;
        if (this.iCur >= 0) {
            BufferedImage img = new BufferedImage((int)Math.ceil((double)this.pgsize.width * this.zoom), (int)Math.ceil((double)this.pgsize.height * this.zoom), 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setTransform(this.at);
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, this.pgsize.width, this.pgsize.height));
            this.slide.get(this.iCur - 1).draw(graphics);
            String pngFile = this.prefix + this.iCur + ".png";
            FileOutputStream out = new FileOutputStream(pngFile);
            ImageIO.write((RenderedImage)img, "png", out);
            out.close();
            return pngFile;
        }
        return "";
    }
}

