/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.IchitaroParsing;
import biz.MyAutoDetectParser;
import biz.MyPDFTextStripper;
import biz.configclass;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import ui.UtilityClass;

public class TextExtractor {
    static ByteArrayOutputStream outputstream = null;
    static InputStream input = null;
    static ParseContext context;
    static Detector detector;
    static MyAutoDetectParser parser;
    static Metadata metadata;
    static String extractedText;
    static boolean bpage;
    static ArrayList<Integer> pageline;
    static ArrayList<Integer> JTDdic;

    public static ArrayList<Integer> pageLine() {
        return pageline;
    }

    public static Metadata getMetadata() {
        return metadata;
    }

    private static void init() {
        context = new ParseContext();
        detector = new DefaultDetector();
        parser = new MyAutoDetectParser(detector);
        context.set(Parser.class, (Object)parser);
        outputstream = new ByteArrayOutputStream();
        metadata = new Metadata();
        extractedText = "";
    }

    private static void terminal() {
        context = null;
        detector = null;
        parser = null;
    }

    public static boolean bHasPage() {
        return bpage;
    }

    private static void process(String filename) throws OutOfMemoryError, TikaException, FileNotFoundException, Exception {
        TextExtractor.init();
        File file = new File(filename);
        URL url = file.isFile() ? file.toURI().toURL() : new URL(filename);
        String strExt = UtilityClass.getFileExtension(filename);
        if (!strExt.isEmpty()) {
            if ("pdf".equalsIgnoreCase(strExt)) {
                PDDocument doc = PDDocument.load((File)new File(filename));
                MyPDFTextStripper stripper = new MyPDFTextStripper();
                extractedText = stripper.getText(doc);
                pageline = stripper.GetPageLines();
                doc.close();
                bpage = true;
            } else if ("jtd".equalsIgnoreCase(strExt) || "jfw".equalsIgnoreCase(strExt)) {
                if (JTDdic.size() == 0) {
                    JTDdic = IchitaroParsing.initJTDDict();
                }
                extractedText = IchitaroParsing.ExtractJTD(filename, JTDdic);
                bpage = false;
            }
        }
        if (!("pdf".equalsIgnoreCase(strExt) || "jtd".equalsIgnoreCase(strExt) || "jfw".equalsIgnoreCase(strExt))) {
            BodyContentHandler handler;
            input = TikaInputStream.get((URL)url, (Metadata)metadata);
            if (-1 == parser.MyParse(input, (ContentHandler)(handler = new BodyContentHandler((OutputStream)outputstream)), metadata, context)) {
                extractedText = "";
            } else {
                extractedText = outputstream.toString();
                outputstream.close();
            }
            input.close();
            input = null;
        }
        TextExtractor.terminal();
    }

    private static boolean ProcessIchitaroAutomation(String filename) throws Exception {
        File file;
        Process p = Runtime.getRuntime().exec("cscript -nologo jtFilter.vbe " + filename);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), "Shift_JIS"));
        boolean bRet = true;
        String BatchResultline = "";
        String outputFile = "";
        while ((BatchResultline = input.readLine()) != null) {
            outputFile = BatchResultline;
            if (!BatchResultline.contains(UtilityClass.ERR_STRING1) && !BatchResultline.contains(UtilityClass.ERR_STRING2)) continue;
            if (BatchResultline.contains(UtilityClass.ERR_Automation)) {
                UtilityClass.OutputLogFile("Ichitaro Software not installed: " + filename);
            }
            bRet = false;
            break;
        }
        input.close();
        if (bRet && (file = new File(outputFile)).exists()) {
            extractedText = FileUtils.readFileToString((File)file, (String)"Shift_JIS");
        }
        return bRet;
    }

    private static void process2(String filename) throws OutOfMemoryError, TikaException, FileNotFoundException, Exception {
        try {
            extractedText = "";
            Process p = Runtime.getRuntime().exec("data.exe d \"" + filename + "\" z");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), "Shift_JIS"));
            boolean bRet = true;
            String BatchResultline = "";
            String outputFile = "";
            while ((BatchResultline = input.readLine()) != null) {
                outputFile = BatchResultline;
                if (!BatchResultline.contains(UtilityClass.ERR_STRING1) && !BatchResultline.contains(UtilityClass.ERR_STRING2)) continue;
                if (BatchResultline.contains(UtilityClass.ERR_INTERFACE)) {
                    UtilityClass.OutputLogFile("IFilter not installed: " + filename);
                }
                bRet = false;
                break;
            }
            input.close();
            if (bRet) {
                File file = new File(outputFile);
                if (file.exists()) {
                    extractedText = FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
            } else {
                String filenamelowcase = filename.toLowerCase();
                if (filenamelowcase.endsWith("jtd") || filenamelowcase.endsWith("jfw") || filenamelowcase.endsWith("jtdc")) {
                    TextExtractor.ProcessIchitaroAutomation(filename);
                }
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public static String RetreiveTextFile(String strFile) {
        try {
            bpage = false;
            String strIsFilter = configclass.getInstance("config.xml").getIFilter(UtilityClass.getFileExtension(strFile));
            if ("1".equals(strIsFilter)) {
                TextExtractor.process2(strFile);
            } else {
                TextExtractor.process(strFile);
            }
        }
        catch (OutOfMemoryError ee) {
            UtilityClass.OutputUnhandledFile(strFile);
            UtilityClass.OutputLogFile("memory exception" + ee.getMessage());
            extractedText = UtilityClass.MEMORYOUT;
        }
        catch (TikaException eee) {
            extractedText = "";
            eee.printStackTrace();
            UtilityClass.OutputLogFile(eee.getMessage());
        }
        catch (FileNotFoundException eeee) {
            eeee.printStackTrace();
            extractedText = "";
            UtilityClass.OutputLogFile(eeee.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilityClass.OutputUnhandledFile(strFile);
            UtilityClass.OutputLogFile("RetreiveTextFile: general exception:" + e.getMessage() + strFile);
            extractedText = UtilityClass.GENERALERR;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                    input = null;
                }
                if (outputstream != null) {
                    outputstream.close();
                    outputstream = null;
                }
                TextExtractor.terminal();
            }
            catch (Exception e) {
                UtilityClass.OutputLogFile("finally catch" + e.getMessage());
            }
        }
        return extractedText;
    }

    static {
        bpage = false;
        pageline = null;
        JTDdic = new ArrayList();
    }
}

