/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import biz.HighlightWord;
import biz.ScrollDataProvider;
import biz.TextScrollDataProvider;
import biz.configclass;
import biz.searchFolder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import ui.InterfaceTextEvent;
import ui.StyledTextScroll;
import ui.TextPreviewThread;
import ui.UtilityClass;

public class MyText
extends StyledTextScroll {
    private boolean showLineNo = false;
    private InterfaceTextEvent _interText;
    private int _curline = 0;
    private boolean isSystemFont = true;

    public void setShowLineNo(boolean b) {
        this.showLineNo = b;
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    public void dispose() {
        Font ft = this.getFont();
        ft.dispose();
        super.dispose();
    }

    private void createPopupMenu() {
        final Menu rightmenu = new Menu(this);
        rightmenu.addListener(22, new Listener(){

            @Override
            public void handleEvent(Event event) {
                for (int i = 0; i < rightmenu.getItemCount(); ++i) {
                    rightmenu.getItem(i).setEnabled(MyText.this.m_dataProvider.getMatchedLine() != null);
                }
                if (MyText.this.getText().isEmpty()) {
                    rightmenu.getItem(4).setEnabled(false);
                } else {
                    rightmenu.getItem(4).setEnabled(true);
                }
                if (MyText.this.getSelectionCount() != 0) {
                    rightmenu.getItem(5).setEnabled(true);
                    rightmenu.getItem(8).setEnabled(true);
                    rightmenu.getItem(9).setEnabled(true);
                } else {
                    rightmenu.getItem(5).setEnabled(false);
                    rightmenu.getItem(8).setEnabled(false);
                    rightmenu.getItem(9).setEnabled(false);
                }
                boolean bhasPageInfo = false;
                if (MyText.this.m_dataProvider.getStatus() != UtilityClass.ViewType.NoView && MyText.this._interText.EnableRightMenuJumpPDFPage()) {
                    bhasPageInfo = true;
                }
                rightmenu.getItem(7).setEnabled(bhasPageInfo);
                System.out.println("ViewType.mode = " + MyText.this.m_dataProvider.getStatus().toString());
                if (MyText.this.m_dataProvider.getStatus() == UtilityClass.ViewType.LineView) {
                    rightmenu.getItem(0).setEnabled(false);
                } else if (MyText.this.m_dataProvider.getStatus() == UtilityClass.ViewType.FullTextView) {
                    rightmenu.getItem(2).setEnabled(false);
                } else {
                    rightmenu.getItem(1).setEnabled(false);
                }
            }
        });
        MenuItem MnuItemShowLineDisplay = new MenuItem(rightmenu, 8);
        MnuItemShowLineDisplay.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this.ShowSelectedLinesRightMenu_thread(MyText.this.m_dataProvider.getQueryRegString(), MyText.this._curline);
            }
        });
        MnuItemShowLineDisplay.setText(Mytranslator.getInstance().getTranslate("LineDisplay"));
        MenuItem MnuItemShowTextRangeDisplay = new MenuItem(rightmenu, 8);
        MnuItemShowTextRangeDisplay.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this.ShowSelectedTextRangesRightMenu_thread(MyText.this.m_dataProvider.getQueryRegString(), MyText.this._curline);
            }
        });
        MnuItemShowTextRangeDisplay.setText(Mytranslator.getInstance().getTranslate("DisplayHighlighKey"));
        MenuItem MnuItemDisplayFullText = new MenuItem(rightmenu, 8);
        MnuItemDisplayFullText.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this.showLineNo_thread(MyText.this.showLineNo, MyText.this.m_dataProvider.getQueryRegString(), MyText.this._curline);
            }
        });
        MnuItemDisplayFullText.setText(Mytranslator.getInstance().getTranslate("Opentext"));
        new MenuItem(rightmenu, 2);
        MenuItem MnuItemDisplaySelectAll = new MenuItem(rightmenu, 8);
        MnuItemDisplaySelectAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this.selectAll();
            }
        });
        MnuItemDisplaySelectAll.setText(Mytranslator.getInstance().getTranslate("SelectAll"));
        MenuItem MnuItemDisplayCopy = new MenuItem(rightmenu, 8);
        MnuItemDisplayCopy.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this.copy();
            }
        });
        MnuItemDisplayCopy.setText(Mytranslator.getInstance().getTranslate("Copy"));
        new MenuItem(rightmenu, 2);
        MenuItem MnuItemGotoPDFPage = new MenuItem(rightmenu, 8);
        MnuItemGotoPDFPage.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!MyText.this.GotoCurPage()) {
                    Shell shell = new Shell(Display.getDefault());
                    MessageBox messageBox = new MessageBox(shell, 34);
                    messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                    messageBox.setMessage(Mytranslator.getInstance().getTranslate("NeedPDFOpener"));
                    messageBox.open();
                    shell.close();
                }
            }
        });
        MnuItemGotoPDFPage.setText(Mytranslator.getInstance().getTranslate("GotoPDFPage"));
        MenuItem MnuItemSearchText = new MenuItem(rightmenu, 8);
        MnuItemSearchText.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this._interText.AddtoSearch(MyText.this.getSelectionText());
            }
        });
        MnuItemSearchText.setText(Mytranslator.getInstance().getTranslate("AddtoSearch"));
        this.setMenu(rightmenu);
        MenuItem MnuItemNewSearchText = new MenuItem(rightmenu, 8);
        MnuItemNewSearchText.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                MyText.this._interText.NewSearch(MyText.this.getSelectionText());
            }
        });
        MnuItemNewSearchText.setText(Mytranslator.getInstance().getTranslate("NewSearch"));
        this.setMenu(rightmenu);
    }

    public boolean GotoCurPage() {
        int page = this.m_dataProvider.GetLineIndex(this._curline, (String)this.getData());
        try {
            String strCmd = UtilityClass.getPDFExePath();
            if (strCmd == null || strCmd.toLowerCase().endsWith("chrome.exe") || strCmd.toLowerCase().endsWith("iexplore.exe")) {
                return false;
            }
            String[] cmdline = new String[]{strCmd, "/A", "page=" + page, this.m_dataProvider.getFilename()};
            Runtime.getRuntime().exec(cmdline);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
        return true;
    }

    public MyText(Composite parent, int style, InterfaceTextEvent textInter, TextScrollDataProvider dataProvider) {
        super(parent, style);
        this.m_dataProvider = dataProvider;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    int iIndex = MyText.this.getLineIndex(e.y);
                    if (iIndex >= MyText.this.getLineCount()) {
                        --iIndex;
                    }
                    MyText.this._curline = MyText.this.getAbsolutLineIndex(iIndex);
                }
            }
        });
        this._interText = textInter;
        this.initFont();
        this.createPopupMenu();
        Listener keyListener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (StyledTextScroll.vBar.getSize().y + StyledTextScroll.vBar.getSelection() == StyledTextScroll.vBar.getMaximum()) {
                    MyText.this.RollInNextPage();
                }
                if (StyledTextScroll.vBar.getSelection() == 0) {
                    MyText.this.RollInPreviewPage();
                }
            }
        };
        this.addListener(2, keyListener);
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, keyListener);
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.addListener(13, keyListener);
        }
        Listener resizeListener = new Listener(){

            @Override
            public void handleEvent(Event e) {
                int y = MyText.this.getClientArea().height;
                int bottomIndex = MyText.this.getLineIndex(y);
                int cnt = MyText.this.getLineCount();
                if (cnt > 1 && bottomIndex == cnt - 1) {
                    MyText.this.RollInNextPage();
                }
            }
        };
        this.addListener(11, resizeListener);
    }

    private int getAbsolutLineIndex(int iline) {
        int iAbsolutline = this.m_dataProvider.GetAbsoluteLine(iline);
        return iAbsolutline;
    }

    private void initFont() {
        int iSize = configclass.getInstance("config.xml").getFontsize();
        String fontName = configclass.getInstance("config.xml").getFontName();
        if (iSize < 6 || iSize > 50) {
            iSize = this.getFontsize();
        }
        if (fontName.equals("")) {
            FontData[] fd = this.getFont().getFontData();
            fontName = fd[0].getName();
        }
        this.setFont(fontName, iSize);
    }

    public void setFont(String fontName, int i) {
        Font myFont = new Font((Device)Display.getDefault(), fontName, i, 0);
        Font oldFont = this.getFont();
        this.setFont(myFont);
        if (!this.isSystemFont) {
            oldFont.dispose();
        }
        this.isSystemFont = false;
        configclass.getInstance("config.xml").setFontsize(i);
        configclass.getInstance("config.xml").setFontName(fontName);
        configclass.getInstance("config.xml").Save();
    }

    public int getFontsize() {
        FontData[] fD = this.getFont().getFontData();
        int iSize = fD[0].getHeight();
        return iSize;
    }

    public void ShowMatchedLines_thread(String filename, String queryRegString, searchFolder sf, String searchKey, String fileTime) {
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 3, this.showLineNo, -1, sf, queryRegString, searchKey, filename, fileTime, true);
        thread.start();
    }

    public void showProgress(int icurrent, int min, int total) {
        final MyText _myText = this;
        if (icurrent % min == 0) {
            final float per = (float)icurrent / (float)total * 100.0f;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String str = String.format("(%,.2f%%)", Float.valueOf(per));
                    if (_myText != null && !_myText.isDisposed()) {
                        _myText.setText(Mytranslator.getInstance().getTranslate("processing") + str);
                    }
                }
            });
        }
    }

    public void _showMatchedLines(int iline) {
        StringBuffer strBuf = this.m_dataProvider.CalculateMatchedLines(iline, this);
        final int _iline = this.m_dataProvider.GetHighLineIndex();
        if (strBuf != null) {
            StyleRange[] stylearrays = this.m_dataProvider.GetAllStyleRange();
            this.ShowAllContents(strBuf, stylearrays);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MyText.this.StartPagination(_iline);
                }
            });
        }
    }

    private void StartPagination(int startline) {
        this.populateTextControl(startline, true);
    }

    public void Clear() {
        this.setText("");
        this.m_dataProvider.Clear();
    }

    public void showLineNo_thread(boolean showno, String queryRegString, int iline) {
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 4, this.showLineNo, iline, null, queryRegString, "", "", "", true);
        thread.start();
    }

    public void ShowFullText_thread(String filename, String queryRegString, int iline, searchFolder sf, String searchkey2, String fileTime, boolean bSearchContent) {
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 1, this.showLineNo, iline, sf, queryRegString, searchkey2, filename, fileTime, bSearchContent);
        thread.start();
    }

    private void ShowAllContents(StringBuffer strB, StyleRange[] stylearrays) {
        final MyText _myText = this;
        final int _iline = this.m_dataProvider.GetHighLineIndex();
        final StringBuffer strBuf = strB;
        final StyleRange[] stylearray = stylearrays;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                _myText.setText(strBuf.toString());
                if (stylearray != null && stylearray.length != 0) {
                    _myText.setStyleRanges(stylearray);
                    if (_iline >= 0) {
                        _myText.HighlightLine(_myText, _iline, "", true);
                    }
                    _myText.redraw();
                }
            }
        });
    }

    public void _ShowSelectedTextRange(int iline) {
        try {
            StringBuffer strBuf = this.m_dataProvider.CalculateRange(iline, this);
            final int _iline = this.m_dataProvider.GetHighLineIndex();
            if (strBuf != null) {
                StyleRange[] stylearrays = this.m_dataProvider.GetAllStyleRange();
                this.ShowAllContents(strBuf, stylearrays);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MyText.this.StartPagination(_iline);
                    }
                });
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void ShowSelectedTextRanges_thread(String filename, String queryRegString, int iline, searchFolder sf, String searchKey2, String fileTime, boolean bSearchContent) {
        UtilityClass.OutputLogFile("new ShowSelectedTextRange_Thread");
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 2, this.showLineNo, iline, sf, queryRegString, searchKey2, filename, fileTime, bSearchContent);
        thread.start();
    }

    public void ShowSelectedTextRangesRightMenu_thread(String queryRegString, int iline) {
        this.m_dataProvider.setQueryRegString(queryRegString);
        UtilityClass.OutputLogFile("new ShowSelectedTextRange_Thread right menu");
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 5, this.showLineNo, iline, null, queryRegString, "", "", "", true);
        thread.start();
    }

    public void ShowSelectedLinesRightMenu_thread(String queryRegString, int iline) {
        TextPreviewThread thread = new TextPreviewThread(this, this.m_dataProvider, 6, this.showLineNo, iline, null, queryRegString, "", "", "", true);
        thread.start();
    }

    @Override
    public void HighlightLine(StyledText text, int lineIndex, String prefix, boolean setTopIndex) {
        int offset = text.getOffsetAtLine(lineIndex);
        text.setCaretOffset(offset);
        text.insert(prefix);
        int len = text.getLine(lineIndex).length();
        StyleRange[] st = text.getStyleRanges();
        ArrayList<StyleRange> overlappedRange = new ArrayList<StyleRange>();
        for (StyleRange aRange : st) {
            if (aRange.start >= offset && aRange.start < offset + len) {
                overlappedRange.add(aRange);
            }
            if (aRange.start >= offset + len) break;
        }
        StyleRange lineRange = new StyleRange();
        lineRange.start = offset;
        lineRange.length = len;
        lineRange.underline = true;
        lineRange.underlineStyle = 4;
        lineRange.rise = 2;
        text.setStyleRange(lineRange);
        for (StyleRange overlappedStyle : overlappedRange) {
            text.setStyleRange(overlappedStyle);
        }
        if (setTopIndex) {
            text.setTopIndex(lineIndex);
        }
    }

    public void findPrev() {
        try {
            this.m_dataProvider.gotoPrevPos(this.showLineNo);
            this.SelectKeyword(false);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
            this.ShowErrorMsg("invalidchar");
        }
    }

    public void findNext() {
        try {
            this.m_dataProvider.gotoNextPos(this.showLineNo);
            this.SelectKeyword(true);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
            this.ShowErrorMsg("invalidchar");
        }
    }

    private void SelectKeyword(boolean forward) throws Exception {
        List<HighlightWord> allHighlightWords = this.m_dataProvider.getAllRanges();
        int iCurrentFound = this.m_dataProvider.getCurrentSelectedKeyIndex();
        if (allHighlightWords != null && allHighlightWords.size() > 0) {
            if (iCurrentFound < allHighlightWords.size()) {
                if (iCurrentFound < 0) {
                    Shell shell = new Shell(Display.getDefault());
                    MessageBox messageBox = new MessageBox(shell, 290);
                    messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                    messageBox.setMessage(Mytranslator.getInstance().getTranslate("StartofFile"));
                    if (32 == messageBox.open()) {
                        this.m_dataProvider.setCurrentSelectedKeyIndex(allHighlightWords.size());
                        this.findPrev();
                    }
                } else {
                    System.out.println(allHighlightWords.get(iCurrentFound));
                    HighlightWord highWord = allHighlightWords.get(iCurrentFound);
                    if (!this.m_dataProvider.isPaginationMode()) {
                        int istart = highWord.offsetLine + this.getOffsetAtLine(highWord.lineIndex);
                        this.setSelection(istart, istart + highWord.length);
                    } else {
                        ScrollDataProvider.Page activeRangePage = this.m_dataProvider.getActiveRange();
                        if (iCurrentFound >= activeRangePage.pageStartIndex && iCurrentFound <= activeRangePage.pageEndIndex) {
                            ScrollDataProvider.Page scope = this.m_dataProvider.getCurrentDataScope();
                            int lineInView = highWord.lineIndex - scope.pageStartIndex;
                            int istart = highWord.offsetLine + this.getOffsetAtLine(lineInView);
                            System.out.println("still in the view:" + lineInView);
                            this.setSelection(istart, istart + highWord.length);
                        } else {
                            System.out.println("loading the new page" + highWord.lineIndex);
                            if (forward) {
                                this.populateTextControl(highWord.lineIndex, false);
                            } else {
                                int startline = highWord.lineIndex - UtilityClass.pagelines;
                                if (startline < 0) {
                                    startline = 0;
                                }
                                this.populateTextControl(startline, true);
                            }
                            int istart = 0;
                            ScrollDataProvider.Page scope = this.m_dataProvider.getCurrentDataScope();
                            int lineInView = highWord.lineIndex - scope.pageStartIndex;
                            istart = highWord.offsetLine + this.getOffsetAtLine(lineInView);
                            System.out.println("still in the view:" + lineInView);
                            this.setSelection(istart, istart + highWord.length);
                        }
                    }
                }
            } else {
                Shell shell = new Shell(Display.getDefault());
                MessageBox messageBox = new MessageBox(shell, 290);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("EndofFile"));
                if (32 == messageBox.open()) {
                    this.m_dataProvider.setCurrentSelectedKeyIndex(-1);
                    this.findNext();
                }
            }
        }
    }

    public void _DrawFullText(boolean bIsShowLine, int iline) {
        try {
            this.showLineNo = bIsShowLine;
            StringBuffer strBuf = this.m_dataProvider.CalculateFullContent(iline, this.showLineNo, this);
            final int _iline = this.m_dataProvider.GetHighLineIndex();
            if (strBuf != null) {
                StyleRange[] stylearrays = this.m_dataProvider.GetAllStyleRange();
                this.ShowAllContents(strBuf, stylearrays);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MyText.this.StartPagination(_iline);
                    }
                });
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void ShowErrorMsg(String str) {
        final MyText _myText = this;
        final String _str = str;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                _myText.setText(Mytranslator.getInstance().getTranslate(_str));
            }
        });
    }
}

