/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.APIBase;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import ui.UtilityClass;

public class Certificate {
    public static String ver = "3.2.2.2";
    private static final String _Logic = "HmacSHA256";
    public static final String certificate = ".cert";

    public static void init(String version) {
        ver = version;
    }

    public static void CreateCertificate(String strOriginCode) {
        try {
            List<String> strList = Certificate.obtainMacAddress();
            if (!strList.isEmpty()) {
                File file = new File(certificate);
                if (file.isFile() && file.exists()) {
                    file.delete();
                }
                ArrayList<String> strEncodedList = new ArrayList<String>();
                String strText = Certificate.generateAuthenticationKey(strOriginCode, ver, _Logic);
                strEncodedList.add(strText);
                for (String str : strList) {
                    strText = Certificate.generateAuthenticationKey(strOriginCode, str, _Logic);
                    strEncodedList.add(strText);
                }
                FileUtils.writeLines((File)file, strEncodedList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean ValidateCertificate(String strOriginCode) throws Exception {
        boolean bRet = false;
        File file = new File(certificate);
        if (file.isFile() && file.exists()) {
            List strList = FileUtils.readLines((File)file);
            List<String> strMacAddress = Certificate.obtainMacAddress();
            if (!strList.isEmpty() && !strMacAddress.isEmpty()) {
                String strOrigin;
                String strText = Certificate.generateAuthenticationKey(strOriginCode, ver, _Logic);
                if (!strText.equals(strOrigin = (String)strList.get(0))) {
                    return false;
                }
                for (String strMac : strMacAddress) {
                    strText = Certificate.generateAuthenticationKey(strOriginCode, strMac, _Logic);
                    if (!strList.contains(strText)) continue;
                    bRet = true;
                    break;
                }
            }
        }
        return bRet;
    }

    public static String RegisterCert(String strOrigincode) {
        String strRet = "0";
        try {
            if (!UtilityClass.isInternetConnected()) {
                strRet = "100";
            } else {
                List<String> strList = Certificate.obtainMacAddress();
                if (strList.isEmpty()) {
                    return "100";
                }
                String strTemp = "";
                for (String str : strList) {
                    if (strTemp.isEmpty()) {
                        strTemp = str;
                        continue;
                    }
                    strTemp = strTemp + "%2C" + str;
                }
                String strURL = "https://www.searchplusplus.jp/PassCheck/ps/ChkLic/" + strTemp + "=" + strOrigincode + "=0";
                strRet = APIBase.GetURLResponse(strURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strRet;
    }

    public static String RemoveRegisterCert(String strOrigincode) {
        String str = "";
        try {
            if (!UtilityClass.isInternetConnected()) {
                str = "100";
            } else {
                List<String> strList = Certificate.obtainMacAddress();
                if (strList.isEmpty()) {
                    return "100";
                }
                String strTemp = "";
                for (String strA : strList) {
                    if (strTemp.isEmpty()) {
                        strTemp = strA;
                        continue;
                    }
                    strTemp = strTemp + "%2C" + strA;
                }
                String strURL = "https://www.searchplusplus.jp/PassCheck/ps/UnRegister/" + strOrigincode + "=" + strTemp;
                str = APIBase.GetURLResponse(strURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    private static String base64Encode(byte[] bytes) {
        String encodeString = DatatypeConverter.printBase64Binary((byte[])bytes);
        return encodeString;
    }

    public static String generateAuthenticationKey(String target, String signatureKey, String algorithm) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(signatureKey.getBytes(), algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        mac.update(target.getBytes());
        byte[] encryptedData = mac.doFinal();
        return Certificate.base64Encode(encryptedData);
    }

    public static List<String> obtainMacAddress() throws Exception {
        ArrayList<String> listString = new ArrayList<String>();
        try {
            InetAddress ip = InetAddress.getLocalHost();
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                sb.append("");
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                String str = sb.toString();
                if (str.isEmpty() || str.equals("00-00-00-00-00-00-00-E0") || str.equals("00-50-56-C0-00-01") || str.equals("00-50-56-C0-00-08") || str.equals("0A-00-27-00-00-00") || listString.contains(str)) continue;
                listString.add(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String hostname = UtilityClass.getPCName();
        if (!hostname.isEmpty()) {
            listString.add(hostname);
        }
        return listString;
    }
}

