/*
 * Decompiled with CFR 0.152.
 */
package biz;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.w3c.dom.Document;
import ui.UtilityClass;

public class DocPreview {
    public String previewFile(String filename) throws Exception {
        String htmlFile = UtilityClass.GetUniqTempFile(filename) + "1.html";
        File file = new File(htmlFile);
        return DocPreview.toHtml(filename, file.getParent(), htmlFile);
    }

    private static String toHtml(String wordFile, String picPath, String htmlFile) throws Exception {
        try {
            FileInputStream finStream = new FileInputStream(wordFile);
            HWPFDocument doc = new HWPFDocument((InputStream)finStream);
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(newDocument);
            List pics = doc.getPicturesTable().getAllPictures();
            if (pics != null) {
                for (int i = 0; i < pics.size(); ++i) {
                    Picture pic = (Picture)pics.get(i);
                    try {
                        pic.writeImageContent((OutputStream)new FileOutputStream(picPath + "\\" + pic.suggestFullFileName()));
                        System.out.println(pic.suggestFullFileName() + " == " + picPath + "\\" + pic.suggestFullFileName());
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                    return suggestedName;
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)doc);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("method", "html");
            transformer.transform(new DOMSource(wordToHtmlConverter.getDocument()), new StreamResult(stringWriter));
            String html = stringWriter.toString();
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                out.write(html);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return htmlFile;
    }
}

