/*
 * Decompiled with CFR 0.152.
 */
package biz;

import Interface.Mytranslator;
import biz.HighlightWord;
import biz.KeyElmentInfo;
import biz.MyAnalyzer;
import biz.ScrollDataProvider;
import biz.configclass;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import ui.ColorManager;
import ui.InterfaceTextEvent;
import ui.MyDetailData;
import ui.MyText;
import ui.UtilityClass;

public class TextScrollDataProvider
extends ScrollDataProvider {
    private String[] strFileContentArray;
    private MyDetailData[] hitLines;
    private String strFilename;
    private Color _LineMarkerColor;
    private Color _highLightColor;
    private Boolean iPaginationMode = false;
    static UtilityClass.ViewType status = UtilityClass.ViewType.NoView;
    int iCurrentFound = -1;
    private String m_queryRegString;
    private MyAnalyzer analyzer;
    private List<Integer> AbstractLine;
    private List<Integer> lineViewIndex;
    private InterfaceTextEvent _interText;
    private Set<String> strSet = new HashSet<String>();
    int hotlineIndex = -1;

    public Set<String> searchKeyWordSet() {
        return this.strSet;
    }

    public void setSearchKeyWordSet(Set<String> aset) {
        this.strSet = aset;
    }

    public boolean getPaginationMode() {
        return this.iPaginationMode;
    }

    public int getCurrentSelectedKeyIndex() {
        return this.iCurrentFound;
    }

    public void setCurrentSelectedKeyIndex(int ifound) {
        this.iCurrentFound = ifound;
    }

    public void gotoNextPos(boolean showLineNo) {
        block1: {
            if (this.allKeywords.size() <= 0) break block1;
            do {
                ++this.iCurrentFound;
            } while (this.iCurrentFound < this.allKeywords.size() && ((HighlightWord)this.allKeywords.get((int)this.iCurrentFound)).background == null);
        }
    }

    public void gotoPrevPos(boolean showLineNo) {
        block1: {
            if (this.allKeywords.size() <= 0) break block1;
            do {
                --this.iCurrentFound;
            } while (this.iCurrentFound >= 0 && ((HighlightWord)this.allKeywords.get((int)this.iCurrentFound)).background == null);
        }
    }

    public int GetHighLineIndex() {
        return this.hotlineIndex;
    }

    public TextScrollDataProvider(InterfaceTextEvent interText) {
        this._interText = interText;
        this._LineMarkerColor = Display.getDefault().getSystemColor(15);
        this._highLightColor = Display.getDefault().getSystemColor(7);
        this.hitLines = null;
        this.strFileContentArray = null;
        this.strFilename = "";
    }

    public void initData(UtilityClass.ViewType mode, String queryString, String filename, MyDetailData[] hitline) {
        this.setQueryRegString(queryString);
        this.setMatchedLine(hitline);
        this.setFilename(filename);
    }

    public boolean isContentEmpty() {
        boolean bRet = false;
        if (this.strFileContentArray == null || this.strFileContentArray.length == 0) {
            bRet = true;
        }
        return bRet;
    }

    public String[] GetAllContents() {
        return this.strFileContentArray;
    }

    public int GetTotalLinesNumber() {
        return this.strFileContentArray.length;
    }

    public String GetlineContent(int index) {
        return this.strFileContentArray[index];
    }

    public String getQueryRegString() {
        return this.m_queryRegString;
    }

    public void setQueryRegString(String queryString) {
        this.m_queryRegString = queryString;
    }

    public String getFilename() {
        return this.strFilename;
    }

    public void setFilename(String filename) {
        this.strFilename = filename;
    }

    public UtilityClass.ViewType getStatus() {
        return status;
    }

    public int GetLineIndex(int icurline, String mouseTipData) {
        int page = 1;
        if (status == UtilityClass.ViewType.FullTextView && !this.isContentEmpty()) {
            if (UtilityClass.DebugMode) {
                System.out.println("current line" + icurline);
            }
            if (icurline >= this.GetTotalLinesNumber()) {
                icurline = this.GetTotalLinesNumber() - 1;
            }
            if (icurline <= 0) {
                icurline = 0;
            }
            String strkey = "^<<--" + Mytranslator.getInstance().getTranslate("Page_") + "([0-9]+)" + "-->>" + "$";
            for (int i = icurline; i < this.GetTotalLinesNumber(); ++i) {
                String strNew;
                if (this.strFileContentArray[i] == null || (strNew = this.strFileContentArray[i].replaceAll(strkey, "$1")).length() == this.strFileContentArray[i].length()) continue;
                page = Integer.valueOf(strNew);
                break;
            }
        } else if (status == UtilityClass.ViewType.LineView || status == UtilityClass.ViewType.TextRangeView) {
            String strMouseText = mouseTipData;
            int lineNo = 1;
            if (!strMouseText.isEmpty()) {
                int index = strMouseText.indexOf(":");
                lineNo = index != -1 ? Integer.valueOf(strMouseText.substring(0, index).trim()) : 1;
            }
            System.out.println("lineNo = " + lineNo);
            if (lineNo != 1) {
                page = this._interText.GetPageNobyLineNo(lineNo, this.strFilename);
            }
        }
        return page;
    }

    public void TextModeChanged(UtilityClass.ViewType vstatus) {
        status = vstatus;
        this.iCurrentFound = -1;
        this._interText.TextModeChange(status);
    }

    public int GetAbsoluteLine(int iline) {
        int iAbsolutline = 0;
        if (this.getPaginationMode()) {
            iline += this.getCurrentDataScope().pageStartIndex;
        }
        System.out.println("absolute line:" + iline);
        if (status == UtilityClass.ViewType.LineView) {
            if (iline < 0) {
                iline = 0;
            }
            if (iline >= this.lineViewIndex.size()) {
                iline = this.lineViewIndex.size() - 1;
            }
            iAbsolutline = this.lineViewIndex.get(iline);
        } else if (status == UtilityClass.ViewType.FullTextView) {
            if (iline < 0) {
                iline = 0;
            }
            if (iline >= this.strFileContentArray.length) {
                iline = this.strFileContentArray.length - 1;
            }
            iAbsolutline = iline;
        } else if (status == UtilityClass.ViewType.TextRangeView) {
            if (iline < 0) {
                iline = 0;
            }
            if (iline >= this.AbstractLine.size()) {
                iline = this.AbstractLine.size() - 1;
            }
            iAbsolutline = this.AbstractLine.get(iline);
        }
        return iAbsolutline;
    }

    public void setFileContent(String[] strArray) {
        this.strFileContentArray = strArray;
    }

    public void setMatchedLine(MyDetailData[] matchedData) {
        this.hitLines = matchedData;
    }

    public MyDetailData[] getMatchedLine() {
        return this.hitLines;
    }

    public void Clear() {
        this.hitLines = null;
        this.strFileContentArray = null;
        this.strFilename = "";
    }

    public void initThread() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
        this.analyzer = new MyAnalyzer();
        this.analyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
    }

    public void endThread() {
        if (this.analyzer != null) {
            this.analyzer.close();
            this.analyzer = null;
        }
    }

    public StringBuffer CalculateMatchedLines(int iline, MyText myText) {
        this.hotlineIndex = -1;
        this.lineViewIndex = new ArrayList<Integer>();
        String iMax = this.hitLines[this.hitLines.length - 1].lineno;
        int lineDigitalNumber = iMax.length() + 3;
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        ArrayList<HighlightWord> arr = new ArrayList<HighlightWord>();
        int istartPos = 0;
        for (MyDetailData line : this.hitLines) {
            if (Thread.currentThread().getName().endsWith(UtilityClass._THREADSTOP)) {
                return null;
            }
            String strLine = String.format("%" + lineDigitalNumber + "s:  %s", line.lineno, line.content);
            strLine = String.format("%s%s", strLine, System.getProperty("line.separator"));
            strBuf.append(strLine);
            if (iline == Integer.valueOf(line.lineno) - 1) {
                this.hotlineIndex = i;
            }
            this.lineViewIndex.add(Integer.valueOf(line.lineno) - 1);
            this.highlightKeyword(arr, istartPos, 0, strLine, i, false, this.lineViewIndex.size() - 1);
            istartPos += strLine.length();
            myText.showProgress(++i, 100, this.hitLines.length);
        }
        this.iPaginationMode = this.InitScrollPara(arr, strBuf);
        if (!this.iPaginationMode.booleanValue()) {
            return strBuf;
        }
        return null;
    }

    public StringBuffer CalculateFullContent(int iline, boolean showLineNo, MyText myText) {
        this.hotlineIndex = -1;
        if (this.strFileContentArray == null) {
            return null;
        }
        int totalLineNo = this.strFileContentArray.length;
        String lenStr = String.valueOf(totalLineNo);
        StringBuffer strBuf = new StringBuffer();
        int iLineNo = 0;
        int iAllLength = 0;
        ArrayList<HighlightWord> arr = new ArrayList<HighlightWord>();
        this.hotlineIndex = iline;
        for (String strline : this.strFileContentArray) {
            if (Thread.currentThread().getName().endsWith(UtilityClass._THREADSTOP)) {
                return null;
            }
            boolean bIsMatchedLine = this.isMatchedLine(++iLineNo);
            iAllLength = this.Displayline(lenStr.length(), iLineNo, iAllLength, strBuf, arr, bIsMatchedLine, showLineNo, iLineNo - 1);
            myText.showProgress(iLineNo, 500, totalLineNo);
        }
        this.iPaginationMode = this.InitScrollPara(arr, strBuf);
        if (!this.iPaginationMode.booleanValue()) {
            return strBuf;
        }
        return null;
    }

    private int[] setLines(MyDetailData[] hitlines) {
        int[] s = new int[hitlines.length];
        int i = 0;
        for (MyDetailData matchedline : hitlines) {
            s[i] = Integer.valueOf(matchedline.lineno);
            ++i;
        }
        return s;
    }

    private boolean isMatchedLine(int iLineNo) {
        boolean bMatchedLine = false;
        MyDetailData[] hitLines = this.getMatchedLine();
        if (hitLines != null && hitLines.length != 0) {
            for (MyDetailData iline : hitLines) {
                if (Integer.valueOf(iline.lineno) != iLineNo) continue;
                bMatchedLine = true;
                break;
            }
        }
        return bMatchedLine;
    }

    public StringBuffer CalculateRange(int iline, MyText myText) {
        this.hotlineIndex = -1;
        this.AbstractLine = new ArrayList<Integer>();
        UtilityClass.OutputLogFile("call showSelectedTextRange()");
        if (status == UtilityClass.ViewType.FullTextView || status == UtilityClass.ViewType.TextRangeView) {
            boolean bIsMatchedLine;
            int k;
            int totalLineNo = this.strFileContentArray.length;
            String lenStr = String.valueOf(totalLineNo);
            int[] matchedLine = this.setLines(this.hitLines);
            int range = configclass.getInstance("config.xml").getAbstractDisplayLines();
            if (-1 == range) {
                range = 5;
            }
            Vector<Integer> blockVector = UtilityClass.getTextRange(matchedLine, range, totalLineNo);
            Integer[] fullSegment = blockVector.toArray(new Integer[blockVector.size()]);
            int i = 0;
            int j = 0;
            int seg_cnt = fullSegment[0];
            int[] seg = new int[seg_cnt];
            StringBuffer strBuf = new StringBuffer();
            ArrayList<HighlightWord> arr = new ArrayList<HighlightWord>();
            int iAllLength = 0;
            String strAbstract = Mytranslator.getInstance().getTranslate("AbstractLine") + System.getProperty("line.separator");
            int iLenAbstract = strAbstract.length();
            do {
                if (Thread.currentThread().getName().endsWith(UtilityClass._THREADSTOP)) {
                    return null;
                }
                ++i;
                if (j < seg_cnt) {
                    seg[j] = fullSegment[i];
                    ++j;
                } else {
                    strBuf.append(strAbstract);
                    this.AbstractLine.add(-1);
                    iAllLength += iLenAbstract;
                    for (k = seg[0]; k <= seg[seg.length - 1]; ++k) {
                        bIsMatchedLine = this.isMatchedLine(k, seg);
                        iAllLength = this.Displayline(lenStr.length(), k, iAllLength, strBuf, arr, bIsMatchedLine, true, this.AbstractLine.size());
                        this.AbstractLine.add(k - 1);
                        if (iline != k - 1) continue;
                        this.hotlineIndex = this.AbstractLine.size() - 1;
                    }
                    seg_cnt = fullSegment[i];
                    seg = new int[seg_cnt];
                    j = 0;
                }
                myText.showProgress(i, 100, fullSegment.length);
            } while (i < fullSegment.length - 1);
            strBuf.append(strAbstract);
            iAllLength += iLenAbstract;
            this.AbstractLine.add(-1);
            for (k = seg[0]; k <= seg[seg.length - 1]; ++k) {
                bIsMatchedLine = this.isMatchedLine(k, seg);
                iAllLength = this.Displayline(lenStr.length(), k, iAllLength, strBuf, arr, bIsMatchedLine, true, this.AbstractLine.size());
                this.AbstractLine.add(k - 1);
                if (iline != k - 1) continue;
                this.hotlineIndex = this.AbstractLine.size() - 1;
            }
            strBuf.append(strAbstract);
            iAllLength += iLenAbstract;
            this.AbstractLine.add(-1);
            this.iPaginationMode = this.InitScrollPara(arr, strBuf);
            if (!this.iPaginationMode.booleanValue()) {
                return strBuf;
            }
        }
        return null;
    }

    private boolean isMatchedLine(int k, int[] seg) {
        boolean bret = false;
        for (int i = 1; i < seg.length - 1; ++i) {
            if (seg[i] != k) continue;
            bret = true;
            break;
        }
        return bret;
    }

    private void highlightKeyword(ArrayList<HighlightWord> arr, int istartPos, int linedigitalNumber, String strLineContent, int ilineIndex, boolean showLineNo, int hightlightIndex) {
        try {
            String[] strKeyArr = this.m_queryRegString.split("\\|");
            if (UtilityClass.nearSearchKey.equals(strKeyArr[0])) {
                String strRegSearchkey = strKeyArr[1] + ".*?" + strKeyArr[2];
                this.RegularSearch(strRegSearchkey, arr, istartPos, linedigitalNumber, strLineContent, ilineIndex, showLineNo, hightlightIndex, true);
            } else if (this.m_queryRegString.indexOf(42) >= 0) {
                String strRegSearchkey = this.m_queryRegString.replace("*", ".*?");
                this.RegularSearch(strRegSearchkey, arr, istartPos, linedigitalNumber, strLineContent, ilineIndex, showLineNo, hightlightIndex, false);
            } else {
                this.TokenSearch(this.strSet, arr, istartPos, linedigitalNumber, strLineContent, ilineIndex, showLineNo, hightlightIndex);
            }
        }
        catch (PatternSyntaxException e) {
            UtilityClass.OutputLogFile(e.getMessage());
            throw e;
        }
        catch (Exception ee) {
            UtilityClass.OutputLogFile(ee.getMessage());
        }
    }

    private void RegularSearch(String strRegSearchkey, ArrayList<HighlightWord> arr, int istartPos, int linedigitalNumber, String strLineContent, int iLineIndex, boolean showLineNo, int hightlightIndex, boolean isSpanSearch) {
        Pattern p = Pattern.compile(strRegSearchkey, 66);
        Matcher match = p.matcher(strLineContent);
        if (isSpanSearch) {
            this.chooseColorBrush(0);
        }
        while (match.find()) {
            int i = 0;
            if (!isSpanSearch) {
                for (String strKey : this.strSet) {
                    if (strKey.equalsIgnoreCase(match.group())) {
                        this.chooseColorBrush(i);
                        break;
                    }
                    ++i;
                }
            }
            HighlightWord styleHighlight = new HighlightWord();
            if (showLineNo) {
                styleHighlight.start = istartPos + linedigitalNumber + 3 + match.start();
                styleHighlight.offsetLine = linedigitalNumber + 3 + match.start();
                styleHighlight.lineIndex = hightlightIndex;
            } else {
                styleHighlight.start = istartPos + match.start();
                styleHighlight.offsetLine = match.start();
                styleHighlight.lineIndex = hightlightIndex;
            }
            styleHighlight.length = match.end() - match.start();
            styleHighlight.background = this._highLightColor;
            arr.add(styleHighlight);
        }
    }

    private void TokenSearch(Set<String> strSet, ArrayList<HighlightWord> arr, int istartPos, int linedigitalNumber, String strLineContent, int iLineIndex, boolean showLineNo, int hightlightIndex) throws Exception {
        StringReader sr = new StringReader(strLineContent);
        TokenStream tokens = this.analyzer.tokenStream("field", sr);
        OffsetAttribute offsetAttribute = (OffsetAttribute)tokens.addAttribute(OffsetAttribute.class);
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokens.addAttribute(CharTermAttribute.class);
        tokens.reset();
        ArrayList<HighlightWord> arrList = new ArrayList<HighlightWord>();
        ArrayList<KeyElmentInfo> keyElementList = new ArrayList<KeyElmentInfo>();
        int iTokenIndex = 0;
        while (tokens.incrementToken()) {
            int startOffset = offsetAttribute.startOffset();
            int endOffset = offsetAttribute.endOffset();
            String term = charTermAttribute.toString();
            int i = 0;
            for (String strKey : strSet) {
                System.out.println(strKey);
                ++i;
                if (!term.equals(strKey)) continue;
                this.chooseColorBrush(i);
                HighlightWord styleHighlight = new HighlightWord();
                if (showLineNo) {
                    styleHighlight.start = istartPos + startOffset + linedigitalNumber + 3;
                    styleHighlight.offsetLine = startOffset + linedigitalNumber + 3;
                    styleHighlight.lineIndex = hightlightIndex;
                } else {
                    styleHighlight.start = istartPos + startOffset;
                    styleHighlight.offsetLine = startOffset;
                    styleHighlight.lineIndex = hightlightIndex;
                }
                styleHighlight.length = endOffset - startOffset;
                styleHighlight.background = this._highLightColor;
                arrList.add(styleHighlight);
                KeyElmentInfo temp = new KeyElmentInfo();
                temp.keyword = strKey;
                temp.tokenIndex = iTokenIndex;
                keyElementList.add(temp);
                break;
            }
            ++iTokenIndex;
        }
        tokens.close();
        sr.close();
        String[] strKeyArr = this.m_queryRegString.split("\\|");
        this.MergeSelection(arrList, strKeyArr, keyElementList);
        arr.addAll(arrList);
    }

    private void MergeSelection(ArrayList<HighlightWord> arrList, String[] strKeyArr, ArrayList<KeyElmentInfo> keyElementList) {
        int iEnd;
        int iCnt = arrList.size();
        int iStart = iEnd = iCnt - 1;
        while (iStart >= 0) {
            String strRange = "";
            for (int i = iStart; i <= iEnd; ++i) {
                strRange = strRange.isEmpty() ? keyElementList.get((int)i).keyword : strRange + " " + keyElementList.get((int)i).keyword;
            }
            int matched = this.Match(strRange, strKeyArr);
            if (matched == 0) {
                this.MergeRange(arrList, iStart, iEnd, strRange);
                iEnd = --iStart;
                continue;
            }
            if (matched == -1) {
                this.DeleteRange(arrList, iStart, iEnd);
                iEnd = --iStart;
                continue;
            }
            if (--iStart >= 0) {
                if (keyElementList.get((int)iStart).tokenIndex + 1 == keyElementList.get((int)(iStart + 1)).tokenIndex) continue;
                this.DeleteRange(arrList, iStart + 1, iEnd);
                iEnd = iStart;
                continue;
            }
            this.DeleteRange(arrList, iStart + 1, iEnd);
        }
    }

    private int Match(String keyElement, String[] strKeyArr) {
        int bRet = -1;
        for (String strKey : strKeyArr) {
            if (!strKey.endsWith(keyElement)) continue;
            bRet = 1;
            if (!strKey.equals(keyElement)) continue;
            bRet = 0;
            break;
        }
        return bRet;
    }

    private void DeleteRange(ArrayList<HighlightWord> arrList, int iStart, int iEnd) {
        for (int i = iEnd; i >= iStart; --i) {
            arrList.remove(i);
        }
    }

    private void MergeRange(ArrayList<HighlightWord> arrList, int iStart, int iEnd, String strRange) {
        HighlightWord startStyle = arrList.get(iStart);
        startStyle.length = arrList.get((int)iEnd).start + arrList.get((int)iEnd).length - startStyle.start;
        for (int i = iEnd; i >= iStart + 1; --i) {
            arrList.remove(i);
        }
    }

    private void chooseColorBrush(int i) {
        int j = i % ColorManager.GetTextHighlightColorNumber();
        this._highLightColor = ColorManager.getTextHighlightColor(j);
    }

    private int Displayline(int lineDigitalNumber, int iLineNo, int istartPos, StringBuffer strTextBuffer, ArrayList<HighlightWord> arr, boolean isMatchedLine, boolean showLineNo, int highlightlineIndex) {
        if (showLineNo) {
            String strLineNo = String.format("%" + lineDigitalNumber + "s:  ", iLineNo);
            strTextBuffer.append(strLineNo);
            HighlightWord style = new HighlightWord();
            style.start = istartPos;
            style.offsetLine = 0;
            style.lineIndex = highlightlineIndex;
            style.length = lineDigitalNumber + 3;
            style.foreground = this._LineMarkerColor;
            arr.add(style);
        }
        String strLineContent = this.strFileContentArray[iLineNo - 1];
        if (isMatchedLine) {
            this.highlightKeyword(arr, istartPos, lineDigitalNumber, strLineContent, iLineNo - 1, showLineNo, highlightlineIndex);
        }
        int nTotallLength = showLineNo ? istartPos + strLineContent.length() + lineDigitalNumber + 3 + System.getProperty("line.separator").length() : istartPos + strLineContent.length() + System.getProperty("line.separator").length();
        strTextBuffer.append(strLineContent);
        strTextBuffer.append(System.getProperty("line.separator"));
        return nTotallLength;
    }
}

