/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import ui.CompositeSearchText;
import ui.InterfaceSearchTextChange;
import ui.MainUI;
import ui.SearchThread;
import ui.UtilityClass;

public class SearchText
extends Text
implements InterfaceSearchTextChange {
    final int itemMax = 20;
    final int MaxHistoryNum = 200;
    private Table table;
    private LinkedHashSet<String> strHistoryWords = new LinkedHashSet();
    private boolean noShowHistoryList = false;
    private String strKeyFile = ".Keys";
    private boolean arrow_updown = false;
    final int REMOVECOLUMNWIDTH = 60;
    final int PULLDOWNHEIGHT = 420;
    CompositeSearchText compositeContainer;
    Shell popupShell = null;

    @Override
    public void checkSubclass() {
    }

    public void SetTextHidePulldow(String str) {
        this.noShowHistoryList = true;
        this.setText(str);
        this.noShowHistoryList = false;
    }

    @Override
    public void UpdateSynnonym(String searchkey, String synnonym) {
        String str = this.getText();
        str = str.replaceAll(searchkey, synnonym);
        this.SetTextHidePulldow(str);
        MainUI.Search();
    }

    public void noShowHistoryList(boolean bShow) {
        this.noShowHistoryList = bShow;
    }

    private void ReadKeysFromFile() {
        try {
            File file = new File(this.strKeyFile);
            if (!file.exists()) {
                return;
            }
            String keys = FileUtils.readFileToString((File)file);
            if (!keys.isEmpty()) {
                String[] strKey;
                for (String str : strKey = keys.split(";")) {
                    this.AddHistoryWords(str);
                }
            }
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    private void WriteKeysFile() {
        try {
            File file = new File(this.strKeyFile);
            String Keywords = "";
            for (String str : this.strHistoryWords) {
                if (str.isEmpty()) continue;
                if (Keywords.isEmpty()) {
                    Keywords = str;
                    continue;
                }
                Keywords = Keywords + ";" + str;
            }
            if (!Keywords.isEmpty()) {
                FileUtils.writeStringToFile((File)file, (String)Keywords);
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public SearchText(CompositeSearchText container, Composite parent, int style) {
        super(parent, style);
        this.compositeContainer = container;
    }

    public void AddHistoryWords(String str) {
        if (this.strHistoryWords.size() > 200) {
            this.strHistoryWords.remove(this.strHistoryWords.iterator().next());
        }
        this.strHistoryWords.add(str);
    }

    public void RemoveHistoryWords(String str) {
        this.strHistoryWords.remove(str);
    }

    public void RemoveAllHistory() {
        this.strHistoryWords.removeAll(this.strHistoryWords);
    }

    private int clearHistoryTable() {
        int icount = this.table.getItemCount();
        for (int i = 0; i < icount; ++i) {
            TableItem ti = this.table.getItem(i);
            TableEditor b = (TableEditor)ti.getData("remove");
            b.getEditor().dispose();
            b = null;
            b = (TableEditor)ti.getData("remove2");
            if (b == null) continue;
            b.getEditor().dispose();
        }
        this.table.removeAll();
        return icount;
    }

    private void OnKeyChanged(Shell popupShell, Shell parentShell, Display display) {
        Display d;
        Link lnkRemove;
        int i;
        ArrayList<String> reverseList;
        if (this.noShowHistoryList) {
            return;
        }
        String strSearchText = this.getText();
        if (strSearchText.length() == 0) {
            if (UtilityClass.DebugMode) {
                System.out.println("text changed: empty");
            }
            this.clearHistoryTable();
            reverseList = new ArrayList<String>();
            reverseList.addAll(this.strHistoryWords);
            Collections.reverse(reverseList);
            i = 0;
            for (String element : reverseList) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, element);
                if (++i < 20) continue;
                break;
            }
            if (this.table.getItemCount() > 0) {
                TableItem[] items = this.table.getItems();
                for (int ii = 0; ii < i; ++ii) {
                    TableEditor editor = new TableEditor(this.table);
                    lnkRemove = new Link(this.table, 0);
                    lnkRemove.setBackground(display.getSystemColor(1));
                    lnkRemove.setText(Mytranslator.getInstance().getTranslate("remove"));
                    lnkRemove.setData(ii);
                    lnkRemove.pack();
                    d = display;
                    lnkRemove.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            Link link = (Link)e.getSource();
                            int index = (Integer)link.getData();
                            SearchText.this.RemoveHistoryWords(SearchText.this.table.getItem(index).getText());
                            TableItem ti = SearchText.this.table.getItem(index);
                            TableEditor b = (TableEditor)ti.getData("remove");
                            b.getEditor().dispose();
                            SearchText.this.table.getItem(index).setText(Mytranslator.getInstance().getTranslate("ItemDeleted"));
                            SearchText.this.table.getItem(index).setForeground(d.getSystemColor(15));
                        }
                    });
                    editor.minimumWidth = lnkRemove.getSize().x;
                    editor.horizontalAlignment = 0x1000000;
                    editor.setEditor(lnkRemove, items[ii], 1);
                    items[ii].setData("remove", editor);
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("show the dialog2");
                }
            }
        } else {
            if (MainUI.btnSearch != null && !MainUI.btnSearch.isEnabled()) {
                MainUI.btnSearch.setEnabled(true);
            }
            if (UtilityClass.DebugMode) {
                System.out.println("text changed: not empty");
            }
            this.clearHistoryTable();
            reverseList = new ArrayList();
            reverseList.addAll(this.strHistoryWords);
            Collections.reverse(reverseList);
            i = 0;
            for (String element : reverseList) {
                if (!element.startsWith(strSearchText)) continue;
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, element);
                if (++i < 20) continue;
                break;
            }
            if (this.table.getItemCount() > 0) {
                TableItem[] items = this.table.getItems();
                for (int ii = 0; ii < i; ++ii) {
                    TableEditor editor = new TableEditor(this.table);
                    lnkRemove = new Link(this.table, 0);
                    lnkRemove.setBackground(display.getSystemColor(1));
                    lnkRemove.setText(Mytranslator.getInstance().getTranslate("remove"));
                    lnkRemove.setData(ii);
                    lnkRemove.pack();
                    d = display;
                    lnkRemove.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent e) {
                            Link link = (Link)e.getSource();
                            int index = (Integer)link.getData();
                            SearchText.this.RemoveHistoryWords(SearchText.this.table.getItem(index).getText());
                            TableItem ti = SearchText.this.table.getItem(index);
                            TableEditor b = (TableEditor)ti.getData("remove");
                            b.getEditor().dispose();
                            SearchText.this.table.getItem(index).setText(Mytranslator.getInstance().getTranslate("ItemDeleted"));
                            SearchText.this.table.getItem(index).setForeground(d.getSystemColor(15));
                        }
                    });
                    editor.minimumWidth = lnkRemove.getSize().x;
                    editor.horizontalAlignment = 0x1000000;
                    editor.setEditor(lnkRemove, items[ii], 1);
                    items[ii].setData("remove", editor);
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("show the dialog1");
                }
            }
            MainUI.SetsearchKey(strSearchText);
            int threadCnt = Thread.activeCount();
            Thread[] threadArray = new Thread[threadCnt];
            Thread.enumerate(threadArray);
            for (int j = 0; j < threadCnt; ++j) {
                if (!UtilityClass._threadCreateIndexThreadOrSearch.equals(threadArray[j].getName())) continue;
                if (UtilityClass.DebugMode) {
                    System.out.println("searching thread is running and stop it");
                }
                SearchThread th = (SearchThread)threadArray[j];
                th.cancel();
            }
            MainUI.SearchTextChange(strSearchText);
        }
        TableItem item = new TableItem(this.table, 32768);
        TableEditor editor = new TableEditor(this.table);
        Link lnkGoogleSearch = new Link(this.table, 0);
        lnkGoogleSearch.setBackground(display.getSystemColor(1));
        lnkGoogleSearch.setText(Mytranslator.getInstance().getTranslate("WebSearch"));
        final SearchText thisText = this;
        final Shell pShell = popupShell;
        lnkGoogleSearch.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                pShell.setVisible(false);
                if (UtilityClass.GoogleOnly) {
                    Program.launch(String.format(Mytranslator.getInstance().getTranslate("GoogleSearchURL"), thisText.getText()));
                } else {
                    Program.launch(String.format(Mytranslator.getInstance().getTranslate("WikiSearchURL"), thisText.getText()));
                    Program.launch(String.format(Mytranslator.getInstance().getTranslate("BingSearchURL"), thisText.getText()));
                    Program.launch(String.format(Mytranslator.getInstance().getTranslate("LocalSearchURL"), thisText.getText()));
                    Program.launch(String.format(Mytranslator.getInstance().getTranslate("GoogleSearchURL"), thisText.getText()));
                }
            }
        });
        editor.minimumWidth = UtilityClass.scaleForDpi(100);
        editor.horizontalAlignment = 16384;
        editor.setEditor(lnkGoogleSearch, item, 0);
        item.setData("remove", editor);
        TableEditor editorRemoveAll = new TableEditor(this.table);
        Link lnkRemoveAll = new Link(this.table, 0);
        lnkRemoveAll.setBackground(display.getSystemColor(1));
        lnkRemoveAll.setText(Mytranslator.getInstance().getTranslate("AllDelete"));
        lnkRemoveAll.pack();
        lnkRemoveAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SearchText.this.RemoveAllHistory();
                SearchText.this.clearHistoryTable();
                pShell.setVisible(false);
            }
        });
        editorRemoveAll.minimumWidth = lnkRemoveAll.getSize().x;
        editorRemoveAll.horizontalAlignment = 0x1000000;
        editorRemoveAll.setEditor(lnkRemoveAll, item, 1);
        item.setData("remove2", editorRemoveAll);
        Rectangle controlBounds = this.getBounds();
        Rectangle textBounds = display.map((Control)this, null, controlBounds);
        popupShell.setBounds(textBounds.x, textBounds.y + textBounds.height, textBounds.width, 420);
        this.table.getColumn(0).setWidth(textBounds.width - 60 - 2);
        this.table.getColumn(1).setWidth(60);
        this.table.pack();
        popupShell.pack();
        if (!popupShell.isVisible()) {
            popupShell.setVisible(true);
        }
    }

    public void Search() {
        String strText;
        this.noShowHistoryList(true);
        if (this.popupShell.isVisible()) {
            if (this.table.getSelectionIndex() != -1) {
                this.setText(this.table.getSelection()[0].getText());
                System.out.println("enter key was pressed");
            }
            this.popupShell.setVisible(false);
        }
        if (!(strText = this.getText()).isEmpty()) {
            MainUI.Search();
        }
        this.noShowHistoryList(false);
        this.setSelection(this.getText().length());
    }

    public void init(Display _display, Shell _parentShell) {
        final Display display = _display;
        final Shell parentShell = _parentShell;
        this.popupShell = new Shell(display, 16384);
        this.popupShell.setLayout(new FillLayout());
        this.table = new Table(this.popupShell, 65540);
        for (int i = 0; i < 2; ++i) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
        }
        this.addListener(1, new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        if (SearchText.this.table.getItemCount() == 0) break;
                        int index = (SearchText.this.table.getSelectionIndex() + 1) % SearchText.this.table.getItemCount();
                        SearchText.this.table.setSelection(index);
                        SearchText.this.arrow_updown = true;
                        SearchText.this.setText(SearchText.this.table.getSelection()[0].getText());
                        SearchText.this.setSelection(SearchText.this.getText().length());
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int index = SearchText.this.table.getSelectionIndex() - 1;
                        if (index < 0) {
                            index = SearchText.this.table.getItemCount() - 1;
                        }
                        SearchText.this.table.setSelection(index);
                        SearchText.this.arrow_updown = true;
                        SearchText.this.setText(SearchText.this.table.getSelection()[0].getText());
                        SearchText.this.setSelection(SearchText.this.getText().length());
                        event.doit = false;
                        break;
                    }
                    case 13: 
                    case 0x1000050: {
                        SearchText.this.Search();
                        event.doit = false;
                        break;
                    }
                    case 27: {
                        SearchText.this.popupShell.setVisible(false);
                        break;
                    }
                }
            }
        });
        this.addListener(24, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (SearchText.this.arrow_updown) {
                    SearchText.this.arrow_updown = false;
                } else {
                    SearchText.this.OnKeyChanged(SearchText.this.popupShell, parentShell, display);
                }
                Text control = (Text)event.widget;
                if (control.getText().isEmpty()) {
                    SearchText.this.compositeContainer.GetlblSearch().setEnabled(false);
                    SearchText.this.compositeContainer.GetLabelSearchClear().setVisible(false);
                    if (SearchText.this.popupShell.isVisible()) {
                        SearchText.this.popupShell.setVisible(false);
                    }
                } else {
                    SearchText.this.compositeContainer.GetlblSearch().setEnabled(true);
                    SearchText.this.compositeContainer.GetLabelSearchClear().setVisible(true);
                }
            }
        });
        this.addListener(3, new Listener(){

            @Override
            public void handleEvent(Event event) {
                SearchText.this.OnKeyChanged(SearchText.this.popupShell, parentShell, display);
            }
        });
        this.table.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (SearchText.this.table.getSelection().length > 0) {
                    String strText;
                    String strCurText = SearchText.this.table.getSelection()[0].getText();
                    if (!Mytranslator.getInstance().getTranslate("ItemDeleted").equals(strCurText)) {
                        SearchText.this.setText(strCurText);
                    }
                    if (!(strText = SearchText.this.getText()).isEmpty()) {
                        MainUI.Search();
                    }
                    SearchText.this.popupShell.setVisible(false);
                }
            }
        });
        final SearchText text = this;
        Listener focusOutListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        Control control = display.getFocusControl();
                        if (control == null || control != text && control != SearchText.this.table && control.getParent() != SearchText.this.table) {
                            SearchText.this.popupShell.setVisible(false);
                        }
                    }
                });
            }
        };
        this.table.addListener(16, focusOutListener);
        this.addListener(16, focusOutListener);
        parentShell.addListener(10, new Listener(){

            @Override
            public void handleEvent(Event event) {
                SearchText.this.popupShell.setVisible(false);
            }
        });
        parentShell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                SearchText.this.popupShell.setVisible(false);
            }
        });
        parentShell.addListener(19, new Listener(){

            @Override
            public void handleEvent(Event event) {
                SearchText.this.popupShell.setVisible(false);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent notUsed) {
                SearchText.this.WriteKeysFile();
            }
        });
        this.ReadKeysFromFile();
    }
}

