/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.FilterDlgData;
import biz.HardDiskMap;
import biz.SearchBiz;
import biz.configclass;
import biz.searchFolder;
import java.io.File;
import org.apache.commons.io.FileUtils;
import ui.InterfaceAsynSearchDisplayEvent;
import ui.UtilityClass;

public class SearchThread
extends Thread {
    private String searchKey;
    private int searchOption;
    private searchFolder _sf;
    private String searchOrder = "filedate";
    private boolean Ascending = false;
    private boolean _bSearchContent = true;
    private InterfaceAsynSearchDisplayEvent inter;
    private FilterDlgData filterDlgData = null;
    private String filename;
    private String fileTime;
    private SearchBiz _searchBiz = null;

    public void cancel() {
        if (this._searchBiz != null) {
            this._searchBiz.cancel();
        }
    }

    public void init(InterfaceAsynSearchDisplayEvent interEvent, searchFolder sf, String searchK, int searchOpt, boolean bSearchContent, String threadname, String strFilename, String strFileTime) {
        this._sf = sf;
        this.searchKey = searchK;
        this.searchOption = searchOpt;
        this.inter = interEvent;
        this.setName(threadname);
        this.searchOrder = "filedate";
        this.Ascending = false;
        if (this.searchOption >= UtilityClass.SearchOptionMax && UtilityClass.DebugMode) {
            System.out.println("searchthread does not support searchoption > Max, please use nonrealtimeindexupdate");
        }
        this._bSearchContent = bSearchContent;
        this.filename = strFilename;
        this.fileTime = strFileTime;
    }

    public void SetSort(String field, boolean ascending) {
        this.searchOrder = field;
        this.Ascending = ascending;
    }

    public void SetFilter(FilterDlgData fd) {
        this.filterDlgData = fd;
    }

    private boolean ActiveSearchIndex(File iFolder) {
        boolean bRet = false;
        String foldername = iFolder.getName();
        for (int i = 0; i < this._sf.getIndexNumber(); ++i) {
            if (!foldername.equals(this._sf.getIndexName(i)) || this._sf.getDirty(i) != 1 || !this._sf.isEnable(i)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private void DeleteIndexFolders() throws Exception {
        long lCreatedDate;
        String folder = configclass.getInstance("config.xml").getIndexDir();
        String srcfolder = UtilityClass.getFullname(folder, String.valueOf(lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong()));
        File file = new File(srcfolder);
        if (file.isDirectory() && file.exists()) {
            for (File iFile : file.listFiles()) {
                if (!iFile.isDirectory() || !iFile.exists() || !this.ActiveSearchIndex(iFile)) continue;
                FileUtils.deleteQuietly((File)iFile);
                UtilityClass.OutputLogFile("delete directory" + iFile.getCanonicalPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean bthreadRet = true;
        try {
            switch (this.searchOption) {
                case 0: {
                    SearchBiz searchBiz;
                    long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                    this._searchBiz = searchBiz = new SearchBiz();
                    if (!searchBiz.Init(this.searchOption, this._sf, this._sf.getCurrentIndexName())) {
                        return;
                    }
                    UtilityClass.OutputLogFile("inside thread - searchBiz::Init() : current time:" + System.currentTimeMillis());
                    bthreadRet = searchBiz.searchDirIndex(this.searchKey, this.searchOrder, this.Ascending, this.filterDlgData, this._bSearchContent, this.filename, this.fileTime);
                    return;
                }
                case 1: {
                    String indexname;
                    this.DeleteIndexFolders();
                    int bRet = 99;
                    HardDiskMap.saveIndexHDVolume();
                    for (int i = 0; i < this._sf.getIndexNumber(); ++i) {
                        SearchBiz searchBiz;
                        if (!this._sf.isEnable(i) || this._sf.getDirty(i) != 1) continue;
                        indexname = this._sf.getIndexName(i);
                        UtilityClass.OutputLogFile("Search Option : " + this.searchOption + " SearchThread start indexing data:" + indexname);
                        long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                        UtilityClass.CreateBaseFolder(configclass.getInstance("config.xml").getIndexDir(), lCreatedDate, indexname, true);
                        this._searchBiz = searchBiz = new SearchBiz();
                        if (!searchBiz.Init(this.searchOption, this._sf, indexname)) {
                            return;
                        }
                        String include = this._sf.getIncludeFolder(i);
                        String exclude = this._sf.getExcludeFolder(i);
                        bRet = searchBiz.createDirIndex(include, exclude, i);
                        searchBiz.finializeCreateIndex();
                        if (bRet != 0) break;
                        UtilityClass.OutputLogFile("Search Option : " + this.searchOption + "SearchThread completed indexing data:" + indexname);
                    }
                    if (bRet != 0 && bRet != 1) return;
                    this.inter.OnCreateDirIndexFinished(bRet, this.searchOption);
                    return;
                }
                case 2: {
                    String exclude;
                    SearchBiz searchBiz;
                    int bRet = 99;
                    long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                    UtilityClass.CreateBaseFolder(configclass.getInstance("config.xml").getIndexDir(), lCreatedDate, this._sf.getCurrentIndexName(), true);
                    HardDiskMap.saveIndexHDVolume();
                    this._searchBiz = searchBiz = new SearchBiz();
                    if (!searchBiz.Init(this.searchOption, this._sf, this._sf.getCurrentIndexName())) {
                        return;
                    }
                    String include = this._sf.getIncludeFolder(this._sf.getCurrentIndex());
                    bRet = searchBiz.createDirIndex(include, exclude = this._sf.getExcludeFolder(this._sf.getCurrentIndex()), this._sf.getCurrentIndex());
                    if (bRet == 0 || bRet == 1) {
                        this.inter.OnCreateDirIndexFinished(bRet, this.searchOption);
                        this.inter.setStop(false);
                        searchBiz.searchDirIndex(this.searchKey, this.searchOrder, this.Ascending, this.filterDlgData, this._bSearchContent, "", "");
                    }
                    searchBiz.finializeCreateIndex();
                    return;
                }
                case 3: {
                    int startResumeIndex;
                    int bRet = 99;
                    long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                    boolean bResumeStart = false;
                    boolean bFoundStop = false;
                    if (lCreatedDate == -1L) return;
                    for (int i = startResumeIndex = configclass.getInstance("config.xml").getErrFileIndex(); i < this._sf.getIndexNumber(); ++i) {
                        if (this._sf.isEnable(i) && this._sf.getDirty(i) == 1) {
                            SearchBiz searchBiz;
                            String indexname = this._sf.getIndexName(i);
                            UtilityClass.OutputLogFile("Search Option : " + this.searchOption + "SearchThread start indexing data:" + indexname);
                            lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                            UtilityClass.CreateBaseFolder(configclass.getInstance("config.xml").getIndexDir(), lCreatedDate, indexname, false);
                            HardDiskMap.saveIndexHDVolume();
                            this._searchBiz = searchBiz = new SearchBiz();
                            if (!searchBiz.Init(this.searchOption, this._sf, indexname)) {
                                return;
                            }
                            String include = this._sf.getIncludeFolder(i);
                            String exclude = this._sf.getExcludeFolder(i);
                            searchBiz.setResumeStart(bResumeStart);
                            searchBiz.setResumeFileFound(bFoundStop);
                            bRet = searchBiz.createDirIndex(include, exclude, i);
                            bResumeStart = searchBiz.getResumeStart();
                            bFoundStop = searchBiz.getResumeFileFound();
                            searchBiz.finializeCreateIndex();
                            this._sf.setChanged(i, 0);
                            if (bRet != 0) {
                                return;
                            }
                            UtilityClass.OutputLogFile("Search Option : " + this.searchOption + "SearchThread completed indexing data:" + indexname);
                        }
                        if (bRet != 0 && bRet != 1) continue;
                        this.inter.OnCreateDirIndexFinished(bRet, this.searchOption);
                    }
                    return;
                }
                case 5: {
                    String indexname;
                    int bRet = 99;
                    HardDiskMap.saveIndexHDVolume();
                    for (int i = 0; i < this._sf.getIndexNumber(); ++i) {
                        SearchBiz searchBiz;
                        if (this._sf.isChanged(i) != 1) continue;
                        indexname = this._sf.getIndexName(i);
                        UtilityClass.OutputLogFile("Search Option : " + this.searchOption + " SearchThread start indexing data:" + indexname);
                        long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                        UtilityClass.CreateBaseFolder(configclass.getInstance("config.xml").getIndexDir(), lCreatedDate, indexname, true);
                        this._searchBiz = searchBiz = new SearchBiz();
                        if (!searchBiz.Init(this.searchOption, this._sf, indexname)) {
                            return;
                        }
                        String include = this._sf.getIncludeFolder(i);
                        String exclude = this._sf.getExcludeFolder(i);
                        bRet = searchBiz.createDirIndex(include, exclude, i);
                        searchBiz.finializeCreateIndex();
                        this._sf.setChanged(i, 0);
                        if (bRet != 0) break;
                        UtilityClass.OutputLogFile("Search Option : " + this.searchOption + "SearchThread completed indexing data:" + indexname);
                    }
                    if (bRet != 0 && bRet != 1) return;
                    this.inter.OnCreateDirIndexFinished(bRet, this.searchOption);
                    return;
                }
                default: {
                    if (UtilityClass.DebugMode) {
                        System.out.println("invalid search option, should call NonRealtimeindexUpdateThread" + this.searchOption);
                    }
                    UtilityClass.OutputLogFile("SearchThread: invalid search option, should call NonRealtimeindexUpdateThread");
                    return;
                }
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
            return;
        }
        catch (OutOfMemoryError ee) {
            System.out.println("out of memory:" + ee.getMessage());
            return;
        }
        finally {
            if (this.inter != null && bthreadRet) {
                this.inter.UponThreadEnd();
            }
            long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
            long loldDate = configclass.getInstance("config.xml").getIndexDataFolderlong();
            if (loldDate != lCreatedDate) {
                configclass.getInstance("config.xml").SetIndexDataFolderlong(lCreatedDate);
                configclass.getInstance("config.xml").Save();
            }
        }
    }
}

