/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import ui.UtilityClass;

public class gif
extends Canvas {
    private static final int GAP = 5;
    private static final int DEFAULT_MARGIN = 3;
    private int align = 16384;
    private int leftMargin = 3;
    private int topMargin = 3;
    private int rightMargin = 3;
    private int bottomMargin = 3;
    private Image image;
    private String appToolTipText;
    private boolean ignoreDispose;
    private GifThread thread = null;

    public gif(Composite parent, int style) {
        super(parent, gif.checkStyle(style));
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                gif.this.onPaint(event);
            }
        });
        this.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                gif.this.onDispose(event);
            }
        });
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        return style |= 0x20080000;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image);
        e.x = wHint == -1 ? (e.x += this.leftMargin + this.rightMargin) : wHint;
        e.y = hHint == -1 ? (e.y += this.topMargin + this.bottomMargin) : hHint;
        return e;
    }

    public int getAlignment() {
        return this.align;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public Image getImage() {
        return this.image;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    private Point getTotalSize(Image image) {
        Point size = new Point(0, 0);
        if (image != null && !image.isDisposed()) {
            Rectangle r = image.getBounds();
            size.x += r.width;
            size.y += r.height;
        }
        return size;
    }

    @Override
    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    @Override
    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void ResourceRelease() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
    }

    void onDispose(Event event) {
        if (this.ignoreDispose) {
            this.ignoreDispose = false;
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        this.image = null;
        this.appToolTipText = null;
    }

    void onPaint(PaintEvent event) {
        Image img = this.image;
        GC gc = event.gc;
        Rectangle imageRect = null;
        if (img != null && !img.isDisposed()) {
            imageRect = img.getBounds();
        }
        if (img != null && !img.isDisposed()) {
            gc.drawImage(img, 0, 0, imageRect.width, imageRect.height, 0, 0, imageRect.width, imageRect.height);
        }
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    public void setBottomMargin(int bottomMargin) {
        this.checkWidget();
        if (this.bottomMargin == bottomMargin || bottomMargin < 0) {
            return;
        }
        this.bottomMargin = bottomMargin;
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (this.thread != null) {
            if (this.thread.GetStatus()) {
                this.thread.stopRunning();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setGifImage(String path) {
        try {
            FileInputStream in = new FileInputStream(new File(path));
            this.setGifImage(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            this.image = null;
            return;
        }
    }

    public void setGifImage(InputStream inputStream) {
        this.checkWidget();
        if (this.thread != null) {
            this.thread.stopRunning();
        }
        ImageLoader loader = new ImageLoader();
        try {
            loader.load(inputStream);
        }
        catch (Exception e) {
            this.image = null;
            return;
        }
        if (loader.data[0] != null) {
            this.image = new Image((Device)this.getDisplay(), loader.data[0]);
        }
        if (loader.data.length > 1) {
            this.thread = new GifThread(loader);
            this.thread.start();
        }
        this.redraw();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.stopRunning();
        }
    }

    public void stopThread() {
        if (this.thread != null) {
            this.thread.stopRunning();
        }
    }

    public void setLeftMargin(int leftMargin) {
        this.checkWidget();
        if (this.leftMargin == leftMargin || leftMargin < 0) {
            return;
        }
        this.leftMargin = leftMargin;
        this.redraw();
    }

    public void setMargins(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.checkWidget();
        this.leftMargin = Math.max(0, leftMargin);
        this.topMargin = Math.max(0, topMargin);
        this.rightMargin = Math.max(0, rightMargin);
        this.bottomMargin = Math.max(0, bottomMargin);
        this.redraw();
    }

    public void setRightMargin(int rightMargin) {
        this.checkWidget();
        if (this.rightMargin == rightMargin || rightMargin < 0) {
            return;
        }
        this.rightMargin = rightMargin;
        this.redraw();
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setTopMargin(int topMargin) {
        this.checkWidget();
        if (this.topMargin == topMargin || topMargin < 0) {
            return;
        }
        this.topMargin = topMargin;
        this.redraw();
    }

    private class GifThread
    extends Thread {
        private int imageNumber = 0;
        private ImageLoader loader = null;
        private boolean run = true;

        public boolean GetStatus() {
            return this.run;
        }

        public GifThread(ImageLoader loader) {
            this.loader = loader;
        }

        @Override
        public void run() {
            this.setName(UtilityClass._threadGifAni);
            while (this.run) {
                int delayTime = this.loader.data[this.imageNumber].delayTime;
                try {
                    Thread.sleep(delayTime * 10);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!gif.this.isDisposed()) {
                    gif.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!GifThread.this.run) {
                                if (GifThread.this.imageNumber != 1) {
                                    if (gif.this.image != null && !gif.this.image.isDisposed()) {
                                        gif.this.image.dispose();
                                    }
                                    ImageData nextFrameData = ((GifThread)GifThread.this).loader.data[1];
                                    gif.this.image = new Image((Device)gif.this.getDisplay(), nextFrameData);
                                    gif.this.redraw();
                                }
                                return;
                            }
                            if (!gif.this.isDisposed()) {
                                GifThread.this.imageNumber = GifThread.this.imageNumber == ((GifThread)GifThread.this).loader.data.length - 1 ? 0 : GifThread.this.imageNumber + 1;
                                if (!gif.this.image.isDisposed()) {
                                    gif.this.image.dispose();
                                }
                                ImageData nextFrameData = ((GifThread)GifThread.this).loader.data[GifThread.this.imageNumber];
                                gif.this.image = new Image((Device)gif.this.getDisplay(), nextFrameData);
                                gif.this.redraw();
                            } else {
                                GifThread.this.stopRunning();
                            }
                        }
                    });
                    continue;
                }
                this.stopRunning();
            }
        }

        public void stopRunning() {
            if (UtilityClass.DebugMode) {
                System.out.println("stop running: status changed");
            }
            this.run = false;
        }
    }
}

