/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query yields document which is not matched by parents filter, docID=";
    static final String ILLEGAL_ADVANCE_ON_PARENT = "Expect to be advanced on child docs only. got docID=";
    private final BitDocIdSetFilter parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;
    private final boolean doScores;

    public ToChildBlockJoinQuery(Query parentQuery, BitDocIdSetFilter parentsFilter, boolean doScores) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, BitDocIdSetFilter parentsFilter, boolean doScores) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher), this.parentsFilter, this.doScores);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            ToChildBlockJoinQuery rewritten = new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter, this.doScores);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && ((Object)((Object)this.parentsFilter)).equals((Object)other.parentsFilter) && this.doScores == other.doScores && super.equals((Object)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + new Boolean(this.doScores).hashCode();
        hash = 31 * hash + ((Object)((Object)this.parentsFilter)).hashCode();
        return hash;
    }

    public ToChildBlockJoinQuery clone() {
        return new ToChildBlockJoinQuery(this.origParentQuery.clone(), this.parentsFilter, this.doScores);
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final BitSet parentBits;
        private final boolean doScores;
        private final Bits acceptDocs;
        private float parentScore;
        private int parentFreq = 1;
        private int childDoc = -1;
        private int parentDoc;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, BitSet parentBits, boolean doScores, Bits acceptDocs) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.acceptDocs = acceptDocs;
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        /*
         * Unable to fully structure code
         */
        public int nextDoc() throws IOException {
            do lbl-1000:
            // 3 sources

            {
                block6: {
                    if (this.childDoc + 1 != this.parentDoc) break block6;
                    while (true) {
                        this.parentDoc = this.parentScorer.nextDoc();
                        this.validateParentDoc();
                        if (this.parentDoc == 0) {
                            this.parentDoc = this.parentScorer.nextDoc();
                            this.validateParentDoc();
                        }
                        if (this.parentDoc == 0x7FFFFFFF) {
                            this.childDoc = 0x7FFFFFFF;
                            return this.childDoc;
                        }
                        this.childDoc = 1 + this.parentBits.prevSetBit(this.parentDoc - 1);
                        if (this.childDoc == this.parentDoc) continue;
                        if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) ** GOTO lbl-1000
                        if (this.childDoc < this.parentDoc) break;
                    }
                    if (this.doScores) {
                        this.parentScore = this.parentScorer.score();
                        this.parentFreq = this.parentScorer.freq();
                    }
                    return this.childDoc;
                }
                if (!ToChildBlockJoinScorer.$assertionsDisabled && this.childDoc >= this.parentDoc) {
                    throw new AssertionError((Object)("childDoc=" + this.childDoc + " parentDoc=" + this.parentDoc));
                }
                ++this.childDoc;
            } while (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc));
            return this.childDoc;
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        public int docID() {
            return this.childDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int freq() throws IOException {
            return this.parentFreq;
        }

        public int advance(int childTarget) throws IOException {
            if (childTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                this.childDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.parentBits.get(childTarget)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.ILLEGAL_ADVANCE_ON_PARENT + childTarget);
            }
            assert (this.childDoc == -1 || childTarget != this.parentDoc) : "childTarget=" + childTarget;
            if (this.childDoc == -1 || childTarget > this.parentDoc) {
                this.parentDoc = this.parentScorer.advance(childTarget);
                this.validateParentDoc();
                assert (this.parentDoc > childTarget);
                if (this.parentDoc == Integer.MAX_VALUE) {
                    this.childDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                    this.parentFreq = this.parentScorer.freq();
                }
                int firstChild = this.parentBits.prevSetBit(this.parentDoc - 1);
                childTarget = Math.max(childTarget, firstChild);
            }
            assert (childTarget < this.parentDoc);
            this.childDoc = childTarget;
            if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) {
                this.nextDoc();
            }
            return this.childDoc;
        }

        public long cost() {
            return this.parentScorer.cost();
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight parentWeight;
        private final BitDocIdSetFilter parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, BitDocIdSetFilter parentsFilter, boolean doScores) {
            this.joinQuery = joinQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        public Query getQuery() {
            return this.joinQuery;
        }

        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.parentWeight.normalize(norm, topLevelBoost * this.joinQuery.getBoost());
        }

        public Scorer scorer(LeafReaderContext readerContext, Bits acceptDocs) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(readerContext, null);
            if (parentScorer == null) {
                return null;
            }
            BitDocIdSet parents = this.parentsFilter.getDocIdSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new ToChildBlockJoinScorer(this, parentScorer, parents.bits(), this.doScores, acceptDocs);
        }

        public Explanation explain(LeafReaderContext reader, int doc) throws IOException {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot explain match on parent document");
        }
    }
}

