/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.D;
import biz.g;
import biz.j;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ui.et;

public class ExcelPreview {
    private Workbook wb;
    private Appendable output;
    private boolean completeHTML;
    private Formatter out;
    private boolean gotBounds;
    private int firstColumn;
    private int endColumn;
    private j helper;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private int iCur = 1;
    private int sheetCnt = 0;
    private static final Map HALIGN = ExcelPreview.mapFor(HorizontalAlignment.LEFT, "left", HorizontalAlignment.CENTER, "center", HorizontalAlignment.RIGHT, "right", HorizontalAlignment.FILL, "left", HorizontalAlignment.JUSTIFY, "left", HorizontalAlignment.CENTER_SELECTION, "center");
    private static final Map VALIGN = ExcelPreview.mapFor(VerticalAlignment.BOTTOM, "bottom", VerticalAlignment.CENTER, "middle", VerticalAlignment.TOP, "top");
    private static final Map BORDER = ExcelPreview.mapFor(BorderStyle.DASH_DOT, "dashed 1pt", BorderStyle.DASH_DOT_DOT, "dashed 1pt", BorderStyle.DASHED, "dashed 1pt", BorderStyle.DOTTED, "dotted 1pt", BorderStyle.DOUBLE, "double 3pt", BorderStyle.HAIR, "solid 1px", BorderStyle.MEDIUM, "solid 2pt", BorderStyle.MEDIUM_DASH_DOT, "dashed 2pt", BorderStyle.MEDIUM_DASHED, "dashed 2pt", BorderStyle.NONE, "none", BorderStyle.SLANTED_DASH_DOT, "dashed 2pt", BorderStyle.THICK, "solid 3pt", BorderStyle.THIN, "dashed 1pt");

    public boolean hasNext() {
        return this.iCur < this.sheetCnt;
    }

    public boolean hasPrevious() {
        return this.iCur > 1;
    }

    public int getSheetNumber() {
        return this.sheetCnt;
    }

    public int getCurSheetNo() {
        return this.iCur;
    }

    public String previewFile(String string) {
        String string2 = et.c(string);
        this.iCur = 1;
        String string3 = string2 + this.iCur + ".html";
        this.create(string, string3);
        this.sheetCnt = this.wb.getNumberOfSheets();
        this.setCompleteHTML(true);
        this.printPage();
        this.wb.close();
        return string3;
    }

    public String Next(String string) {
        ++this.iCur;
        if (this.iCur <= this.sheetCnt) {
            String string2 = et.c(string);
            String string3 = string2 + this.iCur + ".html";
            this.create(string, string3);
            this.setCompleteHTML(true);
            this.printPage();
            this.wb.close();
            return string3;
        }
        return "";
    }

    public String Previous(String string) {
        --this.iCur;
        if (this.iCur >= 1) {
            String string2 = et.c(string);
            String string3 = string2 + this.iCur + ".html";
            this.create(string, string3);
            this.setCompleteHTML(true);
            this.printPage();
            this.wb.close();
            return string3;
        }
        return "";
    }

    private static Map mapFor(Object ... objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            hashMap.put(objectArray[i2], objectArray[i2 + 1]);
        }
        return hashMap;
    }

    public void create(String string, String string2) {
        try {
            Workbook workbook;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string2), Charset.forName("UTF-8").newEncoder());
            FileInputStream fileInputStream = new FileInputStream(string);
            this.wb = workbook = WorkbookFactory.create((InputStream)fileInputStream);
            this.output = outputStreamWriter;
            this.setupColorMap();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot create workbook from stream", exception);
        }
    }

    private void setupColorMap() {
        if (this.wb instanceof HSSFWorkbook) {
            this.helper = new g((HSSFWorkbook)this.wb);
        } else if (this.wb instanceof XSSFWorkbook) {
            this.helper = new D();
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + this.wb.getClass().getSimpleName());
        }
    }

    public void setCompleteHTML(boolean bl2) {
        this.completeHTML = bl2;
    }

    public void printPage() {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.out);
            if (this.output instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.output)));
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        this.out = new Formatter(this.output);
    }

    public void printStyles() {
        Object object;
        this.ensureOut();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));
            while ((object = bufferedReader.readLine()) != null) {
                this.out.format("%s%n", object);
            }
        }
        catch (IOException iOException) {
            try {
                throw new IllegalStateException("Reading standard css", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)bufferedReader);
        object = new HashSet();
        for (int i2 = 0; i2 < this.wb.getNumberOfSheets(); ++i2) {
            Sheet sheet = this.wb.getSheetAt(i2);
            Iterator iterator = sheet.rowIterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                for (Cell cell : row) {
                    CellStyle cellStyle = cell.getCellStyle();
                    if (object.contains(cellStyle)) continue;
                    this.printStyle(cellStyle);
                    object.add(cellStyle);
                }
            }
        }
    }

    private void printStyle(CellStyle cellStyle) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(cellStyle));
        this.styleContents(cellStyle);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle cellStyle) {
        VerticalAlignment verticalAlignment;
        String string;
        HorizontalAlignment horizontalAlignment = cellStyle.getAlignment();
        String string2 = HorizontalAlignment.LEFT == horizontalAlignment ? (String)HALIGN.get(HorizontalAlignment.LEFT) : (HorizontalAlignment.CENTER == horizontalAlignment ? (String)HALIGN.get(HorizontalAlignment.CENTER) : (HorizontalAlignment.CENTER_SELECTION == horizontalAlignment ? (String)HALIGN.get(HorizontalAlignment.CENTER_SELECTION) : (HorizontalAlignment.RIGHT == horizontalAlignment ? (String)HALIGN.get(HorizontalAlignment.RIGHT) : (String)HALIGN.get(HorizontalAlignment.LEFT))));
        if (string2 != null && !string2.isEmpty()) {
            this.out.format("  %s: %s;%n", "text-align", string2);
        }
        if ((string = VerticalAlignment.TOP == (verticalAlignment = cellStyle.getVerticalAlignment()) ? (String)VALIGN.get(VerticalAlignment.TOP) : (VerticalAlignment.CENTER == verticalAlignment ? (String)VALIGN.get(VerticalAlignment.CENTER) : (VerticalAlignment.BOTTOM == verticalAlignment ? (String)VALIGN.get(VerticalAlignment.BOTTOM) : (String)VALIGN.get(VerticalAlignment.CENTER)))) != null && !string.isEmpty()) {
            this.out.format("  %s: %s;%n", "vertical-align", string);
        }
        this.fontStyle(cellStyle);
        this.borderStyles(cellStyle);
        this.helper.a(cellStyle, this.out);
    }

    private void borderStyles(CellStyle cellStyle) {
        this.InnerBorderStyle("border-left", cellStyle.getBorderLeft(), BORDER);
        this.InnerBorderStyle("border-right", cellStyle.getBorderRight(), BORDER);
        this.InnerBorderStyle("border-top", cellStyle.getBorderTop(), BORDER);
        this.InnerBorderStyle("border-bottom", cellStyle.getBorderBottom(), BORDER);
    }

    private void InnerBorderStyle(String string, BorderStyle borderStyle, Map map) {
        String string2 = BorderStyle.NONE == borderStyle ? (String)map.get(BorderStyle.NONE) : (BorderStyle.THIN == borderStyle ? (String)map.get(BorderStyle.THIN) : (BorderStyle.MEDIUM == borderStyle ? (String)map.get(BorderStyle.MEDIUM) : (BorderStyle.DASHED == borderStyle ? (String)map.get(BorderStyle.DASHED) : (BorderStyle.HAIR == borderStyle ? (String)map.get(BorderStyle.HAIR) : (BorderStyle.THICK == borderStyle ? (String)map.get(BorderStyle.THICK) : (BorderStyle.DOUBLE == borderStyle ? (String)map.get(BorderStyle.DOUBLE) : (BorderStyle.DOTTED == borderStyle ? (String)map.get(BorderStyle.DOTTED) : (BorderStyle.MEDIUM_DASHED == borderStyle ? (String)map.get(BorderStyle.MEDIUM_DASHED) : (BorderStyle.DASH_DOT == borderStyle ? (String)map.get(BorderStyle.DASH_DOT) : (BorderStyle.DASH_DOT_DOT == borderStyle ? (String)map.get(BorderStyle.DASH_DOT_DOT) : (BorderStyle.MEDIUM_DASH_DOT == borderStyle ? (String)map.get(BorderStyle.MEDIUM_DASH_DOT) : (BorderStyle.SLANTED_DASH_DOT == borderStyle ? (String)map.get(BorderStyle.SLANTED_DASH_DOT) : (String)map.get(BorderStyle.NONE)))))))))))));
        if (string2 != null && !string2.isEmpty()) {
            this.out.format("  %s: %s;%n", string, string2);
        }
    }

    private void fontStyle(CellStyle cellStyle) {
        int n2;
        Font font = this.wb.getFontAt(cellStyle.getFontIndex());
        if (font.getBold()) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if ((n2 = font.getFontHeightInPoints()) == 9) {
            n2 = 10;
        }
        this.out.format("  font-size: %dpt;%n", n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String styleName(CellStyle cellStyle) {
        if (cellStyle == null) {
            cellStyle = this.wb.getCellStyleAt(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (Formatter formatter = new Formatter(stringBuilder);){
            formatter.format("style_%02x", cellStyle.getIndex());
            String string = formatter.toString();
            return string;
        }
    }

    private void styleOut(String string, Object object, Map map) {
        String string2 = (String)map.get(object);
        if (string2 != null) {
            this.out.format("  %s: %s;%n", string, string2);
        }
    }

    private void printSheets() {
        this.ensureOut();
        Sheet sheet = this.wb.getSheetAt(this.iCur - 1);
        this.printSheet(sheet);
    }

    public void printSheet(Sheet sheet) {
        this.ensureOut();
        this.out.format("<table class=%s>%n", DEFAULTS_CLASS);
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n", new Object[0]);
    }

    private void printCols(Sheet sheet) {
        this.out.format("<col/>%n", new Object[0]);
        this.ensureColumnBounds(sheet);
        for (int i2 = this.firstColumn; i2 < this.endColumn; ++i2) {
            this.out.format("<col/>%n", new Object[0]);
        }
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.gotBounds) {
            return;
        }
        Iterator iterator = sheet.rowIterator();
        this.firstColumn = iterator.hasNext() ? Integer.MAX_VALUE : 0;
        this.endColumn = 0;
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            short s2 = row.getFirstCellNum();
            if (s2 < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, s2);
            this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
        }
        this.gotBounds = true;
    }

    private void printColumnHeads() {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = this.firstColumn; i2 < this.endColumn; ++i2) {
            stringBuilder.setLength(0);
            int n2 = i2;
            do {
                stringBuilder.insert(0, (char)(65 + n2 % 26));
            } while ((n2 /= 26) > 0);
            this.out.format("    <th class=%s>%s</th>%n", COL_HEAD_CLASS, stringBuilder);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        this.printColumnHeads();
        this.out.format("<tbody>%n", new Object[0]);
        Iterator iterator = sheet.rowIterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s>%d</td>%n", ROW_HEAD_CLASS, row.getRowNum() + 1);
            for (int i2 = this.firstColumn; i2 < this.endColumn; ++i2) {
                Cell cell;
                String string = "&nbsp;";
                String string2 = "";
                CellStyle cellStyle = null;
                if (i2 >= row.getFirstCellNum() && i2 < row.getLastCellNum() && (cell = row.getCell(i2)) != null) {
                    cellStyle = cell.getCellStyle();
                    string2 = this.tagStyle(cell, cellStyle);
                    System.out.println("style.getDataFormatString()= " + cellStyle.getDataFormatString());
                    if (cellStyle.getDataFormatString() == null) continue;
                    CellFormat cellFormat = CellFormat.getInstance((String)cellStyle.getDataFormatString());
                    CellFormatResult cellFormatResult = cellFormat.apply(cell);
                    string = cellFormatResult.text;
                    if (string.equals("")) {
                        string = "&nbsp;";
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(cellStyle), string2, string);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle cellStyle) {
        if (cellStyle.getAlignment() == HorizontalAlignment.GENERAL) {
            switch (cell.getCellType()) {
                case STRING: {
                    return "style=\"text-align: left;\"";
                }
                case BOOLEAN: 
                case ERROR: {
                    return "style=\"text-align: center;\"";
                }
            }
        }
        return "";
    }
}

