/*
 * Decompiled with CFR 0.152.
 */
package com.yovn.labs;

import com.yovn.labs.MyListener;
import com.yovn.labs.SystemKBListener;

public class KeyBoardMonitor {
    SystemKBListener _listener;
    private Thread eventT;
    private volatile boolean stopE;
    private static final KeyBoardMonitor instance;

    private KeyBoardMonitor() {
    }

    public static KeyBoardMonitor getInstance() {
        return instance;
    }

    public int enableMonitor() {
        int ret = this.enableMonitorN();
        if (ret == 1) {
            this.eventT = new Thread(){

                public void run() {
                    while (!KeyBoardMonitor.this.stopE) {
                        boolean down;
                        int readE = KeyBoardMonitor.this.getNextEvent();
                        if (readE == -1) {
                            System.err.println("event pipe error!!!!");
                            break;
                        }
                        if (readE == 0) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {}
                            continue;
                        }
                        int key = (readE & 0xFFFF00) >> 8 & 0xFFFF;
                        boolean bl = down = (readE & 1) == 1;
                        if (KeyBoardMonitor.this._listener == null) continue;
                        if (down) {
                            KeyBoardMonitor.this._listener.keyDown(key);
                            continue;
                        }
                        KeyBoardMonitor.this._listener.keyUp(key);
                    }
                }
            };
            this.stopE = false;
            this.eventT.start();
        }
        return ret;
    }

    private native int getNextEvent();

    private native int enableMonitorN();

    public void setSystemKBListener(SystemKBListener listener) {
        this._listener = listener;
    }

    public int disableMonitor() {
        int ret = this.disableMonitorN();
        if (ret == 0) {
            this.stopE = true;
            if (this.eventT != null) {
                this.eventT.interrupt();
                this.eventT = null;
            }
        }
        return ret;
    }

    private native int disableMonitorN();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Object obj;
        KeyBoardMonitor kl = KeyBoardMonitor.getInstance();
        MyListener ml = new MyListener();
        kl.setSystemKBListener(ml);
        System.out.println("now enable monitor :" + kl.enableMonitor());
        Object object = obj = new Object();
        synchronized (object) {
            obj.wait(60000L);
        }
        System.err.println("now disabled monitor:" + kl.disableMonitor());
    }

    static {
        System.loadLibrary("KBMonitor_C");
        instance = new KeyBoardMonitor();
    }
}

