/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private NumericType numericType;
    private boolean frozen;
    private int numericPrecisionStep = 16;
    private DocValuesType docValuesType = DocValuesType.NONE;

    public FieldType(FieldType ref) {
        this.stored = ref.stored();
        this.tokenized = ref.tokenized();
        this.storeTermVectors = ref.storeTermVectors();
        this.storeTermVectorOffsets = ref.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref.storeTermVectorPayloads();
        this.omitNorms = ref.omitNorms();
        this.indexOptions = ref.indexOptions();
        this.docValuesType = ref.docValuesType();
        this.numericType = ref.numericType();
    }

    public FieldType() {
    }

    private void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean value) {
        this.checkIfFrozen();
        this.stored = value;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean value) {
        this.checkIfFrozen();
        this.tokenized = value;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectors = value;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public void setStoreTermVectorOffsets(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public void setStoreTermVectorPositions(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public void setStoreTermVectorPayloads(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean value) {
        this.checkIfFrozen();
        this.omitNorms = value;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions value) {
        this.checkIfFrozen();
        if (value == null) {
            throw new NullPointerException("IndexOptions cannot be null");
        }
        this.indexOptions = value;
    }

    public void setNumericType(NumericType type) {
        this.checkIfFrozen();
        this.numericType = type;
    }

    public NumericType numericType() {
        return this.numericType;
    }

    public void setNumericPrecisionStep(int precisionStep) {
        this.checkIfFrozen();
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >= 1 (got " + precisionStep + ")");
        }
        this.numericPrecisionStep = precisionStep;
    }

    public int numericPrecisionStep() {
        return this.numericPrecisionStep;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        if (this.stored()) {
            result.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("indexed");
            if (this.tokenized()) {
                result.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result.append(",indexOptions=");
                result.append((Object)this.indexOptions);
            }
            if (this.numericType != null) {
                result.append(",numericType=");
                result.append((Object)this.numericType);
                result.append(",numericPrecisionStep=");
                result.append(this.numericPrecisionStep);
            }
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("docValuesType=");
            result.append((Object)this.docValuesType);
        }
        return result.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType type) {
        this.checkIfFrozen();
        if (type == null) {
            throw new NullPointerException("DocValuesType cannot be null");
        }
        this.docValuesType = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        result = 31 * result + this.indexOptions.hashCode();
        result = 31 * result + this.numericPrecisionStep;
        result = 31 * result + (this.numericType == null ? 0 : this.numericType.hashCode());
        result = 31 * result + (this.omitNorms ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorOffsets ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorPayloads ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectorPositions ? 1231 : 1237);
        result = 31 * result + (this.storeTermVectors ? 1231 : 1237);
        result = 31 * result + (this.stored ? 1231 : 1237);
        result = 31 * result + (this.tokenized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        if (this.docValuesType != other.docValuesType) {
            return false;
        }
        if (this.indexOptions != other.indexOptions) {
            return false;
        }
        if (this.numericPrecisionStep != other.numericPrecisionStep) {
            return false;
        }
        if (this.numericType != other.numericType) {
            return false;
        }
        if (this.omitNorms != other.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other.storeTermVectors) {
            return false;
        }
        if (this.stored != other.stored) {
            return false;
        }
        return this.tokenized == other.tokenized;
    }

    public static enum NumericType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

