/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;

public final class FieldInfo {
    public final String name;
    public final int number;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private boolean storeTermVector;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean storePayloads;
    private Map<String, String> attributes;
    private long dvGen;

    public FieldInfo(String name, int number, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, Map<String, String> attributes) {
        if (docValues == null) {
            throw new NullPointerException("DocValuesType cannot be null (field: \"" + name + "\")");
        }
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions cannot be null (field: \"" + name + "\")");
        }
        this.name = name;
        this.number = number;
        this.docValuesType = docValues;
        this.indexOptions = indexOptions;
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = storeTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = dvGen;
        this.attributes = attributes;
        assert (this.checkConsistency());
    }

    public boolean checkConsistency() {
        if (this.indexOptions != IndexOptions.NONE) {
            if (this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0 && this.storePayloads) {
                throw new IllegalStateException("indexed field '" + this.name + "' cannot have payloads without positions");
            }
        } else {
            if (this.storeTermVector) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store term vectors");
            }
            if (this.storePayloads) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot store payloads");
            }
            if (this.omitNorms) {
                throw new IllegalStateException("non-indexed field '" + this.name + "' cannot omit norms");
            }
        }
        if (this.dvGen != -1L && this.docValuesType == DocValuesType.NONE) {
            throw new IllegalStateException("field '" + this.name + "' cannot have a docvalues update generation without having docvalues");
        }
        return true;
    }

    void update(boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions) {
        if (indexOptions == null) {
            throw new NullPointerException("IndexOptions cannot be null (field: \"" + this.name + "\")");
        }
        if (this.indexOptions != indexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = indexOptions;
            } else if (indexOptions != IndexOptions.NONE) {
                IndexOptions indexOptions2 = this.indexOptions = this.indexOptions.compareTo(indexOptions) < 0 ? this.indexOptions : indexOptions;
            }
        }
        if (this.indexOptions != IndexOptions.NONE) {
            this.storeTermVector |= storeTermVector;
            this.storePayloads |= storePayloads;
            if (indexOptions != IndexOptions.NONE && this.omitNorms != omitNorms) {
                this.omitNorms = true;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
        assert (this.checkConsistency());
    }

    void setDocValuesType(DocValuesType type) {
        if (type == null) {
            throw new NullPointerException("DocValuesType cannot be null (field: \"" + this.name + "\")");
        }
        if (this.docValuesType != DocValuesType.NONE && type != DocValuesType.NONE && this.docValuesType != type) {
            throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)this.docValuesType) + " to " + (Object)((Object)type) + " for field \"" + this.name + "\"");
        }
        this.docValuesType = type;
        assert (this.checkConsistency());
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions newIndexOptions) {
        if (this.indexOptions != newIndexOptions) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = newIndexOptions;
            } else if (newIndexOptions != IndexOptions.NONE) {
                IndexOptions indexOptions = this.indexOptions = this.indexOptions.compareTo(newIndexOptions) < 0 ? this.indexOptions : newIndexOptions;
            }
        }
        if (this.indexOptions == IndexOptions.NONE || this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
            this.storePayloads = false;
        }
    }

    public DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    void setDocValuesGen(long dvGen) {
        this.dvGen = dvGen;
        assert (this.checkConsistency());
    }

    public long getDocValuesGen() {
        return this.dvGen;
    }

    void setStoreTermVectors() {
        this.storeTermVector = true;
        assert (this.checkConsistency());
    }

    void setStorePayloads() {
        if (this.indexOptions != IndexOptions.NONE && this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        assert (this.checkConsistency());
    }

    public boolean omitsNorms() {
        return this.omitNorms;
    }

    public void setOmitsNorms() {
        if (this.indexOptions == IndexOptions.NONE) {
            throw new IllegalStateException("cannot omit norms: this field is not indexed");
        }
        this.omitNorms = true;
    }

    public boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public boolean hasPayloads() {
        return this.storePayloads;
    }

    public boolean hasVectors() {
        return this.storeTermVector;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public String putAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes.put(key, value);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }
}

