/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

public final class NativeFSLockFactory
extends FSLockFactory {
    public static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory();

    private NativeFSLockFactory() {
    }

    @Override
    protected Lock makeFSLock(FSDirectory dir, String lockName) {
        return new NativeFSLock(dir.getDirectory(), lockName);
    }

    static final class NativeFSLock
    extends Lock {
        private FileChannel channel;
        private FileLock lock;
        private Path path;
        private Path lockDir;
        private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());

        public NativeFSLock(Path lockDir, String lockFileName) {
            this.lockDir = lockDir;
            this.path = lockDir.resolve(lockFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public synchronized boolean obtain() throws IOException {
            if (this.lock != null) {
                return false;
            }
            Files.createDirectories(this.lockDir, new FileAttribute[0]);
            try {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            Path canonicalPath = this.path.toRealPath(new LinkOption[0]);
            boolean obtained = false;
            if (!LOCK_HELD.add(canonicalPath.toString())) return obtained;
            try {
                this.channel = FileChannel.open(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                try {
                    this.lock = this.channel.tryLock();
                    if (this.lock != null) {
                        return true;
                    }
                    boolean bl = false;
                    obtained = bl;
                }
                catch (IOException | OverlappingFileLockException e) {
                    this.failureReason = e;
                }
                if (obtained) return obtained;
            }
            catch (Throwable throwable) {
                if (obtained) throw throwable;
                NativeFSLock.clearLockHeld(this.path);
                FileChannel toClose = this.channel;
                this.channel = null;
                IOUtils.closeWhileHandlingException(toClose);
                throw throwable;
            }
            NativeFSLock.clearLockHeld(this.path);
            FileChannel toClose = this.channel;
            this.channel = null;
            IOUtils.closeWhileHandlingException(toClose);
            return obtained;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            block5: {
                try {
                    if (this.lock == null) break block5;
                    try {
                        this.lock.release();
                        this.lock = null;
                    }
                    finally {
                        NativeFSLock.clearLockHeld(this.path);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(this.channel);
                    this.channel = null;
                    throw throwable;
                }
            }
            IOUtils.close(this.channel);
            this.channel = null;
        }

        private static final void clearLockHeld(Path path) throws IOException {
            path = path.toRealPath(new LinkOption[0]);
            boolean remove = LOCK_HELD.remove(path.toString());
            assert (remove) : "Lock was cleared but never marked as held";
        }

        @Override
        public synchronized boolean isLocked() {
            if (this.lock != null) {
                return true;
            }
            if (Files.notExists(this.path, new LinkOption[0])) {
                return false;
            }
            try {
                boolean obtained = this.obtain();
                if (obtained) {
                    this.close();
                }
                return !obtained;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public String toString() {
            return "NativeFSLock@" + this.path;
        }
    }
}

