/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

public class RAMDirectory
extends BaseDirectory
implements Accountable {
    protected final Map<String, RAMFile> fileMap = new ConcurrentHashMap<String, RAMFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();

    public RAMDirectory() {
        this(new SingleInstanceLockFactory());
    }

    public RAMDirectory(LockFactory lockFactory) {
        super(lockFactory);
    }

    public RAMDirectory(Directory dir, IOContext context) throws IOException {
        this(dir, false, context);
    }

    private RAMDirectory(Directory dir, boolean closeDir, IOContext context) throws IOException {
        this();
        for (String file : dir.listAll()) {
            this.copyFrom(dir, file, file, context);
        }
        if (closeDir) {
            dir.close();
        }
    }

    @Override
    public final String[] listAll() {
        this.ensureOpen();
        Set<String> fileNames = this.fileMap.keySet();
        ArrayList<String> names = new ArrayList<String>(fileNames.size());
        for (String name : fileNames) {
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public final boolean fileNameExists(String name) {
        this.ensureOpen();
        return this.fileMap.containsKey(name);
    }

    @Override
    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("file", this.fileMap);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        file.directory = null;
        this.sizeInBytes.addAndGet(-file.sizeInBytes);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        RAMFile file = this.newRAMFile();
        RAMFile existing = this.fileMap.remove(name);
        if (existing != null) {
            this.sizeInBytes.addAndGet(-existing.sizeInBytes);
            existing.directory = null;
        }
        this.fileMap.put(name, file);
        return new RAMOutputStream(name, file, true);
    }

    protected RAMFile newRAMFile() {
        return new RAMFile(this);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public void renameFile(String source, String dest) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(source);
        if (file == null) {
            throw new FileNotFoundException(source);
        }
        this.fileMap.put(dest, file);
        this.fileMap.remove(source);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new RAMInputStream(name, file);
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.fileMap.clear();
    }
}

