/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SparseFixedBitSet;

public class BitDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitDocIdSet.class);
    private final BitSet set;
    private final long cost;

    public BitDocIdSet(BitSet set, long cost) {
        this.set = set;
        this.cost = cost;
    }

    public BitDocIdSet(BitSet set) {
        this(set, set.approximateCardinality());
    }

    @Override
    public DocIdSetIterator iterator() {
        return new BitSetIterator(this.set, this.cost);
    }

    @Override
    public BitSet bits() {
        return this.set;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.set.ramBytesUsed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(set=" + this.set + ",cost=" + this.cost + ")";
    }

    public static final class Builder {
        private final int maxDoc;
        private final int threshold;
        private SparseFixedBitSet sparseSet;
        private FixedBitSet denseSet;
        private long costUpperBound;

        public Builder(int maxDoc, boolean full) {
            this.maxDoc = maxDoc;
            this.threshold = maxDoc >>> 10;
            if (full) {
                this.denseSet = new FixedBitSet(maxDoc);
                this.denseSet.set(0, maxDoc);
            }
        }

        public Builder(int maxDoc) {
            this(maxDoc, false);
        }

        boolean dense() {
            return this.denseSet != null;
        }

        public void or(DocIdSetIterator it) throws IOException {
            if (this.denseSet != null) {
                this.denseSet.or(it);
                return;
            }
            long itCost = it.cost();
            this.costUpperBound += itCost;
            if (this.costUpperBound >= (long)this.threshold) {
                this.costUpperBound = (long)(this.sparseSet == null ? 0 : this.sparseSet.approximateCardinality()) + itCost;
                if (this.costUpperBound >= (long)this.threshold) {
                    this.denseSet = new FixedBitSet(this.maxDoc);
                    this.denseSet.or(it);
                    if (this.sparseSet != null) {
                        this.denseSet.or(new BitSetIterator(this.sparseSet, 0L));
                    }
                    return;
                }
            }
            if (this.sparseSet == null) {
                this.sparseSet = new SparseFixedBitSet(this.maxDoc);
            }
            this.sparseSet.or(it);
        }

        public void and(DocIdSetIterator it) throws IOException {
            if (this.denseSet != null) {
                this.denseSet.and(it);
            } else if (this.sparseSet != null) {
                this.sparseSet.and(it);
            }
        }

        public void andNot(DocIdSetIterator it) throws IOException {
            if (this.denseSet != null) {
                this.denseSet.andNot(it);
            } else if (this.sparseSet != null) {
                this.sparseSet.andNot(it);
            }
        }

        public BitDocIdSet build() {
            BitDocIdSet result = this.denseSet != null ? new BitDocIdSet(this.denseSet) : (this.sparseSet != null ? new BitDocIdSet(this.sparseSet) : null);
            this.denseSet = null;
            this.sparseSet = null;
            this.costUpperBound = 0L;
            return result;
        }
    }
}

