﻿//
//	SW_3DGraphic2.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	MYSECT	TEXT("Params")

#define X1	1200.0
#define X2	1300.0
#define Y1	300.0
#define Y2	400.0
#define XC	((X1 + X2) / 2.0)
#define YC	((Y1 + Y2) / 2.0)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hWndCtrl;						//	３Ｄグラフコントロールのウインドハンドル
int 			CtrlTop;						//	３Ｄグラフコントロールの上端位置
BOOL			fPlot = FALSE;					//	プロット中を示すフラグ
UI				period = 100;					//	プロット周期[ms]
BOOL			fTest  = FALSE;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	SetStyleToCheckBox(VO);
static	VO	SetCheckBoxToStyle(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;
	int 	sty;
	RECT	rect;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	sty = (int)MAjcGetWindowLong(hDlgMain, GWL_STYLE);
	MAjcSetWindowLong(hDlgMain, GWL_STYLE, sty | WS_THICKFRAME);
	//----- ３Ｄグラフコントロール位置初期化 -----------//
	GetWindowRect(hWndCtrl, &rect);
	MapWindowPoints(NULL, hDlgMain, (LPPOINT)&rect, 2);
	CtrlTop = rect.top;
	GetClientRect(hDlgMain, &rect);
	MoveWindow(hWndCtrl, 0, CtrlTop, rect.right - rect.left, rect.bottom - rect.top - CtrlTop, TRUE);
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	AJC3DGPROP	prop;

	hDlgMain = hDlg;
	hWndCtrl = GetDlgItem(hDlgMain, IDC_3DGRAPH);
	//----- チップテキスト設定 -----------------------------------//
	AjcG3dSetTipText	  (hWndCtrl,	TEXT("２Ｄグラフィック"));
	AjcG3dSetChkBoxTipText(hWndCtrl, 0, TEXT("プロット０"));
	AjcG3dSetChkBoxTipText(hWndCtrl, 1, TEXT("プロット１"));
	AjcG3dSetChkBoxTipText(hWndCtrl, 2, TEXT("プロット２"));
	AjcG3dSetChkBoxTipText(hWndCtrl, 2, TEXT("プロット３"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_NOFILTER ) , TEXT("データ表示／非表示用チェックボックス非表示")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_NOBORDER ) , TEXT("外枠非表示")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_AXIS_X	) , TEXT("Ｘ軸表示")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_AXIS_Y	) , TEXT("Ｙ軸表示")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_RECTSCALE) , TEXT("方眼スケール表示（表示面はSCALE_XYで指定）")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_ELPSSCALE) , TEXT("同心円スケール表示（表示面はSCALE_XYで指定）")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SCALE_XY ) , TEXT("ＸＹ平面にスケール表示（スケールはRECTSCALE, ELPSSCALEで指定）")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_VAL_X	) , TEXT("Ｘ軸の値表示")); 
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_VAL_Y	) , TEXT("Ｙ軸の値表示")); 
	//----- ２Ｄグラフモード設定 ---------------------------------//
	AjcG2dInit(hWndCtrl, X1, Y1, X2, Y2, AJC3DGS_2DMODE | AJC3DGS_ELPSSCALE);
	//----- ウインドスタイル値をチェックボックスに設定 -----------//
	SetStyleToCheckBox();
	//----- 初期値設定 -------------------------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_INP_PLOTNUM0, 16);
	AjcSetDlgItemUInt(hDlg, IDC_INP_PLOTNUM1, 16);
	AjcSetDlgItemUInt(hDlg, IDC_INP_PLOTNUM2, 16);
	AjcSetDlgItemUInt(hDlg, IDC_INP_PLOTNUM3, 16);
	AjcSetDlgItemChk (hDlg, IDC_CHK_PLOTLINE, TRUE);
	//----- 設定値ロード -----------------------------------------//
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL);
	//----- チェックボックスの内容をスタイルに反映 ---------------//
	SetCheckBoxToStyle();
	//----- グラフレンジ設定 -------------------------------------//
	AjcG2dSetRange(hWndCtrl, X1, Y1, X2, Y2);
	//----- ２Ｄグラフコントロールのプロパティ反映 ---------------//
	AjcG2dGetProp(hWndCtrl, &prop);
	prop.Item[0].MaxPlot = AjcGetDlgItemUInt(hDlg, IDC_INP_PLOTNUM0);
	prop.Item[1].MaxPlot = AjcGetDlgItemUInt(hDlg, IDC_INP_PLOTNUM1);
	prop.Item[2].MaxPlot = AjcGetDlgItemUInt(hDlg, IDC_INP_PLOTNUM2);
	prop.Item[3].MaxPlot = AjcGetDlgItemUInt(hDlg, IDC_INP_PLOTNUM3);
	prop.fPlotLine		 = AjcGetDlgItemChk (hDlg, IDC_CHK_PLOTLINE);
	AjcG2dSetProp(hWndCtrl, &prop);
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- 設定値セーブ -----------------------------------------//
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	int 	w = LOWORD(lParam);
	int 	h = HIWORD(lParam);
	
	MoveWindow	(GetDlgItem(hDlg, IDC_3DGRAPH), 0, CtrlTop, w, h - CtrlTop, TRUE);

	return TRUE;
}
//----- COMMAND ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	BOOL		rc = FALSE;
	int 		cmd = LOWORD(wParam);
	UI			ix;
	AJC3DGPROP	prop;

	//----- スタイル設定チェックボックス操作 -------------------------------------------------//
	if (cmd >= IDC_CHK_RECTSCALE && cmd <= IDC_CHK_AXIS_Y && HIWORD(wParam) == BN_CLICKED) {
		//	チェックボックスの内容をスタイルに反映
		SetCheckBoxToStyle();
		rc = TRUE;
	}
	//----- プロット数設定操作 -----------------------------------------------------------------//
	if (cmd >= IDC_INP_PLOTNUM0 && cmd <= IDC_INP_PLOTNUM3 && HIWORD(wParam) == AJCIVN_INTVALUE) {
		ix = cmd - IDC_INP_PLOTNUM0;
		AjcG2dGetProp(hWndCtrl, &prop);
		prop.Item[ix].MaxPlot = (UI)lParam;
		AjcG2dSetProp(hWndCtrl, &prop);
		rc = TRUE;
	}

	return rc;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER		)
{
	UI		i;
	double	x, y, r, xc, yc;
	static	BOOL	fElps[4] = {0, 0, 0, 0};
	static	double	theta[4] = {0, 0, 0, 0};

	for (i = 0; i < 4; i++) {
		xc = XC; yc = YC;
		r  = 10 * (i + 1);
		x  = r * cos(theta[i]);
		y  = r * sin(theta[i]);
		AjcG2dPutPlotData(hWndCtrl, i, XC + x, YC + y);
		if (theta[i] >= 0.0 && theta[i] <= AJC_DEG2RAD(90.0)) {
			if (!fElps[i]) {
				AjcG2dEllipse (hWndCtrl, i, xc, yc, r, r);
				fElps[i] = TRUE;
			}
		}
		else {
			if (fElps[i]) {
				AjcG2dClearShape(hWndCtrl, i);
				fElps[i] = FALSE;
			}
		}
		theta[i] += (AJC_DEG2RAD(10.0) * (double)rand() / (double)RAND_MAX);
		theta[i]  = fmod(theta[i], (AJC_PAI * 2.0));
	}
	return TRUE;
}
//----- プロットライン・チェックボックス -----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_PLOTLINE)
{
	AJC3DGPROP	prop;

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcG2dGetProp(hWndCtrl, &prop);
		prop.fPlotLine = AjcGetDlgItemChk(hDlg, IDC_CHK_PLOTLINE);
		AjcG2dSetProp(hWndCtrl, &prop);
	}
	return TRUE;
}
//----- プロット開始／停止ボタン -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START_STOP)
{
	if (fPlot) {
		fPlot = FALSE;
		KillTimer(hDlg, 1);
		AjcSetDlgItemStr(hDlg, IDC_CMD_START_STOP, TEXT("プロット開始"));
	}
	else {
		fPlot = TRUE;
		SetTimer(hDlg, 1, period, NULL);
		AjcSetDlgItemStr(hDlg, IDC_CMD_START_STOP, TEXT("プロット停止"));
	}
	return TRUE;
}
//----- プロット周期 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_PERIOD	)
{
	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		period = AjcGetDlgItemUInt(hDlg, IDC_INP_PERIOD);
		if (fPlot) {
			SetTimer(hDlgMain, 1, period, NULL);
		}
	}
	return TRUE;
}
//----- テストボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TEST		)
{
	if (!fTest) {
		AjcG2dStar(hWndCtrl, 4, 1270, 370, 20);
		AjcG2dFillB  (hWndCtrl, 5, 4, 1270, 370);
		AjcG2dPixel(hWndCtrl, 4,  1270, 370, 3);

		AjcG2dEllipse(hWndCtrl	, 5, 1270, 370,  23, 23);
		AjcG2dTriangle(hWndCtrl , 6, 1210, 350,  1230, 390,  1240, 374);
		AjcG2dEllipse(hWndCtrl	, 7, 1250, 330,  40, 15);
		AjcG2dRectangle(hWndCtrl, 4, 1240, 340,  1260, 320);
		fTest = TRUE;
	}
	else {
		AjcG2dClearAllShape(hWndCtrl);
		fTest = FALSE;
	}
	return TRUE;
}
//----- クリアーボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLEAR		)
{
	fTest = FALSE;
	AjcG2dClear(hWndCtrl);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_SIZE		   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_COMMAND 	   )
	AJC_DLGMAP_MSG(Main, WM_TIMER		   )

	AJC_DLGMAP_CMD(Main, IDC_CHK_PLOTLINE  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_START_STOP)
	AJC_DLGMAP_CMD(Main, IDC_INP_PERIOD    )
	AJC_DLGMAP_CMD(Main, IDC_CMD_TEST	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLEAR	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ウインドスタイル値をチェックボックスに設定																	//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetStyleToCheckBox(VO)
{
	UI		sty;

	sty = (UI)MAjcGetWindowLong(hWndCtrl, GWL_STYLE);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOBORDER    , (sty & AJC3DGS_NOBORDER	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_NOFILTER    , (sty & AJC3DGS_NOFILTER	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_AXIS_X	   , (sty & AJC3DGS_SHOWAXIS_X	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_AXIS_Y	   , (sty & AJC3DGS_SHOWAXIS_Y	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_RECTSCALE   , (sty & AJC3DGS_RECTSCALE	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_ELPSSCALE   , (sty & AJC3DGS_ELPSSCALE	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_LINE_XY	   , (sty & AJC3DGS_SCALE_XY	 ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_VAL_X	   , (sty & AJC3DGS_SCALEVALUE_X ) != 0);
	AjcSetDlgItemChk(hDlgMain, IDC_CHK_VAL_Y	   , (sty & AJC3DGS_SCALEVALUE_Y ) != 0);
}
//--------------------------------------------------------------------------------------------------------------//
//	チェックボックスの設定をスタイルに反映																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetCheckBoxToStyle(VO)
{
	UI		sty;

	sty = (UI)MAjcGetWindowLong(hWndCtrl, GWL_STYLE);
	sty &= ~(AJC3DGS_NOBORDER  | AJC3DGS_NOFILTER | AJC3DGS_SHOWAXIS_X	 | AJC3DGS_SHOWAXIS_Y | AJC3DGS_RECTSCALE |
			 AJC3DGS_ELPSSCALE | AJC3DGS_SCALE_XY | AJC3DGS_SCALEVALUE_X | AJC3DGS_SCALEVALUE_Y);
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOBORDER    )) sty |= AJC3DGS_NOBORDER;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_NOFILTER    )) sty |= AJC3DGS_NOFILTER;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_AXIS_X	   )) sty |= AJC3DGS_SHOWAXIS_X;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_AXIS_Y	   )) sty |= AJC3DGS_SHOWAXIS_Y;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RECTSCALE   )) sty |= AJC3DGS_RECTSCALE;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_ELPSSCALE   )) sty |= AJC3DGS_ELPSSCALE;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SCALE_XY    )) sty |= AJC3DGS_SCALE_XY;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_VAL_X	   )) sty |= AJC3DGS_SCALEVALUE_X;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_VAL_Y	   )) sty |= AJC3DGS_SCALEVALUE_Y;
	MAjcSetWindowLong(hWndCtrl, GWL_STYLE, sty);
}

