﻿//
//	SW_3DGraphic3.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	SIZE			szDlg;							//	ダイアログの最小サイズ
static	HWND			hWndG3d;						//	３Ｄグラフィックコントロール
static	RECT			rcG3d;							//	初期の３Ｄグラフィックコントロール矩形
static	AJC3DVEC		cent = {1.0, 2.0, 3.0};			//	中心位置

static	UI				Count = 0;						//	選択ポイント数
static	UI				Ix	  = 0;						//	ポイントバッファインデクス
static	AJC3DVEC		Points[3];						//	ポイントバッファ
static	AJC3DVEC		vh;								//	視点方向ベクトル（平面の法線）

static const UT TipMsg[] =	TEXT("SHIFT+クリックで、任意の３点を選択してください。\n")
							TEXT("３点が選択されたら、各点をとおる平面円が表示されます。\n")
							TEXT("\n")
							TEXT("視点設定ボタンを押すと、視点を平面の真上に設定します。\n")
;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		SetControlSize(HWND hDlg);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;
	RECT	rect;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);
	//----- ウインド最小サイズ退避 ---------------------//
	GetWindowRect(hDlgMain, &rect);
	szDlg.cx = rect.right - rect.left;
	szDlg.cy = rect.bottom - rect.top;

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UI			i;
	AJC3DVEC	v;
	double		max;

	hDlgMain = hDlg;
	hWndG3d = GetDlgItem(hDlgMain, IDC_3DGRAPH);

	GetWindowRect(hWndG3d, &rcG3d); MapWindowPoints(NULL, hDlg, (LPPOINT)&rcG3d, 2);
	SetControlSize(hDlg);

	AjcG3dSetCenter (hWndG3d, cent.x, cent.y, cent.z);
	AjcG3dSetAngle3D(hWndG3d);

	//	球面付近にランダムな点を１００個表示
	for (i = 0; i < 100; i ++) {
		v.x = (double)rand() / (double)RAND_MAX;
		max = sqrt(1.0 - pow(v.x, 2.0));
		v.y = ((double)rand() / (double)RAND_MAX) * max;
		v.z = sqrt(1.0 - pow(v.x, 2.0) - pow(v.y, 2.0));
		if (rand() & 1) v.x += ((double)rand() / (double)RAND_MAX * 0.1); else v.x -= ((double)rand() / (double)RAND_MAX * 0.1);
		if (rand() & 1) v.y += ((double)rand() / (double)RAND_MAX * 0.1); else v.y -= ((double)rand() / (double)RAND_MAX * 0.1);
		if (rand() & 1) v.z += ((double)rand() / (double)RAND_MAX * 0.1); else v.z -= ((double)rand() / (double)RAND_MAX * 0.1);
		if (rand() & 1) v.x *= -1;
		if (rand() & 1) v.y *= -1;
		if (rand() & 1) v.z *= -1;
		AjcV3dAdd(&v, &cent, &v);
		AjcG3dPixelV(hWndG3d, 0, &v, 3);
	}

	//	初期メッセージ表示
	AjcTipTextShowCenter(hDlg, TipMsg, 10000, NULL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更中 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZING			)
{
	LPRECT	pRect = (LPRECT)lParam;
	SIZE	sz;

	sz.cx = pRect->right - pRect->left;
	sz.cy = pRect->bottom - pRect->top;
	
	if (sz.cx < szDlg.cx) pRect->right	= pRect->left + szDlg.cx;
	if (sz.cy < szDlg.cy) pRect->bottom = pRect->top  + szDlg.cy;

	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	SetControlSize(hDlg);
	return TRUE;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
static	VO		SetControlSize(HWND hDlg)
{
	RECT	r;
	int		w, h;

	GetClientRect(hDlg, &r);
	w = r.right - r.left;
	h = r.bottom - r.top;
	MoveWindow(hWndG3d, rcG3d.left, rcG3d.top, w - rcG3d.left - 4, h - rcG3d.top  - 4, FALSE);
	InvalidateRect(hDlg, NULL, TRUE);
}
//----- 「視点設定」ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_VIEWPOINT	)
{
	AjcG3dSetAngleV(hWndG3d, &vh);
	return TRUE;
}
//----- 「？」ボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HELP		)
{
	AjcTipTextShowCenter(hDlg, TipMsg, 10000, NULL);
	return TRUE;
}
//----- ３Ｄグラフコントロール ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_3DGRAPH		)
{
	switch (HIWORD(wParam)) {
		case AJC3DGN_PLOTLIST:							//	●プロットリスト通知
		{	PCAJC3DGPLOTLIST	p  = (PCAJC3DGPLOTLIST)lParam;
			UI					id = 1;
			UI					i;
			AJC3DVEC			vc, v;
			double				r;
			AJC3DCIRINFO		cif;
			//	プロット点をバッファへ格納
			memcpy(&Points[Ix], &p->lst[0].vec, sizeof Points[Ix]);
			Ix = (Ix + 1) % 3;
			if (Count < 3) Count++;
			//	プロット点表示
			AjcG3dClearShape(hWndG3d, id);
			for (i = 0; i < Count; i++) {
				AjcG3dPixelV(hWndG3d, id, &Points[i], 3);
			}
			//	３点が揃ったら平面円と法線表示
			if (Count >= 3) {
				AjcEnableDlgItem(hDlg, IDC_CMD_VIEWPOINT, TRUE);
				r = AjcV3dCalcCircleVEx(&Points[Ix], &Points[(Ix + 1) % 3], &Points[(Ix + 2) % 3], &vc, &vh, &cif);
				AjcG3dDefPlaneV(hWndG3d, id, &cif.lvc, NULL);
				AjcG2dEllipse  (hWndG3d, id, 0, 0, cif.cr, cif.cr);
				AjcG2dPixel    (hWndG3d, id, 0, 0, 3);
				AjcV3dNormal   (&vh, &v);
				AjcV3dMult	   (&v, 0.5, &v);
				AjcV3dAdd	   (&v, &vc, &v);
				AjcG3dArrowV   (hWndG3d, id, &vc, &v);
			}
			break;
		}
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_SIZING	 	   )
	AJC_DLGMAP_MSG(Main, WM_SIZE	 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_VIEWPOINT )
	AJC_DLGMAP_CMD(Main, IDC_CMD_HELP	   )
	AJC_DLGMAP_CMD(Main, IDC_3DGRAPH	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

