﻿//
//	SW_ComboBox.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define		MYSECT		TEXT("SW_ComboBox")
#define		MAX_LEN		64
//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
int				ixLast; 						//	コンボボックス直前の選択項目

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- プロファイルをレジストリとする場合は、以下の行のコメントを解除します -----//
	// AjcSetProfileIsRegistory(TRUE);

	//----- メイン・ダイアログオープン -----------------------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------------------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	//	コンボボックスをグループボックスの前面に移動（Ｄ＆Ｄ可能とするため、Ｚオーダー設定）
	SetWindowPos( GetDlgItem(hDlg, IDC_GRP_CBO), GetDlgItem(hDlg, IDC_CBO_SORT	), 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	SetWindowPos( GetDlgItem(hDlg, IDC_GRP_CBO), GetDlgItem(hDlg, IDC_CBO_NOSORT), 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	//	最大テキスト長設定
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_ADD   , MAX_LEN -1 );
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_INS   , MAX_LEN -1 );
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_FIND  , MAX_LEN -1 );
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_FINDEX, MAX_LEN -1 );
	//	コンボボックスをサブクラス化
	AjcSbcComboBox (GetDlgItem(hDlg, IDC_CBO_SORT  ), 10, MAX_LEN - 1);
	AjcSbcTipCtrl  (GetDlgItem(hDlg, IDC_CBO_SORT  ), TRUE);
	AjcSbcComboBox (GetDlgItem(hDlg, IDC_CBO_NOSORT), 10, MAX_LEN - 1);
	AjcSbcTipCtrl  (GetDlgItem(hDlg, IDC_CBO_NOSORT), TRUE);
	//	ダイアログ項目初期化
	AjcSetDlgItemChk(hDlg, IDC_RBT_SORT 	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_DESTINGUISH, TRUE);
	//	コンボボックスのリスト項目群を含めるように設定
	AjcDlgItemSetPermAtt (hDlg, IDC_CBO_SORT  , AJCCTL_PSEL_INCLIST);
	AjcDlgItemSetPermAtt (hDlg, IDC_CBO_NOSORT, AJCCTL_PSEL_INCLIST);
	//	ダイアログ項目のロード
	AjcLoadAllControlSettings (hDlg, MYSECT, AJCOPT2(AJCCTL_SELACT_, ALL, NTCRBT));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	ダイアログ項目のセーブ
	AjcSaveAllControlSettings(hDlg);
	//	プログラム終了
	PostQuitMessage(0);

	return TRUE;
}
//----- コンボボックスからの通知(SORT) -------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_SORT			)
{
	switch (HIWORD(wParam)) {
		case CBN_SELENDOK:										//	●項目選択
			AjcSbcSetMostNew(GetDlgItem(hDlg, IDC_CBO_SORT));	//		選択された項目を最新項目とする
			break;
		case AJCCBN_REMOVED:									//	●削除通知
		{	UT		str[AJCSBC_MAXSTL];
			UT		txt[16384];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- Removed --\n"));
			while (AjcSbcGetRemovedItem(GetDlgItem(hDlg, IDC_CBO_SORT), str, AJCTSIZE(str))) {
				MAjcStrCat(txt, AJCTSIZE(txt), str);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hDlg, txt, TEXT("Removed Items in Sort"), MB_OK);
			break;
		}
	}
	return TRUE;
}
//----- コンボボックスからの通知(NOSORT) -----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_NOSORT		)
{
	switch (HIWORD(wParam)) {
		case CBN_SELENDOK:										//	●項目選択
			AjcSbcSetMostNew(GetDlgItem(hDlg, IDC_CBO_NOSORT));	//		選択された項目を最新項目とする
			break;
		case AJCCBN_REMOVED:									//	●削除通知
		{	UT		str[AJCSBC_MAXSTL];
			UT		txt[16384];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("-- Removed --\n"));
			while (AjcSbcGetRemovedItem(GetDlgItem(hDlg, IDC_CBO_NOSORT), str, sizeof str)) {
				MAjcStrCat(txt, AJCTSIZE(txt), str);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			MessageBox(hDlg, txt, TEXT("Removed Items in NoSort"), MB_OK);
			break;
		}
	}
	return TRUE;
}
//----- コンボボックス（ソートあり）を選択 ---------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_SORT		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcEnableDlgItem(hDlg, IDC_CBO_SORT  , TRUE);
		AjcEnableDlgItem(hDlg, IDC_CBO_NOSORT, FALSE);
	}
	return TRUE;
}
//----- コンボボックス（ソートなし）を選択 ---------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_NOSORT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcEnableDlgItem(hDlg, IDC_CBO_SORT  , FALSE);
		AjcEnableDlgItem(hDlg, IDC_CBO_NOSORT, TRUE);
	}
	return TRUE;
}
//----- 項目追加 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ADD		)
{
	UT		txt[MAX_LEN];

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_ADD, txt, 256);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_ADDSTRING, 0, (LPARAM)txt);
		else									  SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_ADDSTRING, 0, (LPARAM)txt);
	}
	return TRUE;
}
//----- 項目挿入 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INS		)
{
	UT		txt[MAX_LEN];
	int		ix;

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_INS, txt, 256);
		ix = AjcGetDlgItemSInt(hDlg, IDC_TXT_INS_IX);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_INSERTSTRING, ix, (LPARAM)txt);
		else									  SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_INSERTSTRING, ix, (LPARAM)txt);
	}
	return TRUE;
}
//----- 項目削除 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DEL		)
{
	int		ix;

	if (HIWORD(wParam) == BN_CLICKED) {
		ix = AjcGetDlgItemSInt(hDlg, IDC_TXT_DEL_IX);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_DELETESTRING, ix, 0);
		else									  SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_DELETESTRING, ix, 0);
	}
	return TRUE;
}
//----- 全項目削除 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RESET		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_RESETCONTENT, 0, 0);
		else									  SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_RESETCONTENT, 0, 0);
	}
	return TRUE;
}
//----- 前部検索 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FIND		)
{
	UT		txt[MAX_LEN];
	int		ix;

	if (HIWORD(wParam) == BN_CLICKED) {
		ix = AjcGetDlgItemSInt(hDlg, IDC_TXT_FIND_IX);
		AjcGetDlgItemStr(hDlg, IDC_TXT_FIND, txt, sizeof txt);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) ix = (int)SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_FINDSTRING, ix, (LPARAM)txt);
		else									  ix = (int)SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_FINDSTRING, ix, (LPARAM)txt);
		AjcSetDlgItemSInt(hDlg, IDC_TXT_FIND_IX2, ix);
	}
	return TRUE;
}
//----- 全体検索 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_FINDEX	)
{
	UT		txt[MAX_LEN];
	int		ix;

	if (HIWORD(wParam) == BN_CLICKED) {
		ix = AjcGetDlgItemSInt(hDlg, IDC_TXT_FINDEX_IX);
		AjcGetDlgItemStr(hDlg, IDC_TXT_FINDEX, txt, sizeof txt);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) ix = (int)SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_FINDSTRINGEXACT, ix, (LPARAM)txt);
		else									  ix = (int)SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_FINDSTRINGEXACT, ix, (LPARAM)txt);
		AjcSetDlgItemSInt(hDlg, IDC_TXT_FINDEX_IX2, ix);
	}
	return TRUE;
}
//----- 項目読み出し -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETTEXT	)
{
	UT		txt[MAX_LEN] = TEXT("NotRead");
	int		ix;

	if (HIWORD(wParam) == BN_CLICKED) {
		ix = AjcGetDlgItemSInt(hDlg, IDC_TXT_GETTEXT_IX);
		if (AjcGetDlgItemChk(hDlg, IDC_RBT_SORT)) SendDlgItemMessage(hDlg, IDC_CBO_SORT  , CB_GETLBTEXT, ix, (LPARAM)txt);
		else									  SendDlgItemMessage(hDlg, IDC_CBO_NOSORT, CB_GETLBTEXT, ix, (LPARAM)txt);
		AjcSetDlgItemStr(hDlg, IDC_TXT_GETTEXT, txt);
	}
	return TRUE;
}
//----- 文字大小区別あり ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_DESTINGUISH)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_SORT  ), TRUE);
		AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_NOSORT), TRUE);
	}
	return TRUE;
}
//----- 文字大小区別なし ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_NODESTINGUISH)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_SORT  ), FALSE);
		AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_NOSORT), FALSE);
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		   )
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG			)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 			)

	AJC_DLGMAP_CMD(Main, IDC_CBO_SORT			)
	AJC_DLGMAP_CMD(Main, IDC_CBO_NOSORT			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_SORT			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_NOSORT			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_ADD			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_INS			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_RESET			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FIND			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_FINDEX			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETTEXT		)
	AJC_DLGMAP_CMD(Main, IDC_RBT_DESTINGUISH	)
	AJC_DLGMAP_CMD(Main, IDC_RBT_NODESTINGUISH	)
	AJC_DLGMAP_CMD(Main, IDCANCEL				)
AJC_DLGMAP_END


