﻿//
//	SW_ConIO.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<conio.h>
#include	<time.h>
#include	<tchar.h>
#include	<process.h>
#include	"..\src\resource.h"

#define		MYSECT	TEXT("Main")

typedef  struct {
	SIZE		szBuf;
	RECT		rect;
	SIZE		szMax;
} CONBUFINFO, *PCONBUFINFO;

typedef	struct	{
	COLORREF	ForeColor;
	COLORREF	BackColor;
} CONCOLOR, *PCONCOLOR;

typedef	struct	{
	UI			ForeColor;
	UI			BackColor;
} CON16COLOR, *PCON16COLOR;

typedef struct {
	UI			ix;
	COLORREF	color;
} IXCOLOR, *PIXCOLOR;

														//								msg.wParam				msg.lParam
#define		MSG_GetConsoleScreenBufferInfo	WM_APP+10	//	情報取得					－					PCONBUFINFO
#define		MSG_etConsoleMaxWndSize			WM_APP+11	//	ウインド最大サイズ取得		－					LPSIZE

#define		MSG_SetConsoleBufSize			WM_APP+12	//	バッファサイズ設定			－					LPSIZE
#define		MSG_GetConsoleBufSize			WM_APP+13	//	バッファサイズ取得			－					LPSIZE

#define		MSG_SetConsoleWndRect			WM_APP+14	//	ウインド矩形設定			－					LPRECT
#define		MSG_GetConsoleWndRect			WM_APP+15	//	ウインド矩形取得			－					LPRECT

#define		MSG_SetConsoleColor				WM_APP+16	//	表示色設定					－					COLORREF*
#define		MSG_SetConsole16Color			WM_APP+17	//	表示パレット番号設定		－					UI

#define		MSG_GetConsoleColor				WM_APP+18	//	表示色取得					－					PCONCOLOR
#define		MSG_GetConsoleForeColor			WM_APP+19	//	文字色取得					－					COLORREF*
#define		MSG_GetConsoleBackColor			WM_APP+20	//	背景色取得					－					COLORREF*

#define		MSG_GetConsole16Color			WM_APP+21	//	表示１６色取得				－					PCON16COLOR
#define		MSG_GetConsoleFore16Color		WM_APP+22	//	文字１６色取得				－					UIP
#define		MSG_GetConsoleBack16Color		WM_APP+23	//	背景１６色取得				－					UIP

#define		MSG_SelConsolePalette			WM_APP+24	//	表示パレット番号選択		－					PCON16COLOR

#define		MSG_SetConsolePalette			WM_APP+25	//	表示パレットの色設定（全色）－					COLORREF[16]
#define		MSG_SetConsolePalByIx			WM_APP+26	//	表示パレットの色設定（１色）－					PIXCOLOR

#define		MSG_GetConsolePalette			WM_APP+27	//	表示パレットの色取得（全色）－					COLORREF[16]
#define		MSG_GetConsolePalByIx			WM_APP+28	//	表示パレットの色取得（１色）－					UI

#define		MSG_SetConsoleCursor			WM_APP+29	//	カーソル位置設定			－					LPPOINT
#define		MSG_GetConsoleCursor			WM_APP+30	//	カーソル位置取得			－					LPPOINT

#define		MSG_Print						WM_APP+31	//	文字列描画					－					UTP

#define		MSG_Exit						WM_APP+99	//	終了

static	UI			MainThreadId	= 0;			//	メインスレッドＩＤ
static	UI			SubThreadId		= 0;			//	サブスレッドＩＤ
static	HANDLE		hSubThread		= NULL;			//	サブスレッドハンドル

static	HWND		hDlgMain;

static	UI WINAPI SubThread(VOP pArg);


//==============================================================================================================//
//	main																										//
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	MSG		msg;

	//	メインスレッドＩＤ設定
	MainThreadId = GetCurrentThreadId();

	//	サブスレッド生成
	hSubThread = (HANDLE)_beginthreadex(NULL,					//	セキュリティ
										  0,					//	スタックサイズ
										  SubThread,			//	スレッド関数
										  NULL,					//	スレッド引数
										  0,					//	スレッド初期フラグ
										  &SubThreadId);		//	スレッド識別子

	//	スレッドメッセージループ
	while (GetMessage(&msg, (HWND)-1, 0, 0) && msg.message != MSG_Exit) {
		switch (msg.message) {
		case MSG_GetConsoleScreenBufferInfo:	//	情報取得					－					PCONBUFINFO
		{	PCONBUFINFO p = (PCONBUFINFO)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleScreenBufferInfo(&p->szBuf, &p->rect, &p->szMax);
			break;
		}
		case MSG_etConsoleMaxWndSize:			//	ウインド最大サイズ取得		－					LPSIZE
		{
			LPSIZE p = (LPSIZE)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleMaxWndSize(&p->cx, &p->cy);
			break;
		}
		case MSG_SetConsoleBufSize:				//	バッファサイズ設定			－					LPSIZE
		{	
			LPSIZE p = (LPSIZE)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsoleBufSize(p->cx, p->cy);
			break;
		}
		case MSG_GetConsoleBufSize:				//	バッファサイズ取得			－					LPSIZE
		{	
			LPSIZE p = (LPSIZE)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleBufSize(&p->cx, &p->cy);
			break;
		}
		case MSG_SetConsoleWndRect:				//	ウインド矩形設定			－					LPRECT
		{
			LPRECT p = (LPRECT)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsoleWndRect(p->left, p->top, p->right, p->bottom);
			break;
		}
		case MSG_GetConsoleWndRect:				//	ウインド矩形取得			－					LPRECT
		{
			LPRECT p = (LPRECT)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleWndRect(&p->left, &p->top, &p->right, &p->bottom);
			break;
		}
		case MSG_SetConsoleColor:				//	表示色設定					－					PCONCOLOR
		{
			PCONCOLOR p = (PCONCOLOR)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsoleColor(p->ForeColor, p->BackColor);
			break;
		}
		case MSG_SetConsole16Color:				//	表示１６色設定				－					PCONCOLOR16
		{
			PCON16COLOR p = (PCON16COLOR)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsole16Color(p->ForeColor, p->BackColor);
			break;
		}
		case MSG_GetConsoleColor:				//	表示色取得					－					PCONCOLOR
		{
			PCONCOLOR p = (PCONCOLOR)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleColor(&p->ForeColor, &p->BackColor);
			break;
		}
		case MSG_GetConsoleForeColor:			//	文字色取得					－					COLORREF*
		{
			COLORREF *p = (COLORREF*)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleForeColor();
			break;
		}
		case MSG_GetConsoleBackColor:			//	背景色取得					－					COLORREF*
		{
			COLORREF *p = (COLORREF*)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleBackColor();
			break;
		}
		case MSG_GetConsole16Color:				//	表示１６色取得				－					PCON16COLOR
		{	
			PCON16COLOR p = (PCON16COLOR)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsole16Color(&p->ForeColor, &p->BackColor);
			break;
		}
		case MSG_GetConsoleFore16Color:			//	文字１６色取得				－					UIP
		{
			UIP		p = (UIP)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleFore16Color();
			break;
		}
		case MSG_GetConsoleBack16Color:			//	背景１６色取得				－					UIP
		{
			UIP		p = (UIP)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleBack16Color();
			break;
		}
		case MSG_SelConsolePalette:				//	表示パレット番号選択		－					PCON16COLOR
		{
			PCON16COLOR p = (PCON16COLOR)msg.lParam;
			*((int*)msg.wParam) = AjcSelConsolePalette(p->ForeColor, p->BackColor);
			break;
		}
		case MSG_SetConsolePalette:				//	表示パレットの色設定（全色）－					COLORREF[16]
		{
			COLORREF *p = (COLORREF*)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsolePalette(p);
		}
		case MSG_SetConsolePalByIx:				//	表示パレットの色設定（１色）－					PIXCOLOR
		{
			PIXCOLOR p = (PIXCOLOR)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsolePalByIx(p->ix, p->color);
			break;
		}
		case MSG_GetConsolePalette:				//	表示パレットの色取得（全色）－					COLORREF[16]
		{
			COLORREF *p = (COLORREF*)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsolePalette(p);
			break;
		}
		case MSG_GetConsolePalByIx:				//	表示パレットの色取得（１色）－					UI
		{
			*((int*)msg.wParam) = AjcGetConsolePalByIx((UI)msg.lParam);
			break;
		}
		case MSG_SetConsoleCursor:				//	カーソル位置設定			－					LPPOINT
		{
			LPPOINT	p = (LPPOINT)msg.lParam;
			*((int*)msg.wParam) = AjcSetConsoleCursor(p->x, p->y);
			break;
		}
		case MSG_GetConsoleCursor:				//	カーソル位置取得			－					LPPOINT
		{
			LPPOINT	p = (LPPOINT)msg.lParam;
			*((int*)msg.wParam) = AjcGetConsoleCursor((int*)&p->x, (int*)&p->y);
		}
		case MSG_Print:							//	文字列描画					－					UTP
			AjcPrintF((UTP)msg.lParam);
			break;
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	サブスレッド																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	UI WINAPI SubThread(VOP pArg)
{
	MSG 	msg;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog((HINSTANCE)GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	PostThreadMessage(MainThreadId, MSG_Exit, 0, 0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	AjcLoadWndPos(hDlg, MYSECT);
	AjcLoadAllControlSettings (hDlg, MYSECT, AJCCTL_SELACT_NTCINP);
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcSaveWndPos(hDlg, MYSECT);
	AjcSaveAllControlSettings(hDlg);
	PostQuitMessage(0);
	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	int		id = LOWORD(wParam);
	HWND	hInp = NULL;

	if (id == IDC_INP_SET_SET_FORE_RGB || id == IDC_INP_SET_SET_BACK_RGB || id == IDC_INP_SET_COLOR ||
		(id >= IDC_INP_GET_C0 && id <= IDC_INP_GET_C15)) {
		if (HIWORD(wParam) == AJCIVN_INTVALUE) {
			hInp = GetDlgItem(hDlg, id);
			AjcIvSetBorderColor(hInp, (COLORREF)AjcGetCtrlUInt(hInp));
		}
	}

	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- コンソールバッファサイズ設定 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsoleBufSize			)
{
	return TRUE;
}
//----- コンソールウインド矩形設定 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsoleWndRect			)
{
	return TRUE;
}
//----- コンソール表示色設定（フルカラー）----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsoleColor			)
{
	return TRUE;
}
//----- コンソール表示パレット選択 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SelConsolePalette			)
{
	return TRUE;
}
//----- コンソール表示色 ( Palette# ) 設定（１６色）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsole16Color			)
{
	return TRUE;
}
//----- コンソール表示パレット色設定（全色）--------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsolePalette			)
{
	return TRUE;
}
//----- コンソール表示パレット色設定（１色）--------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsolePalByIx			)
{
	AjcSetConsoleCursor(10, 10);
	return TRUE;
}
//----- カーソル位置設定 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SetConsoleCursor			)
{
	AjcSetConsoleCursor(AjcGetDlgItemUInt(hDlg, IDC_TXT_SET_POS_X), AjcGetDlgItemUInt(hDlg, IDC_TXT_SET_POS_Y));
	return TRUE;
}
//----- 文字列描画 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_Print						)
{
	return TRUE;
}

//----- コンソール情報取得 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleScreenBufferInfo)
{
	return TRUE;
}
//----- コンソールウインド最大サイズ取得 -----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleMaxWndSize		)
{
	return TRUE;
}
//----- コンソールバッファサイズ取得 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleBufSize			)
{
	return TRUE;
}
//----- コンソールウインド矩形取得 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleWndRect			)
{
	return TRUE;
}
//----- コンソール表示色取得（フルカラー）----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleColor			)
{
	return TRUE;
}
//----- コンソール文字色取得（フルカラー）----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleForeColor		)
{
	return TRUE;
}
//----- コンソール背景色取得（フルカラー）----------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleBackColor		)
{
	return TRUE;
}
//----- コンソール表示色 ( Palette# ) 取得（１６色）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsole16Color			)
{
	return TRUE;
}
//----- コンソール文字色 ( Palette# ) 取得（１６色）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleFore16Color		)
{
	return TRUE;
}
//----- コンソール背景色 ( Palette# ) 取得（１６色）------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleBack16Color		)
{
	return TRUE;
}
//----- コンソール表示パレット色取得（１６色）------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsolePalette			)
{
	return TRUE;
}
//----- コンソール表示パレット色取得（１色）--------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsolePalByIx			)
{
	return TRUE;
}
//----- カーソル位置取得 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GetConsoleCursor			)
{
	return TRUE;
}
//----- 取得情報クリアー ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLEAR_GET					)
{
	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG						)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 						)
	AJC_DLGMAP_MSG(Main, WM_COMMAND							)

	AJC_DLGMAP_CMD(Main, IDCANCEL							)

	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsoleBufSize			)	//	コンソールバッファサイズ設定
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsoleWndRect			)	//	コンソールウインド矩形設定
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsoleColor			)	//	コンソール表示色設定（フルカラー）
	AJC_DLGMAP_CMD(Main, IDC_CMD_SelConsolePalette			)	//	コンソール表示パレット選択
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsole16Color			)	//	コンソール表示色 ( Palette# ) 設定（１６色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsolePalette			)	//	コンソール表示パレット色設定（全色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsolePalByIx			)	//	コンソール表示パレット色設定（１色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_SetConsoleCursor			)	//	カーソル位置設定
	AJC_DLGMAP_CMD(Main, IDC_CMD_Print						)	//	文字列描画

	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleScreenBufferInfo	)	//	コンソール情報取得
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleMaxWndSize		)	//	コンソールウインド最大サイズ取得
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleBufSize			)	//	コンソールバッファサイズ取得
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleWndRect			)	//	コンソールウインド矩形取得
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleColor			)	//	コンソール表示色取得（フルカラー）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleForeColor		)	//	コンソール文字色取得（フルカラー）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleBackColor		)	//	コンソール背景色取得（フルカラー）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsole16Color			)	//	コンソール表示色 ( Palette# ) 取得（１６色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleFore16Color		)	//	コンソール文字色 ( Palette# ) 取得（１６色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleBack16Color		)	//	コンソール背景色 ( Palette# ) 取得（１６色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsolePalette			)	//	コンソール表示パレット色取得（１６色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsolePalByIx			)	//	コンソール表示パレット色取得（１色）
	AJC_DLGMAP_CMD(Main, IDC_CMD_GetConsoleCursor			)	//	カーソル位置取得
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLEAR_GET					)	//	取得情報クリアー
AJC_DLGMAP_END

