﻿//
//	SW_ConInpC.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	<conio.h>

#define	MAX_BUFLEN	(64 / sizeof(UT))

//----- ユーザヘルプ -------------------------------------------------------------------------------------------//
static	UT		szMyHelp[] = TEXT("\n")
							 TEXT(" F2キーでユーザ指定のヘルプを表示します。\n")
							 TEXT(" F1キーでオリジナルの操作ヘルプを表示します。\n")
							 TEXT("");

//----- コンソール入力のコールバック ---------------------------------------------------------------------------//
static VO	CALLBACK cbNtcArgs(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	int		i;

	AjcPrintF(TEXT("入力テキスト=\"%s\"\n"), pTxt);
	for (i = 0; i < argc; i++) {
		AjcPrintF(TEXT("Arg %02d : %s\n"), i + 1, argv[i]);
	}
}
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	UT		buf[MAX_BUFLEN] = TEXT("東京都 港区 赤坂 1-23-456");

	AjcSetStdoutMode();				//	標準出力モード設定

	//	標準出力，標準エラーのモード設定
	AjcSetStdMode(AJCTEC_MBC, FALSE);

	//----- コマンド引数がある場合は、コマンド引数を表示 -------------------------------------------//
	if (argc >= 2) {
		AjcPrintF(TEXT("\nコマンド引数\n\n"));
		cbNtcArgs(argc - 1, &argv[1], GetCommandLine(), 0);
	}
	//----- コマンド引数が無い場合は、コンソールから入力して表示 -----------------------------------//
	else {
		//	コンソール入力
		AjcPrintF(TEXT("\n\n文字列を入力してください\n\n "));
		if (AjcConInputEx(buf,					//	初期表示文字列（不要時はNULL）
						  20,					//	入力フィールド長
						  buf,					//	入力文字格納バッファのアドレス（初期表示文字列と重複可）
						  AJCTSIZE(buf),		//	入力文字格納バッファのバイト数／文字数（２以上）
						  AJCCIN_ALL,			//	オプションフラグ(AJCCIN_XXXXX)
						  -1,					//	入力域のテキスト色（-1 ：デフォルト色）
						  AJCCI_16(0x1),		//	入力域の背景色　　（Bit3-0 = IRGB）
						  szMyHelp,				//	F2キー押下時に表示するヘルプテキスト（NULL: F2ヘルプ非表示）
						  0,					//	コールバックパラメタ
						  cbNtcArgs)) {			//	入力テキストの通知用コールバック（未使用時はNULL）

		}
		else {
			AjcPrintF(TEXT("\nキャンセルされました\n"));
		}
	}
	AjcPrintF(TEXT("\n\nHit ENTER key!!"));
	getchar();

	return 0;
}

