﻿//
//	SW_DibSect.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define RGB_WHITE	RGB(255, 255, 255)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HBITMAP 		hBmpOrg, hBmpCor, hBmpExc, hBmpSel;
static	AJCDIBINFO		DbifOrg, DbifCor, DbifExc, DbifSel;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static VO ShowPic(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 		)
{
	UT		path[MAX_PATH];

	hDlgMain = hDlg;

	//----- 原画表示 --------------------------------//
	AjcGetAppPath(path, MAX_PATH);
	MAjcStrCat(path, AJCTSIZE(path), TEXT("SW_DibSect.bmp"));
	hBmpOrg = AjcDibReadFileAndCreate(path, &DbifOrg);
	SendDlgItemMessage(hDlg, IDC_PIC_ORG, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpOrg);

	//----- ＤＩＢセクション生成 --------------------//
	hBmpCor = AjcDibCreate(DbifOrg.width, DbifOrg.height, DbifOrg.BitCount, &DbifCor);
	hBmpExc = AjcDibCreate(DbifOrg.width, DbifOrg.height, DbifOrg.BitCount, &DbifExc);
	hBmpSel = AjcDibCreate(DbifOrg.width, DbifOrg.height, DbifOrg.BitCount, &DbifSel);

	//----- ダイアログ項目の設定値ロード ------------//
	AjcLoadAllControlSettings (hDlg, TEXT("Values"), AJCCTL_SELACT_ALL);

	//----- 各ピクチャ表示 --------------------------//
	ShowPic();

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY			)
{
	//----- DIBitmap削除 ----------------------------//
	DeleteObject(hBmpCor);
	DeleteObject(hBmpExc);
	DeleteObject(hBmpSel);
	//----- ダイアログ項目のセーブ ------------------//
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 --------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		   )
{
	int 	id	= LOWORD(wParam);
	int 	cmd = HIWORD(wParam);

	if ((cmd == AJCIVN_INTVALUE  && (id == IDC_INP_COR_R || id == IDC_INP_COR_G || id == IDC_INP_COR_B ||
									 id == IDC_INP_EXC_R || id == IDC_INP_EXC_G || id == IDC_INP_EXC_B))  ||
		(cmd == AJCIVN_REALVALUE && (id == IDC_INP_COR_LEN || id == IDC_INP_EXC_LEN))) {

		ShowPic();
	}

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL				)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG )
	AJC_DLGMAP_MSG(Main, WM_DESTROY    )
	AJC_DLGMAP_MSG(Main, WM_COMMAND    )
	AJC_DLGMAP_CMD(Main, IDCANCEL	   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	各ピクチャ表示																								//
//--------------------------------------------------------------------------------------------------------------//
static VO ShowPic(VO)
{
	//----- 設定値取得 -----------------------------------------------------------//
	COLORREF	RgbCor = RGB(AjcGetDlgItemUInt(hDlgMain, IDC_INP_COR_R),
							 AjcGetDlgItemUInt(hDlgMain, IDC_INP_COR_G),
							 AjcGetDlgItemUInt(hDlgMain, IDC_INP_COR_B));

	COLORREF	RgbExc = RGB(AjcGetDlgItemUInt(hDlgMain, IDC_INP_EXC_R),
							 AjcGetDlgItemUInt(hDlgMain, IDC_INP_EXC_G),
							 AjcGetDlgItemUInt(hDlgMain, IDC_INP_EXC_B));

	double		LenCor = AjcGetDlgItemReal(hDlgMain, IDC_INP_COR_LEN);
	double		LenExc = AjcGetDlgItemReal(hDlgMain, IDC_INP_EXC_LEN);

	//----- 各ピクチャ・クリアー -------------------------------------------------//
	AjcDibClear(&DbifCor, RGB_WHITE);
	AjcDibClear(&DbifExc, RGB_WHITE);
	AjcDibClear(&DbifSel, RGB_WHITE);

	//----- 各ピクチャへ原画から色を選択／除外してコピー -------------------------//
	AjcDibCorrectedCopy(&DbifCor, 0, 0, 0, 0, &DbifOrg, 0, 0, RgbCor, LenCor);
	AjcDibExcludedCopy (&DbifExc, 0, 0, 0, 0, &DbifOrg, 0, 0, RgbExc, LenExc);
	AjcDibSelectedCopy (&DbifSel, 0, 0, 0, 0, &DbifOrg, 0, 0, 2, 
							AJCDIBOPE_CORRECT, RgbCor, LenCor,
							AJCDIBOPE_EXCLUDE, RgbExc, LenExc);

	//----- 各ピクチャへ表示 -----------------------------------------------------//
	SendDlgItemMessage(hDlgMain, IDC_PIC_COR, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpCor);
	SendDlgItemMessage(hDlgMain, IDC_PIC_EXC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpExc);
	SendDlgItemMessage(hDlgMain, IDC_PIC_SEL, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpSel);
}
