﻿//
//	SW_DlgItem1.c
//
#include	<AjrCstXX.h>
#include	<Shlwapi.h>
#include	<stdio.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hDlgData;						//	サブダイアログハンドル
static	HWND			hVthLog;						//	ログウインド
static	HICON			hIcoOpen;
static	HICON			hIcoDel;
static	BOOL			fLoad	 = FALSE;				//	ロード処理中を示すフラグ
static	UT				MySect[] = _T("Settings");		//	自プログラム設定値退避用セクション

//--------------------------------------------------------------------------------------------------------------//
//	キープリフィックス																							//
//--------------------------------------------------------------------------------------------------------------//
static	C_UTP	szPrefix[] = {TEXT("Edt"), TEXT("Chk"), TEXT("Rbt"), TEXT("Cbo"), TEXT("Lst"), TEXT("Inp"), TEXT("Lbx"), TEXT("Vth"), TEXT("Tch")};
enum						 {	PFX_EDT  ,	 PFX_CHK  ,   PFX_RBT  ,   PFX_CBO	,	PFX_LST  ,	 PFX_INP  ,   PFX_LBX  ,   PFX_VTH	,	PFX_TCH  };

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_DLGPROC_DEF(Data);
static	UI				SetPermOpt(VO);
static	C_UTP CALLBACK	cbGetTipText(HWND hCtrl, UTP pBuf, UI lBuf, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
#define		TTP(ID)	AjcTipTextAdd		 (GetDlgItem(hDlg, IDC_CHK_##ID), TEXT(""));			\
					AjcTipTextSetCallBack(GetDlgItem(hDlg, IDC_CHK_##ID), 0, NULL, cbChkTool);

C_UTP CALLBACK cbChkTool(HWND hCtrl, UTP pBuf, UI lBuf, UX cbp)
{
	UT		txt[64];

	GetWindowText(hCtrl, txt, AJCTSIZE(txt));
	if		(MAjcStrCmp(txt, TEXT("INCLUDE"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("このコントロールを永続化対象に含める"));
	else if (MAjcStrCmp(txt, TEXT("EXCLUDE"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("このコントロールを永続化対象から除外する"));
	else if (MAjcStrCmp(txt, TEXT("INCRDONLY")) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("読み出し専用テキストを永続化する"));
	else if (MAjcStrCmp(txt, TEXT("INCDATA"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("リスト項目群に関連付けられたデータも永続化する"));
	else if (MAjcStrCmp(txt, TEXT("INCLIST"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("リスト項目群を永続化する"));
	else if (MAjcStrCmp(txt, TEXT("EXCSEL"	 )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("項目の選択情報を永続化しない"));
	else if (MAjcStrCmp(txt, TEXT("EXCLIST"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("リスト項目群を永続化しない"));
	else if (MAjcStrCmp(txt, TEXT("EXCEDIT"  )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("エディットテキストの内容を永続化しない"));
	else if (MAjcStrCmp(txt, TEXT("NTC" 	 )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("チェックボックス/ラジオボタン読出し時にイベント(BN_CLICKED)を通知する"));
	else if (MAjcStrCmp(txt, TEXT("NONTC"	 )) == 0) MAjcStrCpy(pBuf, lBuf, TEXT("チェックボックス/ラジオボタン読出し時にイベント(BN_CLICKED)を通知しない"));
	return pBuf;
}
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	RECT	r;
	UT		txt[AJCMAX_REGPATH];

	hVthLog = GetDlgItem(hDlg, IDC_VTH_LOG);

	//	アイコン生成
	hIcoOpen  = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICO_OPEN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoDel   = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICO_DEL ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	//	ボタンへアイコン表示
	SendDlgItemMessage(hDlg, IDC_CMD_OPEN, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoOpen);
	SendDlgItemMessage(hDlg, IDC_CMD_DEL , BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoDel );
	//	ＩＮＩファイルパス表示
	AjcGetIniFilePath(txt, AJCTSIZE(txt));
	AjcSetDlgItemStr (hDlg, IDC_TXT_INIPATH, txt);
	//	ダイアログ項目のデフォルト設定
	AjcSetDlgItemChk(hDlg, IDC_RBT_SELACT_ALL, TRUE);
	//	ダイアログ項目のロード
	AjcLoadAllControlSettings(hDlg, TEXT("MainDialogItems"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);
	//	サブダイアログ生成
	CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGDATA), hDlg, AJC_DLGPROC_NAME(Data));
	GetWindowRect  (GetDlgItem(hDlg, IDC_LBL_SUBDLG), &r);
	MapWindowPoints(NULL, hDlg, (LPPOINT)&r, 2);
	SetWindowPos(hDlgData, NULL, r.left, r.top, 0, 0, SWP_NOSIZE);
	ShowWindow(hDlgData, SW_SHOW);
	//	ツールチップ設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_OPEN 			), TEXT("INIファイルを開く"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_DEL				), TEXT("INIファイルをクリアーする"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_RBT_SELACT_ALL		), TEXT("全てのコントロールを対象とする"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_RBT_SELACT_CHKINCLUDE), TEXT("永続化対象(INCLUDE)としたコントロールのみを対象とする"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_RBT_SELACT_CHKEXCLUDE), TEXT("永続化除外(EXCLUDE)としたコントロールは除外する"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SELACT_NTCCHK	), TEXT("チェックボックスの読み出し時にBN_CLICKEDイベントを発生する"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SELACT_NTCRBT	), TEXT("ラジオボタンの読み出し時に、チェックされているラジオボタンにBN_CLICKEDイベントを発生する"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CHK_SELACT_NTCCBO	), TEXT("コンボボックスの読み出し時に、CBN_SELENDOKイベントを発生する"));

	TTP(EDT_INCLUDE);	TTP(EDT_EXCLUDE);
	TTP(RDO_INCLUDE);	TTP(RDO_EXCLUDE);	TTP(RDO_INCRDONLY);
	TTP(CHK_INCLUDE);	TTP(CHK_EXCLUDE);	TTP(CHK_NTC);		TTP(CHK_NONTC);
	TTP(RBT1_INCLUDE);	TTP(RBT1_EXCLUDE);	TTP(RBT1_NTC);		TTP(RBT1_NONTC);
	TTP(RBT2_INCLUDE);	TTP(RBT2_EXCLUDE);	TTP(RBT2_NTC);		TTP(RBT2_NONTC);
	TTP(DDN_INCLUDE);	TTP(DDN_EXCLUDE);	TTP(DDN_INCDATA);	TTP(DDN_INCLIST);	TTP(DDN_EXCLIST);	TTP(DDN_EXCSEL);	TTP(DDN_EXCEDIT);
	TTP(DDL_INCLUDE);	TTP(DDL_EXCLUDE);	TTP(DDL_INCDATA);	TTP(DDL_INCLIST);	TTP(DDL_EXCLIST);	TTP(DDL_EXCSEL);
	TTP(SBC_INCLUDE);	TTP(SBC_EXCLUDE);	TTP(SBC_INCDATA);	TTP(SBC_INCLIST);	TTP(SBC_EXCLIST);	TTP(SBC_EXCSEL);	TTP(SBC_EXCEDIT);
	TTP(LST_INCLUDE);	TTP(LST_EXCLUDE);	TTP(LST_INCDATA);	TTP(LST_EXCSEL);
	TTP(INP_INCLUDE);	TTP(INP_EXCLUDE);
	TTP(LBX_INCLUDE);	TTP(LBX_EXCLUDE);
	TTP(VTH_INCLUDE);	TTP(VTH_EXCLUDE);
	TTP(TCH_INCLUDE);	TTP(TCH_EXCLUDE);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{

	//	ダイアログ項目のセーブ
	AjcSaveAllControlSettings(hDlg);
	//	アイコン破棄
	if (hIcoOpen  != NULL) {DeleteObject(hIcoOpen); hIcoOpen = NULL;}
	if (hIcoDel   != NULL) {DeleteObject(hIcoDel ); hIcoDel  = NULL;}

	PostQuitMessage(0);

	return TRUE;
}
//----- INIファイルを開くボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	UT		path[MAX_PATH];
	AjcGetDlgItemStr(hDlg, IDC_TXT_INIPATH, path, MAX_PATH);
	ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
}
//----- INIファイルをクリアーボタン ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DEL		)
{
	HANDLE	hFile;
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	DeleteFile(path);
	if ((hFile = CreateFile(path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
		CloseHandle(hFile);
	}
	return TRUE;
}
//----- ラジオボタン（全てのコントロールを対象とする） ---------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_SELACT_ALL		)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_EXCLUDE, FALSE, FALSE);
	AjcEnableDlgGroup(hDlg, IDC_GRP_INCLUDE, FALSE, FALSE);
	return TRUE;
}
//----- ラジオボタン（永続化対象としたコントロールのみを対象とする） -------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_SELACT_CHKINCLUDE	)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_EXCLUDE, FALSE, FALSE);
	AjcEnableDlgGroup(hDlg, IDC_GRP_INCLUDE, TRUE , TRUE );
	return TRUE;
}
//----- ラジオボタン（永続化除外としたコントロールは除外する） -------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_SELACT_CHKEXCLUDE	)
{
	AjcEnableDlgGroup(hDlg, IDC_GRP_EXCLUDE, TRUE , TRUE );
	AjcEnableDlgGroup(hDlg, IDC_GRP_INCLUDE, FALSE, FALSE);
	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG				)
	AJC_DLGMAP_MSG(Main, WM_DESTROY					)

	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN				)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DEL				)
	AJC_DLGMAP_CMD(Main, IDC_RBT_SELACT_ALL			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_SELACT_CHKINCLUDE	)
	AJC_DLGMAP_CMD(Main, IDC_RBT_SELACT_CHKEXCLUDE	)
	AJC_DLGMAP_CMD(Main, IDCANCEL					)
AJC_DLGMAP_END
//==============================================================================================================//
//																												//
//	サブダイアログ・プロシージャ																				//
//																												//
//==============================================================================================================//
#define	TTP1(ID, PFX)																							\
 AjcTipTextAddEx	  (GetDlgItem(hDlg, ID), TEXT(""), 300, 5000, AjcGetStockFont(AJCFID_FIX12), -1, -1, -1);	\
 AjcTipTextSetCallBack(GetDlgItem(hDlg, ID), MAKELONG(ID, PFX), NULL, cbGetTipText)

#define	TTP2(ID, PFX)																													  \
 AjcTipTextAddEx	  (AjcSbcGetEditCtrlInComboBox(GetDlgItem(hDlg, ID)), TEXT(""), 300, 5000, AjcGetStockFont(AJCFID_FIX12), -1, -1, -1);\
 AjcTipTextSetCallBack(AjcSbcGetEditCtrlInComboBox(GetDlgItem(hDlg, ID)), MAKELONG(ID, PFX), NULL, cbGetTipText)

//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, WM_INITDIALOG 	)
{
	hDlgData = hDlg;

	//	IDC_CBO_SBC サブクラス化
	AjcSbcComboBox	   (GetDlgItem(hDlg, IDC_CBO_SBC), 10, 64);	//	サブクラス化
	AjcSbcSetCompExact (GetDlgItem(hDlg, IDC_CBO_SBC), TRUE);	//	英大小文字を区別
	AjcSbcTipCtrl	   (GetDlgItem(hDlg, IDC_CBO_SBC), TRUE);	//	選択中項目をチップ表示する

	//	全項目初期化
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_INIT, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_CLEAR));

	//	ツールチップテキスト設定
	TTP1(IDC_TXT_EDT 	, PFX_EDT);
	TTP1(IDC_TXT_RDO 	, PFX_EDT);
	TTP1(IDC_CHK		, PFX_CHK);
	TTP1(IDC_RBT1		, PFX_RBT);
	TTP1(IDC_RBT2		, PFX_RBT);
	TTP1(IDC_CBO_DDN	, PFX_CBO);
	TTP2(IDC_CBO_DDN	, PFX_CBO);
	TTP1(IDC_CBO_DDL	, PFX_CBO);
	TTP1(IDC_CBO_SBC	, PFX_CBO);
	TTP2(IDC_CBO_SBC	, PFX_CBO);
	TTP1(IDC_LST		, PFX_LST);
	TTP1(IDC_INP		, PFX_INP);
	TTP1(IDC_LBX		, PFX_LBX);
	TTP1(IDC_VTH		, PFX_VTH);
	TTP1(IDC_TCH		, PFX_TCH);

	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_CLEAR	), TEXT("上記コントロールを全てクリアー"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_LOAD		), TEXT("永続化情報読み出し\n")
													   TEXT("　　・オプション(AJCCTL_PSEL_・・) は、チェックボックスの設定内容を反映する。\n")
													   TEXT("　　・押下するとセーブボタンが有効となる。"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SAVE		), TEXT("永続化情報書き込み\n")
													   TEXT("　　・オプション(AJCCTL_PSEL_・・) は、ロード時の値が使用される。"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SAVE_EX	), TEXT("永続化情報書き込み\n")
													   TEXT("　　・オプション(AJCCTL_PSEL_・・) は、チェックボックスの設定内容を反映する。"));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, WM_DESTROY		)
{
	return TRUE;
}
//----- WM_TIMER（IDC_INP, AJCIVN_INTVALUEイベントは非同期で発生する為、ディレィ後にfLoadフラグをリセットする）-//
AJC_DLGPROC(Data, WM_TIMER			)
{
	fLoad = FALSE;
	KillTimer(hDlg, 1);
	return TRUE;
}
//----- IDC_TXT_EDT --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_TXT_EDT		)
{
	if (HIWORD(wParam) == EN_CHANGE) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_TXT_EDT  EN_CHANGE\n"));
	}
	return TRUE;
}
//----- IDC_TXT_RDO --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_TXT_RDO		)
{
	if (HIWORD(wParam) == EN_CHANGE) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_TXT_RDO  EN_CHANGE\n"));
	}
	return TRUE;
}
//----- IDC_CHK ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CHK			)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_CHK      BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_RBT1 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_RBT1			)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_RBT1     BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_RBT2 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_RBT2			)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_RBT2     BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_CBO_DDN --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CBO_DDN		)
{
	if (HIWORD(wParam) == CBN_SELENDOK) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_CBO_DDN  CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_CBO_DDL --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CBO_DDL		)
{
	if (HIWORD(wParam) == CBN_SELENDOK) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_CBO_DDL  CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_CBO_SBC --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CBO_SBC		)
{
	if (HIWORD(wParam) == CBN_SELENDOK) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_CBO_SBC  CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_INP ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_INP			)
{
	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		if (fLoad) AjcVthPrintF(hVthLog, TEXT("Event  IDC_INP      AJCIVN_INTVALUE\n"));
	}
	return TRUE;
}
//----- クリアーボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CMD_CLEAR		)
{
	AjcSetDlgItemStr	 (hDlg, IDC_TXT_EDT, TEXT(""));
	AjcSetDlgItemStr	 (hDlg, IDC_TXT_RDO, TEXT(""));
	AjcSetDlgItemChk	 (hDlg, IDC_CHK    , FALSE);
	AjcSetDlgItemChk	 (hDlg, IDC_RBT1   , TRUE );
	AjcSetDlgItemChk	 (hDlg, IDC_RBT2   , FALSE);
	AjcSetDlgItemCboReset(hDlg, IDC_CBO_DDN);
	AjcSetDlgItemCboReset(hDlg, IDC_CBO_DDL);
	AjcSetDlgItemCboReset(hDlg, IDC_CBO_SBC);
	SendDlgItemMessage	 (hDlg, IDC_LST    , LB_RESETCONTENT, 0, 0);
	AjcSetDlgItemUInt	 (hDlg, IDC_INP    , 0);
	AjcLbxResetContent	 (GetDlgItem(hDlg, IDC_LBX));
	SendDlgItemMessage	 (hDlg, IDC_VTH, WM_SETFONT, (WPARAM)AjcGetStockFont(AJCFID_FIX10), TRUE);
	AjcTchSetRealRange	 (GetDlgItem(hDlg, IDC_TCH), -2.0, 2.0);
	return TRUE;
}
//----- 初期化ボタン -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CMD_INIT		)
{
	double		t;
	double		dat[2];

	//	全項目クリアー
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_CLEAR, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_CLEAR));

	//	ダイアログ項目初期化
	AjcSetDlgItemStr	(hDlg, IDC_TXT_EDT, TEXT("Editable Text"));
	AjcSetDlgItemStr	(hDlg, IDC_TXT_RDO, TEXT("Read-Only Text"));

	AjcSetDlgItemChk	(hDlg, IDC_CHK , FALSE);
	AjcSetDlgItemChk	(hDlg, IDC_RBT1, TRUE );
	AjcSetDlgItemChk	(hDlg, IDC_RBT2, FALSE);

	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDN, -1, TEXT("Drop down 11"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDN, -1, TEXT("Drop down 12"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDN, -1, TEXT("Drop down 13"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDN, 0, 11);	//	0xB
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDN, 1, 12);	//	0xC
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDN, 2, 13);	//	0xD
	AjcSetDlgItemCboIx	(hDlg, IDC_CBO_DDN, 0);

	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDL, -1, TEXT("Drop down list 21"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDL, -1, TEXT("Drop down list 22"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_DDL, -1, TEXT("Drop down list 23"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDL, 0, 21);	//	0x15
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDL, 1, 22);	//	0x16
	AjcSetDlgItemCboData(hDlg, IDC_CBO_DDL, 2, 23);	//	0x17
	AjcSetDlgItemCboIx	(hDlg, IDC_CBO_DDL, 0);

	AjcSetDlgItemCboIns (hDlg, IDC_CBO_SBC, -1, TEXT("Subclass 1"					  ), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_SBC, -1, TEXT("Subclass 2"					  ), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIns (hDlg, IDC_CBO_SBC, -1, TEXT("Subclass 3 +++++ LongText +++++"), AJCCBF_EXCLUSION);
	AjcSetDlgItemCboIx	(hDlg, IDC_CBO_SBC, 0);

	SendDlgItemMessage	(hDlg, IDC_LST, LB_INSERTSTRING, -1, (LPARAM)TEXT("List box item 41"));
	SendDlgItemMessage	(hDlg, IDC_LST, LB_INSERTSTRING, -1, (LPARAM)TEXT("List box item 42"));
	SendDlgItemMessage	(hDlg, IDC_LST, LB_INSERTSTRING, -1, (LPARAM)TEXT("List box item 43"));
	SendDlgItemMessage	(hDlg, IDC_LST, LB_SETITEMDATA, 0, 41);	//	0x29
	SendDlgItemMessage	(hDlg, IDC_LST, LB_SETITEMDATA, 1, 42);	//	0x2A
	SendDlgItemMessage	(hDlg, IDC_LST, LB_SETITEMDATA, 2, 43);	//	0x2B
	SendDlgItemMessage	(hDlg, IDC_LST, LB_SETCURSEL   ,  0, 0);
	AjcSetDlgItemSInt	(hDlg, IDC_INP, 0);

	AjcLbxInsertString	(GetDlgItem(hDlg, IDC_LBX), -1, TEXT("Extended List item 51"));
	AjcLbxInsertString	(GetDlgItem(hDlg, IDC_LBX), -1, TEXT("Extended List item 52"));
	AjcLbxInsertString	(GetDlgItem(hDlg, IDC_LBX), -1, TEXT("Extended List item 53"));
	AjcLbxSetItemData	(GetDlgItem(hDlg, IDC_LBX), 0, 51);	//	0x33
	AjcLbxSetItemData	(GetDlgItem(hDlg, IDC_LBX), 1, 52);	//	0x34
	AjcLbxSetItemData	(GetDlgItem(hDlg, IDC_LBX), 2, 53);	//	0x35
	AjcLbxSetSel		(GetDlgItem(hDlg, IDC_LBX), 0, TRUE);

	//	VT100にダミーデータ設定
	AjcVthPutText		(GetDlgItem(hDlg, IDC_VTH), TEXT("あいうえお，かきくけこ，さしすせそ\nABCDEFGHIJKLMNOPQRSTUVWXYZ"), -1);
	//	タイムチャートにダミーデータ設定
	for (t = 0.0; t < 360.0; t++) {
		dat[0] = AjcSin(t);
		dat[1] = AjcCos(t);
		AjcTchPutRealData(GetDlgItem(hDlg, IDC_TCH), dat);
	}
	return TRUE;
}
//----- ロード ボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CMD_LOAD		)
{
	UI		opt;

	AjcVthPrintF(hVthLog, TEXT("\n----- LOAD Button Pushed -----\n"));
	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	fLoad = TRUE;
	SetTimer(hDlg, 1, 1, NULL);

	//	プロファイル記憶先を .INIファイルに設定
	AjcSetProfileIsRegistory(FALSE);
	//	現在の永続化オプション／各コントロールの永続化動作設定
	opt = SetPermOpt();
	//	プロファイルから各コントロールの設定値を読み出す
	AjcLoadAllControlSettings(hDlgData, TEXT("DataDialogItems"), opt);
	//	プロファイル記憶先を レジストリに戻す
	AjcSetProfileIsRegistory(TRUE);
	//	「ロードボタン押下時の永続化設定でセーブ」ボタン有効化
	AjcEnableDlgItem(hDlg, IDC_CMD_SAVE, TRUE);

	return TRUE;
}
//----- 「セーブ」 ボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CMD_SAVE		)
{
	//	プロファイル記憶先を .INIファイルに設定
	AjcSetProfileIsRegistory(FALSE);
	//	プロファイルセクションを削除（クリーンアップ）
	AjcDelProfileSect(TEXT("DataDialogItems"));
	//	INIファイルへ各コントロールの値をセーブ
	AjcSaveAllControlSettings(hDlg);
	//	プロファイル記憶先を レジストリに戻す
	AjcSetProfileIsRegistory(TRUE);

	return TRUE;
}
//----- 「単独セーブ」 ボタン ----------------------------------------------------------------------------------//
AJC_DLGPROC(Data, IDC_CMD_SAVE_EX	)
{
	UI		opt;

	//	プロファイル記憶先を .INIファイルに設定
	AjcSetProfileIsRegistory(FALSE);
	//	現在の永続化オプション／各コントロールの永続化動作設定
	opt = SetPermOpt();
	//	プロファイルセクションを削除（クリーンアップ）
	AjcDelProfileSect(TEXT("DataDialogItems"));
	//	INIファイルへ各コントロールの値をセーブ
	AjcSaveAllControlSettingsEx(hDlg, TEXT("DataDialogItems"), opt);
	//	プロファイル記憶先を レジストリに戻す
	AjcSetProfileIsRegistory(TRUE);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Data)
	AJC_DLGMAP_MSG(Data, WM_INITDIALOG	  		)
	AJC_DLGMAP_MSG(Data, WM_DESTROY 	  		)
	AJC_DLGMAP_MSG(Data, WM_TIMER	 	  		)

	AJC_DLGMAP_CMD(Data, IDC_TXT_EDT 	  		)
	AJC_DLGMAP_CMD(Data, IDC_TXT_RDO 	  		)
	AJC_DLGMAP_CMD(Data, IDC_CHK		  		)
	AJC_DLGMAP_CMD(Data, IDC_RBT1		  		)
	AJC_DLGMAP_CMD(Data, IDC_RBT2		  		)
	AJC_DLGMAP_CMD(Data, IDC_CBO_DDN	  		)
	AJC_DLGMAP_CMD(Data, IDC_CBO_DDL	  		)
	AJC_DLGMAP_CMD(Data, IDC_CBO_SBC	  		)

	AJC_DLGMAP_CMD(Data, IDC_INP		  		)
	AJC_DLGMAP_CMD(Data, IDC_CMD_CLEAR 	  		)
	AJC_DLGMAP_CMD(Data, IDC_CMD_INIT 	  		)
	AJC_DLGMAP_CMD(Data, IDC_CMD_LOAD 	   		)
	AJC_DLGMAP_CMD(Data, IDC_CMD_SAVE 	  		)
	AJC_DLGMAP_CMD(Data, IDC_CMD_SAVE_EX		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	永続化オプション，各コントロールの永続化動作設定															//
//--------------------------------------------------------------------------------------------------------------//
static	UI		SetPermOpt(VO)
{
	UI	opt = 0;
	UI	att = 0;

	//	永続化オプション設定
	opt = 0;
	if		(AjcGetDlgItemChk(hDlgMain, IDC_RBT_SELACT_CHKINCLUDE)) opt = AJCCTL_SELACT_CHKINCLUDE;
	else if (AjcGetDlgItemChk(hDlgMain, IDC_RBT_SELACT_CHKEXCLUDE)) opt = AJCCTL_SELACT_CHKEXCLUDE;
	else															opt = AJCCTL_SELACT_ALL;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SELACT_NTCCHK)) opt |= AJCCTL_SELACT_NTCCHK;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SELACT_NTCRBT)) opt |= AJCCTL_SELACT_NTCRBT;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SELACT_NTCCBO)) opt |= AJCCTL_SELACT_NTCCBO;
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SELACT_NTCINP)) opt |= AJCCTL_SELACT_NTCINP;
	//	永続化動作設定（IDC_TXT_EDT）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_EDT_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_EDT_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_TXT_EDT, att);
	//	永続化動作設定（IDC_TXT_RDO）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RDO_INCLUDE	) ? AJCCTL_PSEL_INCLUDE   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RDO_EXCLUDE	) ? AJCCTL_PSEL_EXCLUDE   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RDO_INCRDONLY) ? AJCCTL_PSEL_INCRDONLY : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_TXT_RDO, att);
	//	永続化動作設定（IDC_CHK）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CHK_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CHK_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CHK_NTC	  ) ? AJCCTL_PSEL_NTC	  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_CHK_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_CHK, att);
	//	永続化動作設定（IDC_RBT1）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT1_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT1_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT1_NTC    ) ? AJCCTL_PSEL_NTC	   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT1_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_RBT1, att);
	//	永続化動作設定（IDC_RBT2）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT2_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT2_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT2_NTC    ) ? AJCCTL_PSEL_NTC	   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_RBT2_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_RBT2, att);
	//	永続化動作設定（IDC_CBO_DDN）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_NTC	  ) ? AJCCTL_PSEL_NTC	  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_INCDATA) ? AJCCTL_PSEL_INCDATA : 0);
	//	ドロップダウンの場合、規定でリストは永続化されるため、以下のフラグは指定不要
//	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_INCLIST) ? AJCCTL_PSEL_INCLIST : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_EXCLIST) ? AJCCTL_PSEL_EXCLIST : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_EXCSEL ) ? AJCCTL_PSEL_EXCSEL  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDN_EXCEDIT) ? AJCCTL_PSEL_EXCEDIT : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_CBO_DDN, att);
	//	永続化動作設定（IDC_CBO_DDL）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_NTC	  ) ? AJCCTL_PSEL_NTC	  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_INCDATA) ? AJCCTL_PSEL_INCDATA : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_INCLIST) ? AJCCTL_PSEL_INCLIST : 0);
	//	ドロップダウンリストの場合、規定でリストは永続化されないため、以下のフラグは指定不要
//	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_EXCLIST) ? AJCCTL_PSEL_EXCLIST : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_DDL_EXCSEL ) ? AJCCTL_PSEL_EXCSEL  : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_CBO_DDL, att);
	//	永続化動作設定（IDC_CBO_SBC）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_NTC	  ) ? AJCCTL_PSEL_NTC	  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	//	AjcSbcComboBox()でサブクラス化したコンボボックスの場合、以下の２つのフラグは無条件にONとなる
//	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_INCDATA) ? AJCCTL_PSEL_INCDATA : 0);
//	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_INCLIST) ? AJCCTL_PSEL_INCLIST : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_EXCLIST) ? AJCCTL_PSEL_EXCLIST : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_EXCSEL ) ? AJCCTL_PSEL_EXCSEL  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_SBC_EXCEDIT) ? AJCCTL_PSEL_EXCEDIT : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_CBO_SBC, att);
	//	永続化動作設定（IDC_LST）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LST_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LST_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LST_INCDATA) ? AJCCTL_PSEL_INCDATA : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LST_EXCSEL ) ? AJCCTL_PSEL_EXCSEL  : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_LST, att);
	//	永続化動作設定（IDC_INP）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_INP_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_INP_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_INP_NTC	  ) ? AJCCTL_PSEL_NTC	  : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_INP_NONTC  ) ? AJCCTL_PSEL_NONTC   : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_INP, att);
	//	永続化動作設定（IDC_LBX）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LBX_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_LBX_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_LBX, att);
	//	永続化動作設定（IDC_VTH）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_VTH_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_VTH_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_VTH, att);
	//	永続化動作設定（IDC_TCH）
	att = 0;
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_TCH_INCLUDE) ? AJCCTL_PSEL_INCLUDE : 0);
	att |= (AjcGetDlgItemChk(hDlgMain, IDC_CHK_TCH_EXCLUDE) ? AJCCTL_PSEL_EXCLUDE : 0);
	AjcDlgItemSetPermAtt(hDlgData, IDC_TCH, att);

	return opt;
}

//--------------------------------------------------------------------------------------------------------------//
//	各コントロールのチップテキスト設定																			//
//--------------------------------------------------------------------------------------------------------------//
static	C_UTP CALLBACK cbGetTipText(HWND hCtl, UTP pBuf, UI lBuf, UX cbp)
{
	UI		id		= LOWORD(cbp);
	UI		pfx 	= HIWORD(cbp);
	C_UTP	pPrefix = szPrefix[pfx];

	int		stl;
	int		i, cnt;
	UX		dat;

	//	チップテキスト（プロファイルキー名称）設定
	AjcSnPrintF(pBuf, lBuf, TEXT("プロファイルキー : %s_%06d"), pPrefix, id);
	stl = (int)MAjcStrLen(pBuf);

	if		(MAjcStrCmp(pPrefix, TEXT("Edt")) == 0) {
		//	None
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Chk")) == 0) {
		//	None
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Rbt")) == 0) {
		//	None
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Cbo")) == 0) {
		//	チップテキストにデータ値追加
		if (cnt = AjcGetCtrlCboCount(GetDlgItem(hDlgData, id))) {
			AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("\nDATA : ")); stl = (int)MAjcStrLen(pBuf);
			for (i = 0; i < cnt; i++) {
				dat = (int)AjcGetCtrlCboData(GetDlgItem(hDlgData, id), i);
				AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("  %d"), dat); stl = (int)MAjcStrLen(pBuf);
			}
		}
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Lst")) == 0) {
		//	チップテキストにデータ値追加
		if (cnt = (int)SendMessage(hCtl, LB_GETCOUNT, 0, 0)) {
			AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("\nDATA : ")); stl = (int)MAjcStrLen(pBuf);
			for (i = 0; i < cnt; i++) {
				dat = (int)SendMessage(hCtl, LB_GETITEMDATA, i, 0);
				AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("  %d"), dat); stl = (int)MAjcStrLen(pBuf);
			}
		}
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Inp")) == 0) {
		//	None
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Lbx")) == 0) {
		//	チップテキストにデータ値追加
		if (cnt = AjcLbxGetCount(hCtl)) {
			AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("\nDATA : ")); stl = (int)MAjcStrLen(pBuf);
			for (i = 0; i < cnt; i++) {
				dat = (int)AjcLbxGetItemData(hCtl, i);
				AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("  %d"), dat); stl = (int)MAjcStrLen(pBuf);
			}
		}
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Vth")) == 0) {
		AJCVTHPROP	prop;
		//	チップテキストに設定情報追加
		AjcVthGetProp(hCtl, &prop);
		AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("\n")); stl = (int)MAjcStrLen(pBuf);
		AjcSnPrintF(&pBuf[stl], lBuf - stl,	TEXT("  lfHeight        (フォント高さ    ) = %d\n")
											TEXT("  lfWidth         (フォント幅      ) = %d\n")
											TEXT("  lfEscapement    (文字送り方向    ) = %d\n")
											TEXT("  lfOrientation   (文字の向き      ) = %d\n")
											TEXT("  lfWeight        (ボールド        ) = %d\n")
											TEXT("  lfItalic        (イタリック      ) = %d\n")
											TEXT("  lfUnderline     (アンダーライン  ) = %d\n")
											TEXT("  lfStrikeOut     (横線描画        ) = %d\n")
											TEXT("  lfCharSet       (文字セット      ) = %d\n")
											TEXT("  lfOutPrecision  (一致方法        ) = %d\n")
											TEXT("  lfClipPrecision (クリッピング    ) = %d\n")
											TEXT("  lfQuality       (照合方法        ) = %d\n")
											TEXT("  lfPitchAndFamily(ピッチ＆ファミリ) = 0x%02X\n")
											TEXT("  lfFaceName      (フォント名      ) = %s\n")
											TEXT("  LSpace          (行間スペース    ) = %d\n"),
			prop.LogFont.lfHeight			,		//	lfHeight		 
			prop.LogFont.lfWidth			,		//	lfWidth 		 
			prop.LogFont.lfEscapement		,		//	lfEscapement	 
			prop.LogFont.lfOrientation		,		//	lfOrientation	 
			prop.LogFont.lfWeight			,		//	lfWeight		 
			prop.LogFont.lfItalic			,		//	lfItalic		 
			prop.LogFont.lfUnderline		,		//	lfUnderline 	 
			prop.LogFont.lfStrikeOut		,		//	lfStrikeOut 	 
			prop.LogFont.lfCharSet			,		//	lfCharSet		 
			prop.LogFont.lfOutPrecision		,		//	lfOutPrecision	 
			prop.LogFont.lfClipPrecision	,		//	lfClipPrecision  
			prop.LogFont.lfQuality			,		//	lfQuality		 
			prop.LogFont.lfPitchAndFamily	,		//	lfPitchAndFamily 
			prop.LogFont.lfFaceName			,		//	lfFaceName		 
			prop.LSpace								//	LSpace			 
		);
	}
	else if (MAjcStrCmp(pPrefix, TEXT("Tch")) == 0) {
		AJCTCGAUINFO	gau;
		//	チップテキストに設定情報追加
		AjcTchGetGauInfo(hCtl, &gau);
		AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("\n")); stl = (int)MAjcStrLen(pBuf);
		AjcSnPrintF(&pBuf[stl], lBuf - stl,	TEXT("  GauBarL     (ゲージ低位置    ) = %d\n")
											TEXT("  GauBarH     (ゲージ高位置    ) = %d\n")
											TEXT("  fGauUseMes  (単位時間種別    ) = %d\n")
											TEXT("  GauSetUTime (単位時間(設定値)) = %d"),
			gau.GauBarL 					,		//	GauBarL
			gau.GauBarH 					,		//	GauBarH 
			gau.fGauUseMes					,		//	fGauUseMes
			gau.GauSetUTime 						//	GauSetUTime
		);
	}

	return pBuf;
}
