﻿//
//	SW_DlgItem3.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hEdt, hRdo, hChA, hChB, hRbA, hRbB;
static	HWND			hDdn, hDdl, hStd, hSgl, hMul;
static	HWND			hInp, hVth, hTch;
static	HWND			hLog;

static	HICON			hIcoOpen;
static	HICON			hIcoClear;
static	AJCVTHPROP		VthProp;  UI VthSty;
static	AJCTCPROP		TchProp;  UI TchSty;

static	BOOL			fLoad	 = FALSE;				//	ロード処理中を示すフラグ

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SUB);
static	UI	GetCboOpt(HWND hDlg, UI idTop);

static	C_UTP CALLBACK cbGetTipTextCboLst	(HWND hCtl, UTP pBuf, UI lBuf, UX cbp);
static	C_UTP CALLBACK cbGetTipTextTxtChkRbt(HWND hwnd, UTP pBuf, UI lBuf, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
#define	TTP1(ID, CB)																							\
 AjcTipTextAddEx	  (GetDlgItem(hDlg, ID), TEXT(""), 300, 5000, AjcGetStockFont(AJCFID_FIX12), -1, -1, -1);	\
 AjcTipTextSetCallBack(GetDlgItem(hDlg, ID), ID, NULL, CB)

#define	TTP2(ID, CB)																													  \
 AjcTipTextAddEx	  (AjcSbcGetEditCtrlInComboBox(GetDlgItem(hDlg, ID)), TEXT(""), 300, 5000, AjcGetStockFont(AJCFID_FIX12), -1, -1, -1);\
 AjcTipTextSetCallBack(AjcSbcGetEditCtrlInComboBox(GetDlgItem(hDlg, ID)), ID, NULL, CB)

//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hEdt = GetDlgItem(hDlg, IDC_TXT_EDT);	hDdn = GetDlgItem(hDlg, IDC_CBO_DDN);
	hRdo = GetDlgItem(hDlg, IDC_TXT_RDO);	hDdl = GetDlgItem(hDlg, IDC_CBO_DDL);
	hChA = GetDlgItem(hDlg, IDC_CHK_A  );	hStd = GetDlgItem(hDlg, IDC_CBO_STD);
	hChB = GetDlgItem(hDlg, IDC_CHK_B  );	hSgl = GetDlgItem(hDlg, IDC_LST_SGL);
	hRbA = GetDlgItem(hDlg, IDC_RBT_A  );	hMul = GetDlgItem(hDlg, IDC_LST_MUL);
	hRbB = GetDlgItem(hDlg, IDC_RBT_B  );
	hInp = GetDlgItem(hDlg, IDC_INP);
	hVth = GetDlgItem(hDlg, IDC_VTH);
	hTch = GetDlgItem(hDlg, IDC_TCH);
	hLog = GetDlgItem(hDlg, IDC_VTH_LOG);
	//	プロファイルをINIファイルとする
	AjcSetProfileIsRegistory(FALSE);
	//	アイコン生成
	hIcoOpen  = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_OPEN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	hIcoClear = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_DEL ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	//	ボタンへアイコン表示
	SendDlgItemMessage(hDlg, IDC_CMD_INIOPEN , BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoOpen);
	SendDlgItemMessage(hDlg, IDC_CMD_INICLEAR, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIcoClear);
	//	ツールチップ設定
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_COPYTORDO), TEXT("テキストをコピーします"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_INIOPEN	), TEXT("INIファイルを開く"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_INICLEAR ), TEXT("INIファイルをクリアーする"));
	//	ツールチップテキスト・コールバック設定（ＴＸＴ，ＣＨＫ，ＲＢＴ）
	TTP1(IDC_TXT_EDT, cbGetTipTextTxtChkRbt);
	TTP1(IDC_TXT_RDO, cbGetTipTextTxtChkRbt);
	TTP1(IDC_CHK_A	, cbGetTipTextTxtChkRbt);
	TTP1(IDC_CHK_B	, cbGetTipTextTxtChkRbt);
	TTP1(IDC_RBT_A	, cbGetTipTextTxtChkRbt);
	TTP1(IDC_RBT_B	, cbGetTipTextTxtChkRbt);
	//	ツールチップテキスト・コールバック設定（ＣＢＯ，ＬＳＴ）
	TTP2(IDC_CBO_DDN, cbGetTipTextCboLst);
	TTP1(IDC_CBO_DDL, cbGetTipTextCboLst);
	TTP2(IDC_CBO_STD, cbGetTipTextCboLst);
	TTP1(IDC_LST_SGL, cbGetTipTextCboLst);
	TTP1(IDC_LST_MUL, cbGetTipTextCboLst);

	//	オプションフラグ・チェックボックス群ロード
	AjcDlgLoadGrpControlSettings(hDlg, IDC_GRP_CHKS, TEXT("Flag Settings"), AJCCTL_SELACT_ALL);
	//	ＶＴＨプロパティ
	AjcVthGetProp(hVth, &VthProp);
	VthSty = (UI)MAjcGetWindowLong(hVth, GWL_STYLE);
	//	ＴＣＨプロパティ
	AjcTchGetProp(hVth, &TchProp);
	TchSty = (UI)MAjcGetWindowLong(hTch, GWL_STYLE);
	//	コントロール群初期化
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_INIT, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_INIT));
	//	コンボボックス，リストボックスをサブクラス化（項目の追加、削除機能をつける）
	MAjcMmpSetSubclass(SUB, AjcSbcGetEditCtrlInComboBox(hDdn));
	MAjcMmpSetSubclass(SUB, hDdl);
	MAjcMmpSetSubclass(SUB, AjcSbcGetEditCtrlInComboBox(hStd));
	MAjcMmpSetSubclass(SUB, hSgl);
	MAjcMmpSetSubclass(SUB, hMul);

	AjcSetDlgItemUInt(hDlg, IDC_INP, 0);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	チェックボックス群セーブ
	AjcDlgSaveGrpControlSettings(hDlg, IDC_GRP_CHKS);
	//	アイコン破棄
	if (hIcoOpen  != NULL) {DeleteObject(hIcoOpen); hIcoOpen = NULL;}
	if (hIcoClear != NULL) {DeleteObject(hIcoClear); hIcoClear = NULL;}
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- WM_TIMER（IDC_INP, AJCIVN_INTVALUEイベントは非同期で発生する為、ディレィ後にfLoadフラグをリセットする）-//
AJC_DLGPROC(Main, WM_TIMER			)
{
	fLoad = FALSE;
	KillTimer(hDlg, 1);
	return TRUE;
}
//----- INIファイルを開くボタン --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INIOPEN	)
{
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	ShellExecute(NULL, TEXT("open"), path, NULL, NULL, SW_SHOWNORMAL);
	return TRUE;
}
//----- INIファイル クリアー ボタン ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INICLEAR	)
{
	HANDLE	hFile;
	UT		path[MAX_PATH];
	AjcGetIniFilePath(path, MAX_PATH);
	DeleteFile(path);
	if ((hFile = CreateFile(path, GENERIC_WRITE, FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
		CloseHandle(hFile);
	}
	return TRUE;
}
//----- 初期化ボタン -------------------------------------------------------------------------------------------//
#define		INS_CBOITEM(ID, IX, TXT, DAT)	SendDlgItemMessage(hDlg, ID, CB_INSERTSTRING, IX, (LPARAM)TXT); \
											SendDlgItemMessage(hDlg, ID, CB_SETITEMDATA , IX, (LPARAM)DAT)
											
#define		INS_LSTITEM(ID, IX, TXT, DAT)	SendDlgItemMessage(hDlg, ID, LB_INSERTSTRING, IX, (LPARAM)TXT); \
											SendDlgItemMessage(hDlg, ID, LB_SETITEMDATA , IX, (LPARAM)DAT)
											
AJC_DLGPROC(Main, IDC_CMD_INIT		)
{
	double	t;
	double	val[3];

	AjcSetDlgItemStr(hDlg, IDC_TXT_EDT	, TEXT("Edittable"));
	AjcSetDlgItemStr(hDlg, IDC_TXT_RDO	, TEXT("Read Only"));
	AjcSetDlgItemChk(hDlg, IDC_CHK_A		, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_B		, FALSE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_A		, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_B		, FALSE);

	SendDlgItemMessage (hDlg, IDC_CBO_DDN, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage (hDlg, IDC_CBO_DDL, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage (hDlg, IDC_CBO_STD, CB_RESETCONTENT, 0, 0);
	SendDlgItemMessage (hDlg, IDC_LST_SGL, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage (hDlg, IDC_LST_MUL, LB_RESETCONTENT, 0, 0);

	INS_CBOITEM(IDC_CBO_DDN, 0, TEXT("DDN-1"), 100);
	INS_CBOITEM(IDC_CBO_DDN, 1, TEXT("DDN-2"), 101);
	INS_CBOITEM(IDC_CBO_DDL, 0, TEXT("DDL-1"), 200);
	INS_CBOITEM(IDC_CBO_DDL, 1, TEXT("DDL-2"), 201);
	INS_CBOITEM(IDC_CBO_STD, 0, TEXT("STD-1"), 300);
	INS_CBOITEM(IDC_CBO_STD, 1, TEXT("STD-2"), 301);
	INS_LSTITEM(IDC_LST_SGL, 0, TEXT("SGL-1"), 400);
	INS_LSTITEM(IDC_LST_SGL, 1, TEXT("SGL-2"), 401);
	INS_LSTITEM(IDC_LST_MUL, 0, TEXT("MUL-1"), 500);
	INS_LSTITEM(IDC_LST_MUL, 1, TEXT("MUL-2"), 501);

	AjcSetDlgItemCboIx (hDlg, IDC_CBO_DDN, 0);
	AjcSetDlgItemCboIx (hDlg, IDC_CBO_DDL, 0);
	AjcSetDlgItemCboIx (hDlg, IDC_CBO_STD, 0);

	AjcVthSetProp(hVth, &VthProp);
	MAjcSetWindowLong(hVth, GWL_STYLE, VthSty);
	AjcVthClear(hVth);
	AjcVthPrintF(hVth, TEXT("VT-100\nあいうえお"));

	AjcTchSetProp(hVth, &TchProp);
	MAjcSetWindowLong(hTch, GWL_STYLE, TchSty);
	AjcTchPurge(hTch);
	for (t = 0; t < AJC_PAI; t += 1.0 / 180.0 * AJC_PAI) {
		//	Sin, Cos, Tan 値データ生成／投与
		val[0] = sin(t);
		val[1] = cos(t);
		val[2] = tan(t);
		val[2] = __min(val[2],	2.0);
		val[2] = __max(val[2], -2.0);
		AjcTchPutRealData(hTch, val);
	}

	return TRUE;
}
//----- エディットテキストを読み出し専用テキストへコピー -------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_COPYTORDO	)
{
	UT		txt[256];
	AjcGetDlgItemStr(hDlg, IDC_TXT_EDT, txt, 256);
	AjcSetDlgItemStr(hDlg, IDC_TXT_RDO, txt);
	return TRUE;
}
//----- エディットテキスト ロード ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDEDT		)
{
	
	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	SetTimer(hDlg, 1, 1, NULL);
	AjcVthPrintF(hLog, TEXT("\n--- Load TXT-EDT button ---\n"));
	AjcDlgItemLoadTextBoxEx(hDlg, IDC_TXT_EDT, TEXT("IDC_TXT_EDT"), AjcGetDlgItemChk(hDlg, IDC_CHK_EDT_FEXC));
	return TRUE;
}
//----- エディットテキスト セーブ ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVEDT		)
{
	AjcDlgItemSaveTextBoxEx(hDlg, IDC_TXT_EDT, TEXT("IDC_TXT_EDT"), AjcGetDlgItemChk(hDlg, IDC_CHK_EDT_FEXC));
	return TRUE;
}
//----- 読み出し専用テキスト ロード ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDRDO		)
{
	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load TXT-RDO button ---\n"));
	AjcDlgItemLoadTextBoxEx(hDlg, IDC_TXT_RDO, TEXT("IDC_TXT_RDO"), AjcGetDlgItemChk(hDlg, IDC_CHK_RDO_FEXC));
	return TRUE;
}
//----- 読み出し専用テキスト セーブ ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVRDO		)
{
	AjcDlgItemSaveTextBoxEx(hDlg, IDC_TXT_RDO, TEXT("IDC_TXT_RDO"), AjcGetDlgItemChk(hDlg, IDC_CHK_RDO_FEXC));
	return TRUE;
}
//----- チェックボックス ロード --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDCHK		)
{
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_CHK_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load CHK button -------\n"));
	AjcDlgItemLoadChkBox(hDlg, IDC_CHK_A, TEXT("IDC_CHK_"), fNtc);
	AjcDlgItemLoadChkBox(hDlg, IDC_CHK_B, TEXT("IDC_CHK_"), fNtc);
	return TRUE;
}
//----- チェックボックス セーブ --------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVCHK		)
{
	AjcDlgItemSaveChkBox(hDlg, IDC_CHK_A, TEXT("IDC_CHK_"));
	AjcDlgItemSaveChkBox(hDlg, IDC_CHK_B, TEXT("IDC_CHK_"));
	return TRUE;
}
//----- ラジオボタン ロード ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDRBT		)
{
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_RBT_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load RBT button -------\n"));
	AjcDlgItemLoadChkBox(hDlg, IDC_RBT_A, TEXT("IDC_RBT_"), fNtc);
	AjcDlgItemLoadChkBox(hDlg, IDC_RBT_B, TEXT("IDC_RBT_"), fNtc);
	return TRUE;
}
//----- ラジオボタン セーブ ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVRBT		)
{
	AjcDlgItemSaveChkBox(hDlg, IDC_RBT_A, TEXT("IDC_RBT_"));
	AjcDlgItemSaveChkBox(hDlg, IDC_RBT_B, TEXT("IDC_RBT_"));
	return TRUE;
}
//----- コンボボックス（ドロップダウン） ロード ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDDDN		)
{
	UI		sel = GetCboOpt 	   (hDlg, IDC_CHK_DDN_INCDATA);
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_DDN_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load CBO-DDN button ---\n"));
	AjcDlgItemLoadComboBox(hDlg, IDC_CBO_DDN, TEXT("IDC_CBO_DDN"), sel, fNtc);
	return TRUE;
}
//----- コンボボックス（ドロップダウン） セーブ ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVDDN		)
{
	UI		sel = GetCboOpt 	   (hDlg, IDC_CHK_DDN_INCDATA);
	AjcDlgItemSaveComboBox(hDlg, IDC_CBO_DDN, TEXT("IDC_CBO_DDN"), sel);
	return TRUE;
}
//----- コンボボックス（ドロップダウンリスト） ロード ----------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDDDL		)
{
	UI		sel = GetCboOpt 	   (hDlg, IDC_CHK_DDL_INCDATA);
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_DDL_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load CBO-DDL button ---\n"));
	AjcDlgItemLoadComboBox(hDlg, IDC_CBO_DDL, TEXT("IDC_CBO_DDL"), sel, fNtc);
	return TRUE;
}
//----- コンボボックス（ドロップダウンリスト） セーブ ----------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVDDL		)
{
	UI	sel = GetCboOpt(hDlg, IDC_CHK_DDL_INCDATA);
	AjcDlgItemSaveComboBox(hDlg, IDC_CBO_DDL, TEXT("IDC_CBO_DDL"), sel);
	return TRUE;
}
//----- コンボボックス（標準） ロード --------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDSTD		)
{
	UI		sel = GetCboOpt 	   (hDlg, IDC_CHK_STD_INCDATA);
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_STD_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load CBO-STD button ---\n"));
	AjcDlgItemLoadComboBox(hDlg, IDC_CBO_STD, TEXT("IDC_CBO_STD"), sel, fNtc);
	return TRUE;
}
//----- コンボボックス（標準） セーブ --------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVSTD		)
{
	UI	sel = GetCboOpt(hDlg, IDC_CHK_STD_INCDATA);

	AjcDlgItemSaveComboBox(hDlg, IDC_CBO_STD, TEXT("IDC_CBO_STD"), sel);
	return TRUE;
}
//----- リストボックス（シングルセレクト） ロード --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDSGL		)
{
	UI	sel = 0;

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SGL_INCDATA)) sel |= AJCCTL_PSEL_INCDATA;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SGL_EXCSEL )) sel |= AJCCTL_PSEL_EXCSEL;
	AjcDlgItemLoadListBox(hDlg, IDC_LST_SGL, TEXT("IDC_LST_SGL"), sel);
	return TRUE;
}
//----- リストボックス（シングルセレクト） セーブ --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVSGL		)
{
	UI	sel = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SGL_INCDATA)) sel |= AJCCTL_PSEL_INCDATA;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SGL_EXCSEL )) sel |= AJCCTL_PSEL_EXCSEL;
	AjcDlgItemSaveListBox(hDlg, IDC_LST_SGL, TEXT("IDC_LST_SGL"), sel);
	return TRUE;
}
//----- リストボックス（マルチセレクト） ロード ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDMUL		)
{
	UI	sel = 0;

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_MUL_INCDATA)) sel |= AJCCTL_PSEL_INCDATA;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_MUL_EXCSEL )) sel |= AJCCTL_PSEL_EXCSEL;
	AjcDlgItemLoadListBox(hDlg, IDC_LST_MUL, TEXT("IDC_LST_MUL"), sel);
	return TRUE;
}
//----- リストボックス（マルチセレクト） セーブ ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVMUL		)
{
	UI	sel = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_MUL_INCDATA)) sel |= AJCCTL_PSEL_INCDATA;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_MUL_EXCSEL )) sel |= AJCCTL_PSEL_EXCSEL;
	AjcDlgItemSaveListBox(hDlg, IDC_LST_MUL, TEXT("IDC_LST_MUL"), sel);
	return TRUE;
}
//----- ＩＮＰ ロード ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDINP		)
{
	BOOL	fNtc = AjcGetDlgItemChk(hDlg, IDC_CHK_INP_FNTC);

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	AjcVthPrintF(hLog, TEXT("\n--- Load INP button -------\n"));
	AjcIvLoadPermInfo(hInp, TEXT("INP"), TEXT("VAL"), fNtc);
	return TRUE;
}
//----- ＩＮＰ セーブ ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVINP		)
{
	AjcIvSavePermInfoEx(hInp, TEXT("INP"), TEXT("VAL"));
	return TRUE;
}
//----- ＶＴＨ ロード ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDVTH		)
{
	UI	PermItem = 0;

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_LFACT)) PermItem |= AJCVTH_PERM_LFACT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_FONT )) PermItem |= AJCVTH_PERM_FONT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_VRAM )) PermItem |= AJCVTH_PERM_VRAM;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_OTHER)) PermItem |= AJCVTH_PERM_OTHER;
	AjcVthLoadPermInfoEx(hVth, TEXT("VTH"), TEXT("Vth"), PermItem);
	return TRUE;
}
//----- ＶＴＨ セーブ ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVVTH		)
{
	UI	PermItem = 0;

	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_LFACT)) PermItem |= AJCVTH_PERM_LFACT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_FONT )) PermItem |= AJCVTH_PERM_FONT;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_VRAM )) PermItem |= AJCVTH_PERM_VRAM;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_VTH_OTHER)) PermItem |= AJCVTH_PERM_OTHER;
	AjcVthSavePermInfoEx(hVth, TEXT("VTH"), TEXT("Vth"), PermItem);
	return TRUE;
}
//----- ＴＣＨ ロード ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_LDTCH		)
{
	UI	PermItem = 0;

	fLoad = TRUE; SetTimer(hDlg, 1, 1, NULL);	//	ロード中の旨、フラグ設定（フラグ解除はタイマで遅延する）
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_FILTER)) PermItem |= AJCTCH_PERM_FILTER;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_RANGE )) PermItem |= AJCTCH_PERM_RANGE;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_OTHER )) PermItem |= AJCTCH_PERM_OTHER;
	AjcTchLoadPermInfoEx(hTch, TEXT("TCH"), TEXT("Tch"), PermItem);
	return TRUE;
}
//----- ＴＣＨ セーブ ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SVTCH		)
{
	UI	PermItem = 0;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_FILTER)) PermItem |= AJCTCH_PERM_FILTER;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_RANGE )) PermItem |= AJCTCH_PERM_RANGE;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_TCH_OTHER )) PermItem |= AJCTCH_PERM_OTHER;
	AjcTchSavePermInfoEx(hTch, TEXT("TCH"), TEXT("Tch"), PermItem);
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- IDC_TXT_EDT --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_TXT_EDT		)
{
	if (HIWORD(wParam) == EN_CHANGE && fLoad) {
		AjcVthPrintF(hLog, TEXT("  TXT_EDT : EN_CHANGE\n"));
	}
	return TRUE;
}
//----- IDC_TXT_RDO --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_TXT_RDO		)
{
	if (HIWORD(wParam) == EN_CHANGE && fLoad) {
		AjcVthPrintF(hLog, TEXT("  TXT_RDO : EN_CHANGE\n"));
	}
	return TRUE;
}
//----- IDC_CHK_A ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_A			)
{
	if (HIWORD(wParam) == BN_CLICKED && fLoad) {
		AjcVthPrintF(hLog, TEXT("  CHK_A   : BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_CHK_B ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_B			)
{
	if (HIWORD(wParam) == BN_CLICKED && fLoad) {
		AjcVthPrintF(hLog, TEXT("  CHK_B   : BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_RBT_A ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_A			)
{
	if (HIWORD(wParam) == BN_CLICKED && fLoad) {
		AjcVthPrintF(hLog, TEXT("  RBT_A   : BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_RBT_B ----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_B			)
{
	if (HIWORD(wParam) == BN_CLICKED && fLoad) {
		AjcVthPrintF(hLog, TEXT("  RBT_B   : BN_CLICKED\n"));
	}
	return TRUE;
}
//----- IDC_CBO_DDN --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_DDN		)
{
	if (HIWORD(wParam) == CBN_SELENDOK && fLoad) {
		AjcVthPrintF(hLog, TEXT("  CBO_DDN : CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_CBO_DDL --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_DDL		)
{
	if (HIWORD(wParam) == CBN_SELENDOK && fLoad) {
		AjcVthPrintF(hLog, TEXT("  CBO_DDL : CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_CBO_STD --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_STD		)
{
	if (HIWORD(wParam) == CBN_SELENDOK && fLoad) {
		AjcVthPrintF(hLog, TEXT("  CBO_STD : CBN_SELENDOK\n"));
	}
	return TRUE;
}
//----- IDC_INP ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP			)
{
	if (fLoad) {
		switch (HIWORD(wParam)) {
			case AJCIVN_INTVALUE:	AjcVthPrintF(hLog, TEXT("  INP     : AJCIVN_INTVALUE\n"));	break;
			case AJCIVN_REALVALUE:	AjcVthPrintF(hLog, TEXT("  INP     : AJCIVN_REALVALUE\n"));	break;
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_TIMER	 		)

	AJC_DLGMAP_CMD(Main, IDC_CMD_INIOPEN	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_INICLEAR	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_INIT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_COPYTORDO	)

	AJC_DLGMAP_CMD(Main, IDC_CMD_LDEDT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVEDT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDRDO		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVRDO		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDCHK		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVCHK		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDRBT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVRBT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDDDN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVDDN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDDDL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVDDL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDSTD		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVSTD		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDSGL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVSGL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDMUL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVMUL		)

	AJC_DLGMAP_CMD(Main, IDC_CMD_LDINP		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVINP		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDVTH		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVVTH		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_LDTCH		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SVTCH		)

	AJC_DLGMAP_CMD(Main, IDC_TXT_EDT		)
	AJC_DLGMAP_CMD(Main, IDC_TXT_RDO		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_A			)
	AJC_DLGMAP_CMD(Main, IDC_CHK_B			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_A			)
	AJC_DLGMAP_CMD(Main, IDC_RBT_B			)
	AJC_DLGMAP_CMD(Main, IDC_CBO_DDN		)
	AJC_DLGMAP_CMD(Main, IDC_CBO_DDL		)
	AJC_DLGMAP_CMD(Main, IDC_CBO_STD		)
	AJC_DLGMAP_CMD(Main, IDC_INP			)

	AJC_DLGMAP_CMD(Main, IDCANCEL			)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックス，リストボックスをサブクラス化したウインドプロシージャ										//
//--------------------------------------------------------------------------------------------------------------//
#define	IDM_INSERT	5001
#define	IDM_DELETE	5002
#define	IDM_NOTSEL	5003
#define	IDM_RESET 	5004

AJC_WNDPROC(SUB, WM_RBUTTONDOWN			)
{
	POINT	pt;
	HMENU	hMenu;
	BOOL	fCbo;
	UI		Count, cid, mid;
	UT		cname[MAX_PATH];
	UT		txt [256] = {0};

	//	クラス名取得（コンボボックス／リストボックス／エディット）
	GetClassName(hwnd, cname, MAX_PATH);
	//	コンボボックス下のエディットコントロールの場合、コンボボックスのハンドルに置き換える
	if (MAjcStrICmp(cname, TEXT("Edit")) == 0) {
		hwnd = GetParent(hwnd);
	}
	//	クラス名取得（コンボボックス／リストボックス）
	GetClassName(hwnd, cname, MAX_PATH);
	//	自身がコンボボックスである旨のフラグ設定
	fCbo = (MAjcStrICmp(cname, TEXT("ComboBox")) == 0);
	//	リスト項目数設定
	Count = (UI)SendMessage(hwnd, (fCbo ? CB_GETCOUNT : LB_GETCOUNT), 0, 0);
	//	ダイアログ項目番号設定
	cid   = (UI)MAjcGetWindowLong(hwnd, GWL_ID);
	//	ポップアップメニュー処理
	hMenu = CreatePopupMenu();
	AppendMenu(hMenu, MFT_STRING, IDM_INSERT, TEXT("１項目追加"));
	if (Count != 0) {
		AppendMenu(hMenu, MFT_STRING, IDM_DELETE, TEXT("１項目削除"));
		AppendMenu(hMenu, MFT_STRING, IDM_NOTSEL, TEXT("非選択状態"));
		AppendMenu(hMenu, MFT_STRING, IDM_RESET , TEXT("リセット"  ));
	}
	GetCursorPos(&pt);
	mid = TrackPopupMenu(hMenu, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, 0, hwnd, NULL);
	DestroyMenu(hMenu);
	switch (mid) {
		UI	ix = 0, n = 0;
		case IDM_INSERT:		//	●１項目追加
			switch (cid) {
				case IDC_CBO_DDN: AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("DDN-%d"), Count + 1); n = 100; break;
				case IDC_CBO_DDL: AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("DDL-%d"), Count + 1); n = 200; break;
				case IDC_CBO_STD: AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("STD-%d"), Count + 1); n = 300; break;
				case IDC_LST_SGL: AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("SGL-%d"), Count + 1); n = 400; break;
				case IDC_LST_MUL: AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("MUL-%d"), Count + 1); n = 500; break;
			}
			ix = (UI)SendMessage(hwnd, (fCbo ? CB_INSERTSTRING : LB_INSERTSTRING), -1, (LPARAM)txt);
					 SendMessage(hwnd, (fCbo ? CB_SETITEMDATA  : LB_SETITEMDATA ), ix, n + ix);
			break;

		case IDM_DELETE:		//	●１項目削除
			SendMessage (hwnd, (fCbo ? CB_DELETESTRING : LB_DELETESTRING), 0, 0);
			break;

		case IDM_NOTSEL:		//	●非選択状態
			if (fCbo) {
				SendMessage (hwnd, (fCbo ? CB_SETCURSEL : LB_RESETCONTENT), -1, 0);
			}
			else {
				if (cid == IDC_LST_SGL) SendMessage (hwnd, LB_SETCURSEL, -1, 0);
				else					SendMessage (hwnd, LB_SELITEMRANGE, FALSE, MAKELONG(0, Count -1));
			}
			break;

		case IDM_RESET:			//	●リセット
			SendMessage (hwnd, (fCbo ? CB_RESETCONTENT : LB_RESETCONTENT), 0, 0);
			break;
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB)
	AJC_WNDMAP_MSG(SUB, WM_RBUTTONDOWN	)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスのオプションフラグ取得																		//
//--------------------------------------------------------------------------------------------------------------//
static	UI	GetCboOpt(HWND hDlg, UI idTop)
{
	UI	rc = 0;

	if (AjcGetDlgItemChk(hDlg, idTop + 0)) rc |= AJCCTL_PSEL_INCDATA;
	if (AjcGetDlgItemChk(hDlg, idTop + 1)) rc |= AJCCTL_PSEL_INCLIST;
	if (AjcGetDlgItemChk(hDlg, idTop + 2)) rc |= AJCCTL_PSEL_EXCSEL;
	if (AjcGetDlgItemChk(hDlg, idTop + 3)) rc |= AJCCTL_PSEL_EXCLIST;
	if (AjcGetDlgItemChk(hDlg, idTop + 4)) rc |= AJCCTL_PSEL_EXCEDIT;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	テキストボックス，チェックボックス，ラジオボタンのチップテキスト設定										//
//--------------------------------------------------------------------------------------------------------------//
static	C_UTP CALLBACK cbGetTipTextTxtChkRbt(HWND hwnd, UTP pBuf, UI lBuf, UX cbp)
{
	//	チップテキスト（ＩＤ番号）設定
	AjcSnPrintF(pBuf, lBuf, TEXT("id = %06d"), (UI)cbp);
	return pBuf;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックス，リストボックスのチップテキスト設定															//
//--------------------------------------------------------------------------------------------------------------//
static	C_UTP CALLBACK cbGetTipTextCboLst(HWND hwnd, UTP pBuf, UI lBuf, UX cbp)
{
	UI		id		= (UI)cbp;
	BOOL	fCbo;
	UI		Count, ix, stl;
	UI		dat;
	UT		cname[MAX_PATH];

	//	チップテキスト（ＩＤ番号）設定
	AjcSnPrintF(pBuf, lBuf, TEXT("id = %06d\n"), id);
	stl = (int)MAjcStrLen(pBuf);

	//	クラス名取得（コンボボックス／リストボックス／エディット）
	GetClassName(hwnd, cname, MAX_PATH);
	//	コンボボックス下のエディットコントロールの場合、コンボボックスのハンドルに置き換える
	if (MAjcStrICmp(cname, TEXT("Edit")) == 0) {
		hwnd = GetParent(hwnd);
	}
	//	クラス名取得（コンボボックス／リストボックス）
	GetClassName(hwnd, cname, MAX_PATH);
	//	自身がコンボボックスである旨のフラグ設定
	fCbo = (MAjcStrICmp(cname, TEXT("ComboBox")) == 0);
	//	リスト項目数設定
	Count = (UI)SendMessage(hwnd, (fCbo ? CB_GETCOUNT : LB_GETCOUNT), 0, 0);

	if (Count != 0) {
		AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("DATA Values - \n")); stl = (int)MAjcStrLen(pBuf);
		for (ix = 0; ix < Count; ix++) {
			dat = (UI)SendMessage(hwnd, (fCbo ? CB_GETITEMDATA : LB_GETITEMDATA), ix, 0);
			AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("   %2d: %3d\n"), ix, dat); stl = (int)MAjcStrLen(pBuf);
		}
	}
	else {
		AjcSnPrintF(&pBuf[stl], lBuf - stl, TEXT("No Data"));
	}

	return pBuf;
}
