﻿//
//	SW_FileDir01.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVth;
static	BOOL	fBusy = FALSE;
static	BOOL	fCan  = FALSE;
static	BOOL	fEnd  = FALSE;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	UTP		CALLBACK cbDirQuery    (C_UTP pPathFront, UTP pNewDir, UX cbp);
static	BOOL	CALLBACK cbDirNotify   (C_UTP pPathFrom, C_UTP pPathTo, EAJCCFS ntc, UX cbp);
static	UTP		CALLBACK cbFileQuery   (C_UTP pFileFrom, C_UTP pFileTo, UTP pFileName, UIP pAtt, UX cbp);
static	BOOL	CALLBACK cbFileNotify  (C_UTP pFileFrom, C_UTP pFileTo , EAJCCFS ntc, UX cbp);
static	BOOL	CALLBACK cbCopyProgress(ULL FileSize, ULL Copied, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	コールバック																								//
//																												//
//==============================================================================================================//
//	フォルダ問い合わせ
static	UTP CALLBACK cbDirQuery(C_UTP pPathFront, UTP pNewDir, UX cbp)
{
	UTP		rc = pNewDir;
	HWND	hDlg = (HWND)cbp;
	UT		path[MAX_PATH];

	AjcDoEvent();
	if (!(fCan || fEnd)) {
		AjcVthPrintF(hVth, TEXT("DIR_QUERY  : Name = %s"), pNewDir);
		//	コピーしないフォルダ名
		if		(AjcGetDlgItemChk(hDlg, IDC_CHK_NOCPYDIR)) {
			UT	ncp[MAX_PATH];
			AjcGetDlgItemStr(hDlg, IDC_TXT_NOCPYDIR, ncp, MAX_PATH);
			if (MAjcStrICmp(pNewDir, ncp) == 0) {
				AjcVthPrintF(hVth, TEXT("（コピーしないファイル）"), pPathFront, pNewDir);
				rc = NULL;
			}
		}
		//	リネーム
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_CHGDIR)) {
			UT	bfr[MAX_PATH];
			UT	aft[MAX_PATH];
			AjcGetDlgItemStr(hDlg, IDC_TXT_DIRBFR, bfr, MAX_PATH);
			AjcGetDlgItemStr(hDlg, IDC_TXT_DIRAFT, aft, MAX_PATH);
			if (MAjcStrICmp(pNewDir, bfr) == 0) {
				AjcVthPrintF(hVth, TEXT("    ReName to %s\n"), aft);
				MAjcStrCpy(pNewDir, MAX_PATH, aft);
			}
		}
		//	同一フォルダありを表示
		MAjcStrCpy(path, MAX_PATH, pPathFront);
		AjcPathCat(path, pNewDir, MAX_PATH);
		if (AjcPathExists(path)) {
			AjcVthPrintF(hVth, TEXT("（既に同一パスが存在します。）"));
		}
		AjcVthPrintF(hVth, TEXT("\n"));
	}
	return rc;
}
//	フォルダ作成通知
static	BOOL CALLBACK cbDirNotify(C_UTP pPathFrom, C_UTP pPathTo, EAJCCFS ntc, UX cbp)
{
	BOOL	rc	 = TRUE;
	HWND	hDlg = (HWND)cbp;
	UI		opt  = AJCCPF_NONE;
	UT		wild[MAX_PATH];

	AjcDoEvent();
	if (!(fCan || fEnd)) {
		AjcVthPrintF(hVth, TEXT("DIR_NOTIFY : %s\n")
						   TEXT("          -> %s\n"),  pPathFrom, pPathTo);
		if (ntc == AJCCFS_SUCCESS || ntc == AJCCFS_EXIST) {
			UTP		pWild = NULL;
			//	フォルダ内ファイルコピー
			if (AjcGetDlgItemChk(hDlg, IDC_CHK_CREATEALWAYS)) opt |= AJCCPF_CREATEALWAYS;
			if (AjcGetDlgItemChk(hDlg, IDC_RBT_WILDEXC     )) opt |= AJCCPF_WILDEXC;
			AjcGetDlgItemStr(hDlg, IDC_TXT_WILD , wild, MAX_PATH);
			if (wild[0] != 0) pWild = wild;
			if (!AjcCopyFilesEx(pPathFrom, pPathTo, pWild, opt, cbp, cbFileNotify, cbFileQuery, cbCopyProgress)) {
				rc = FALSE;
			}
		}
	}
	else rc = FALSE;

	return rc;
}
//	ファイル問い合わせ
static	UTP CALLBACK cbFileQuery(C_UTP pFileFrom, C_UTP pFileTo, UTP pFileName, UIP pAtt, UX cbp)
{
	UTP		rc = pFileName;
	HWND	hDlg = (HWND)cbp;

	AjcDoEvent();
	if (!(fCan || fEnd)) {
		AjcVthPrintF(hVth, TEXT("FILE_QUERY : Name = %s\n"), pFileName);
		//	コピーしないフォルダ名
		if		(AjcGetDlgItemChk(hDlg, IDC_CHK_NOCPYFILE)) {
			UT	ncp[MAX_PATH];
			AjcGetDlgItemStr(hDlg, IDC_TXT_NOCPYFILE, ncp, MAX_PATH);
			if (MAjcStrICmp(pFileName, ncp) == 0) {
				AjcVthPrintF(hVth, TEXT("    Not Copy\n"));
				rc = NULL;
			}
		}
		//	リネーム
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_CHGFILE)) {
			UT	bfr[MAX_PATH];
			UT	aft[MAX_PATH];
			AjcGetDlgItemStr(hDlg, IDC_TXT_FILEBFR, bfr, MAX_PATH);
			AjcGetDlgItemStr(hDlg, IDC_TXT_FILEAFT, aft, MAX_PATH);
			if (MAjcStrICmp(pFileName, bfr) == 0) {
				AjcVthPrintF(hVth, TEXT("    ReName to %s\n"), aft);
				MAjcStrCpy(pFileName, MAX_PATH, aft);
			}
		}
	}
	return rc;
}
//	ファイル作成通知
static	BOOL CALLBACK cbFileNotify(C_UTP pFileFrom, C_UTP pFileTo, EAJCCFS ntc, UX cbp)
{
	BOOL	rc	 = TRUE;
	HWND	hDlg = (HWND)cbp;
	AjcDoEvent();
	if (!(fCan || fEnd)) {
		AjcVthPrintF(hVth, TEXT("FILE_NOTIFY: %s\n")
						   TEXT("          -> %s\n"), pFileFrom, pFileTo);
	}
	else rc = FALSE;

	return rc;
}
//	ファイルコピー状況通知
static	BOOL CALLBACK cbCopyProgress(ULL FileSize, ULL Copied, UX cbp)
{
	BOOL	rc	 = TRUE;
	HWND	hDlg = (HWND)cbp;
	AjcDoEvent();
	if (!(fCan || fEnd)) {
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);

	hVth	 = GetDlgItem(hDlg, IDC_VTH);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH1, AJCDROP_DIR);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH2, AJCDROP_DIR);
	AjcSetDlgItemChk(hDlg, IDC_RBT_SAMETIME, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_WILDINC , TRUE);
	AjcLoadAllControlSettings(hDlg, TEXT("Main"), AJCCTL_SELACT_ALL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcSaveAllControlSettings(hDlg);
	PostQuitMessage(0);
	return TRUE;
}
//----- 「実行」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RUN		)
{
	int		rsu;
	UI		opt = 0;
	UT		src [MAX_PATH];
	UT		dst [MAX_PATH];

	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, TRUE);
	fCan = fEnd = FALSE;
	fBusy = TRUE;
	//	コピーするパス名設定
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH1, src , MAX_PATH);
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH2, dst , MAX_PATH);
	//	コピー先クリーンアップ
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_CLEAN)) {
		AjcCleanFolder(dst, 0, NULL);
	}
	//	オプション設定
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_SAMETIME  )) opt |= AJCFSC_SAMETIME;
	if (AjcGetDlgItemChk(hDlg, IDC_RBT_FORCETIME )) opt |= AJCFSC_FORCETIME;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_MAKETOP	 )) opt |= AJCFSC_MAKETOP;
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ALLOWEXIST)) opt |= AJCFSC_ALLOWEXIST;
	//	フォルダ構造コピー
	rsu = AjcCopyFolderStructEx(src, dst, opt, (UX)hDlg, cbDirNotify, cbDirQuery);
	//	結果表示
	if (rsu) AjcVthPrintF(hVth, TEXT("\n正常に終了しました\n\n"));
	else     AjcVthPrintF(hVth, TEXT("\nエラー／中止しました\n\n"));
	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, FALSE);
	fBusy = FALSE;
	if (fEnd) DestroyWindow(hDlg);
	return TRUE;
}
//----- 「中止」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (fBusy) fCan = TRUE;
	return TRUE;
}
//----- 「Cancel」 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fBusy) fEnd = TRUE;
	else DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	
	AJC_DLGMAP_CMD(Main, IDC_CMD_RUN	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

